/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.rpg_minibosses.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderSystem.class})
public abstract class RenderSystemMixin {
    @Shadow
    private static float shaderGameTime;

    @Inject(at={@At(value="HEAD")}, method={"setShaderGameTime"}, cancellable=true)
    private static void setShaderGameTimeRPG(long time, float tickDelta, CallbackInfo info) {
        float f = ((float)(time % 24000L) + tickDelta) / 24000.0f;
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderGameTime = 18000.0f;
            });
        } else {
            shaderGameTime = 18000.0f;
        }
    }
}

