/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.content;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.paladins.content.PaladinSounds;
import net.paladins.effect.PaladinEffects;
import net.paladins.entity.BarrierEntity;
import net.spell_engine.api.render.LightEmission;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.util.TriState;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

public class PaladinSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    private static final String GROUP_PRIMARY = "primary";
    private static final class_2960 HOLY_SPARKS = SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.FLOAT).id();
    private static final class_2960 HOLY_SPARK_DECELERATE = SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id();
    private static final class_2960 HOLY_IMPACT_DECELERATE = SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id();
    private static final class_2960 HOLY_IMPACT_FLOAT = SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.FLOAT).id();
    private static final class_2960 HOLY_IMPACT_BURST = SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.BURST).id();
    private static final class_2960 HEALING_PARTICLES = SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id();
    private static final class_2960 HOLY_SPELL_FLOAT = SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.FLOAT).id();
    private static final class_2960 HOLY_SPELL_DECELERATE = SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id();
    public static final Entry FLASH_HEAL = PaladinSpells.add(PaladinSpells.flash_heal());
    public static final Entry DIVINE_PROTECTION = PaladinSpells.add(PaladinSpells.divine_protection());
    public static final Entry JUDGEMENT = PaladinSpells.add(PaladinSpells.judgement());
    public static final Entry BATTLE_BANNER = PaladinSpells.add(PaladinSpells.battle_banner());
    public static final Entry HEAL = PaladinSpells.add(PaladinSpells.heal());
    public static final Entry HOLY_SHOCK = PaladinSpells.add(PaladinSpells.holy_shock());
    public static final Entry HOLY_BEAM = PaladinSpells.add(PaladinSpells.holy_beam());
    public static final Entry CIRCLE_OF_HEALING = PaladinSpells.add(PaladinSpells.circle_of_healing());
    public static final Entry BARRIER = PaladinSpells.add(PaladinSpells.barrier());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        return spell;
    }

    private static Spell.Impact createEffectImpact(class_2960 effectId, float duration) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        buff.action.status_effect = new Spell.Impact.Action.StatusEffect();
        buff.action.status_effect.effect_id = effectId.toString();
        buff.action.status_effect.duration = duration;
        return buff;
    }

    private static Spell.Impact createHeal(float coefficient) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.HEAL;
        buff.action.heal = new Spell.Impact.Action.Heal();
        buff.action.heal.spell_power_coefficient = coefficient;
        return buff;
    }

    private static Spell.Impact createDamage(float coefficient, float knockback) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.DAMAGE;
        buff.action.damage = new Spell.Impact.Action.Damage();
        buff.action.damage.spell_power_coefficient = coefficient;
        buff.action.damage.knockback = knockback;
        return buff;
    }

    private static Spell.Impact.TargetModifier createImpactModifier(String entityType) {
        Spell.TargetCondition condition = new Spell.TargetCondition();
        condition.entity_type = entityType;
        Spell.Impact.TargetModifier modifier = new Spell.Impact.TargetModifier();
        modifier.conditions = List.of(condition);
        return modifier;
    }

    private static ParticleBatch castingParticles(String particleId) {
        return new ParticleBatch(particleId, ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = duration;
    }

    private static void configureItemCost(Spell spell, String itemId) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.item = new Spell.Cost.Item();
        spell.cost.item.id = itemId;
    }

    private static Spell.Impact.TargetModifier extraDamageAgainstUndead() {
        Spell.Impact.TargetModifier modifier = PaladinSpells.createImpactModifier("#minecraft:undead");
        Spell.Impact.Modifier powerModifier = new Spell.Impact.Modifier();
        powerModifier.power_multiplier = 0.5f;
        modifier.modifier = powerModifier;
        return modifier;
    }

    private static Spell.Impact.TargetModifier extraCritAgainstUndead() {
        Spell.Impact.TargetModifier modifier = PaladinSpells.createImpactModifier("#minecraft:undead");
        Spell.Impact.Modifier powerModifier = new Spell.Impact.Modifier();
        powerModifier.critical_chance_bonus = 1.0f;
        modifier.modifier = powerModifier;
        return modifier;
    }

    private static void impactDeniedForMechanical(Spell.Impact impact) {
        Spell.Impact.TargetModifier modifier = PaladinSpells.createImpactModifier("#spell_engine:mechanical");
        modifier.execute = TriState.DENY;
        impact.target_modifiers = List.of(modifier);
    }

    private static Entry flash_heal() {
        class_2960 id = class_2960.method_60655((String)"paladins", (String)"flash_heal");
        String title = "Flash Heal";
        String description = "";
        Spell spell = PaladinSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 16.0f;
        spell.tier = 1;
        spell.group = GROUP_PRIMARY;
        spell.active.cast.duration = 0.5f;
        spell.active.cast.animation = "spell_engine:one_handed_healing_charge";
        spell.active.cast.sound = Sound.withRandomness((class_2960)SpellEngineSounds.GENERIC_HEALING_CASTING.id(), (float)0.0f);
        spell.active.cast.particles = new ParticleBatch[]{PaladinSpells.castingParticles(HOLY_SPARKS.toString())};
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = Sound.withRandomness((class_2960)SpellEngineSounds.GENERIC_HEALING_RELEASE.id(), (float)0.0f);
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.use_caster_as_fallback = true;
        Spell.Impact heal = PaladinSpells.createHeal(1.2f);
        PaladinSpells.impactDeniedForMechanical(heal);
        heal.particles = new ParticleBatch[]{new ParticleBatch(HEALING_PARTICLES.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 30.0f, 0.02f, 0.15f)};
        heal.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_1.id());
        spell.impacts = List.of(heal);
        PaladinSpells.configureCooldown(spell, 6.0f);
        PaladinSpells.configureItemCost(spell, "runes:healing_stone");
        spell.cost.exhaust = 0.2f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry divine_protection() {
        class_2960 id = class_2960.method_60655((String)"paladins", (String)"divine_protection");
        String title = "Divine Protection";
        String description = "";
        Spell spell = PaladinSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 0.0f;
        spell.tier = 2;
        spell.release.animation = "spell_engine:one_handed_area_release";
        Spell.Impact buff = PaladinSpells.createEffectImpact(PaladinEffects.DIVINE_PROTECTION.id, 8.0f);
        buff.action.status_effect.amplifier = 0;
        buff.action.status_effect.amplifier_cap = 2;
        buff.action.status_effect.amplifier_power_multiplier = 0.5f;
        buff.sound = new Sound(PaladinSounds.divine_protection_release.id());
        buff.particles = new ParticleBatch[]{new ParticleBatch(HOLY_IMPACT_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 40.0f, 0.2f, 0.2f)};
        spell.impacts = List.of(buff);
        PaladinSpells.configureCooldown(spell, 30.0f);
        PaladinSpells.configureItemCost(spell, "runes:healing_stone");
        spell.cost.exhaust = 0.3f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry judgement() {
        class_2960 id = class_2960.method_60655((String)"paladins", (String)"judgement");
        String title = "Judgement";
        String description = "";
        Spell spell = PaladinSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.range = 16.0f;
        spell.tier = 3;
        spell.active.cast.duration = 0.5f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = Sound.withRandomness((class_2960)SpellEngineSounds.GENERIC_HEALING_CASTING.id(), (float)0.0f);
        spell.active.cast.particles = new ParticleBatch[]{PaladinSpells.castingParticles(HOLY_SPARKS.toString())};
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.required = true;
        spell.target.aim.sticky = true;
        spell.deliver.type = Spell.Delivery.Type.METEOR;
        Spell.Delivery.Meteor meteor = new Spell.Delivery.Meteor();
        meteor.launch_height = 12.0f;
        meteor.launch_properties.velocity = 1.2f;
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 1.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 15;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(HOLY_IMPACT_FLOAT.toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 5.0f, 0.0f, 0.1f, 0.0f), new ParticleBatch(HOLY_SPARKS.toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 4.0f, 0.0f, 0.1f, 0.0f)};
        Spell.ProjectileModel model = new Spell.ProjectileModel();
        model.light_emission = LightEmission.RADIATE;
        model.model_id = "paladins:projectile/judgement";
        model.scale = 1.2f;
        projectile.client_data.model = model;
        meteor.projectile = projectile;
        spell.deliver.meteor = meteor;
        Spell.Impact damage = PaladinSpells.createDamage(0.9f, 1.0f);
        damage.target_modifiers = List.of(PaladinSpells.extraDamageAgainstUndead());
        damage.particles = new ParticleBatch[]{new ParticleBatch(HOLY_IMPACT_BURST.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.2f, 1.0f)};
        Spell.Impact stun = PaladinSpells.createEffectImpact(PaladinEffects.JUDGEMENT.id, 3.0f);
        stun.action.status_effect.apply_limit = new Spell.Impact.Action.StatusEffect.ApplyLimit();
        stun.action.status_effect.apply_limit.health_base = 50.0f;
        stun.action.status_effect.apply_limit.spell_power_multiplier = 2.0f;
        spell.impacts = List.of(damage, stun);
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.radius = 6.0f;
        spell.area_impact.area.distance_dropoff = Spell.Target.Area.DropoffCurve.SQUARED;
        spell.area_impact.particles = new ParticleBatch[]{new ParticleBatch(HOLY_IMPACT_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 100.0f, 0.8f, 0.9f), new ParticleBatch(HOLY_SPARKS.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 100.0f, 0.2f, 0.4f), new ParticleBatch("smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 50.0f, 0.1f, 0.3f)};
        spell.area_impact.sound = Sound.withVolume((class_2960)PaladinSounds.judgement_impact.id(), (float)1.5f);
        PaladinSpells.configureCooldown(spell, 15.0f);
        PaladinSpells.configureItemCost(spell, "runes:healing_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry battle_banner() {
        class_2960 id = class_2960.method_60655((String)"paladins", (String)"battle_banner");
        String title = "Battle Banner";
        String description = "";
        Spell spell = PaladinSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 0.0f;
        spell.tier = 4;
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(PaladinSounds.battle_banner_release.id());
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 3.0f;
        cloud.volume.extra_radius = new Spell.AreaImpact.ExtraRadius();
        cloud.volume.extra_radius.power_coefficient = 1.0f;
        cloud.volume.extra_radius.power_cap = 4.0f;
        cloud.volume.area.vertical_range_multiplier = 0.3f;
        cloud.presence_sound = Sound.withRandomness((class_2960)PaladinSounds.battle_banner_presence.id(), (float)0.0f);
        cloud.impact_tick_interval = 10;
        cloud.time_to_live_seconds = 10.0f;
        cloud.client_data = new Spell.Delivery.Cloud.ClientData();
        cloud.client_data.light_level = 15;
        cloud.client_data.model = new Spell.ProjectileModel();
        cloud.client_data.model.model_id = "paladins:effect/battle_banner";
        cloud.client_data.model.rotate_degrees_per_tick = 0.0f;
        cloud.client_data.model.light_emission = LightEmission.NONE;
        cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(HOLY_SPARK_DECELERATE.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, null, 15.0f, 0.1f, 0.15f, 0.0f, 0.0f), new ParticleBatch(HOLY_SPELL_FLOAT.toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.FEET, null, 3.0f, 0.05f, 0.1f, 0.0f, 0.0f)};
        cloud.placement = new Spell.EntityPlacement();
        cloud.placement.location_offset_by_look = 2.0f;
        cloud.placement.location_yaw_offset = 20.0f;
        cloud.placement.apply_yaw = true;
        spell.deliver.clouds = List.of(cloud);
        Spell.Impact buff = PaladinSpells.createEffectImpact(PaladinEffects.BATTLE_BANNER.id, 2.0f);
        spell.impacts = List.of(buff);
        PaladinSpells.configureCooldown(spell, 45.0f);
        PaladinSpells.configureItemCost(spell, "runes:healing_stone");
        spell.cost.exhaust = 0.3f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry heal() {
        class_2960 id = class_2960.method_60655((String)"paladins", (String)"heal");
        String title = "Heal";
        String description = "";
        Spell spell = PaladinSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.group = GROUP_PRIMARY;
        spell.range = 16.0f;
        spell.tier = 0;
        spell.learn = null;
        spell.active.scroll = null;
        spell.active.cast.duration = 1.0f;
        spell.active.cast.animation = "spell_engine:one_handed_healing_charge";
        spell.active.cast.sound = Sound.withRandomness((class_2960)SpellEngineSounds.GENERIC_HEALING_CASTING.id(), (float)0.0f);
        spell.active.cast.particles = new ParticleBatch[]{PaladinSpells.castingParticles(HOLY_SPARKS.toString())};
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.use_caster_as_fallback = true;
        Spell.Impact heal = PaladinSpells.createHeal(0.75f);
        PaladinSpells.impactDeniedForMechanical(heal);
        heal.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_1.id());
        heal.particles = new ParticleBatch[]{new ParticleBatch(HEALING_PARTICLES.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 20.0f, 0.02f, 0.15f)};
        spell.impacts = List.of(heal);
        PaladinSpells.configureCooldown(spell, 4.0f);
        PaladinSpells.configureItemCost(spell, "runes:healing_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry holy_shock() {
        class_2960 id = class_2960.method_60655((String)"paladins", (String)"holy_shock");
        String title = "Holy Shock";
        String description = "";
        Spell spell = PaladinSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.group = GROUP_PRIMARY;
        spell.tier = 1;
        spell.range = 16.0f;
        spell.active.cast.duration = 1.5f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = Sound.withRandomness((class_2960)SpellEngineSounds.GENERIC_HEALING_CASTING.id(), (float)0.0f);
        spell.active.cast.particles = new ParticleBatch[]{PaladinSpells.castingParticles(HOLY_SPARKS.toString())};
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.sticky = true;
        spell.target.aim.use_caster_as_fallback = true;
        Spell.Impact heal = PaladinSpells.createHeal(0.5f);
        PaladinSpells.impactDeniedForMechanical(heal);
        heal.particles = new ParticleBatch[]{new ParticleBatch(HEALING_PARTICLES.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 15.0f, 0.02f, 0.15f), new ParticleBatch(HOLY_IMPACT_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.2f, 0.25f)};
        heal.sound = new Sound(PaladinSounds.holy_shock_heal.id());
        Spell.Impact damage = PaladinSpells.createDamage(1.0f, 0.5f);
        damage.target_modifiers = List.of(PaladinSpells.extraCritAgainstUndead());
        damage.particles = new ParticleBatch[]{new ParticleBatch(HOLY_IMPACT_BURST.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 30.0f, 0.2f, 0.7f)};
        damage.sound = new Sound(PaladinSounds.holy_shock_damage.id());
        spell.impacts = List.of(heal, damage);
        PaladinSpells.configureItemCost(spell, "runes:healing_stone");
        spell.cost.exhaust = 0.2f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry holy_beam() {
        class_2960 id = class_2960.method_60655((String)"paladins", (String)"holy_beam");
        String title = "Holy Light";
        String description = "";
        Spell spell = PaladinSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 32.0f;
        spell.tier = 2;
        spell.active.cast.duration = 5.0f;
        spell.active.cast.channel_ticks = 4;
        spell.active.cast.animation = "spell_engine:two_handed_channeling";
        spell.active.cast.start_sound = new Sound(PaladinSounds.holy_beam_start_casting.id());
        spell.active.cast.sound = Sound.withRandomness((class_2960)PaladinSounds.holy_beam_casting.id(), (float)0.0f);
        spell.active.cast.particles = new ParticleBatch[]{new ParticleBatch(HOLY_SPARKS.toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.LAUNCH_POINT, ParticleBatch.Rotation.LOOK, 3.0f, 0.1f, 0.2f, 0.0f), new ParticleBatch("firework", ParticleBatch.Shape.PIPE, ParticleBatch.Origin.LAUNCH_POINT, ParticleBatch.Rotation.LOOK, 0.5f, 0.1f, 0.2f, 0.0f)};
        spell.release.sound = new Sound(PaladinSounds.holy_beam_release.id());
        spell.target.type = Spell.Target.Type.BEAM;
        Spell.Target.Beam beam = new Spell.Target.Beam();
        beam.color_rgba = 0xFFCC66FFL;
        beam.flow = 1.5f;
        beam.block_hit_particles = new ParticleBatch[]{new ParticleBatch(HOLY_SPELL_FLOAT.toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.1f, 0.2f, 0.0f), new ParticleBatch("firework", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.1f, 0.2f, 0.0f), new ParticleBatch(HOLY_SPARKS.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 5.0f, 0.1f, 0.2f)};
        spell.target.beam = beam;
        Spell.Impact heal = PaladinSpells.createHeal(0.5f);
        PaladinSpells.impactDeniedForMechanical(heal);
        heal.particles = new ParticleBatch[]{new ParticleBatch(HEALING_PARTICLES.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 1.0f, 0.02f, 0.15f), new ParticleBatch(HOLY_IMPACT_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 1.0f, 0.2f, 0.25f)};
        heal.sound = new Sound(PaladinSounds.holy_beam_heal.id());
        Spell.Impact damage = PaladinSpells.createDamage(0.8f, 0.5f);
        damage.target_modifiers = List.of(PaladinSpells.extraCritAgainstUndead());
        damage.particles = new ParticleBatch[]{new ParticleBatch(HOLY_IMPACT_BURST.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 3.0f, 0.2f, 0.7f), new ParticleBatch(HOLY_SPARKS.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 6.0f, 0.2f, 0.4f)};
        damage.sound = new Sound(PaladinSounds.holy_beam_damage.id());
        spell.impacts = List.of(heal, damage);
        PaladinSpells.configureCooldown(spell, 10.0f);
        spell.cost.cooldown.proportional = true;
        spell.cost.exhaust = 0.2f;
        PaladinSpells.configureItemCost(spell, "runes:healing_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry circle_of_healing() {
        class_2960 id = class_2960.method_60655((String)"paladins", (String)"circle_of_healing");
        String title = "Circle of Healing";
        String description = "";
        float range = 8.0f;
        Spell spell = PaladinSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = range;
        spell.tier = 3;
        spell.active.cast.duration = 0.5f;
        spell.active.cast.animation = "spell_engine:one_handed_area_charge";
        spell.active.cast.sound = Sound.withRandomness((class_2960)SpellEngineSounds.GENERIC_HEALING_CASTING.id(), (float)0.0f);
        spell.active.cast.particles = new ParticleBatch[]{PaladinSpells.castingParticles(HOLY_SPARKS.toString())};
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(HOLY_SPARK_DECELERATE.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 100.0f, 0.3f, 0.5f).extent(range - 0.5f), new ParticleBatch(HOLY_SPELL_DECELERATE.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 50.0f, 0.1f, 0.5f).extent(range - 0.5f), new ParticleBatch(HOLY_IMPACT_FLOAT.toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.FEET, 50.0f, 0.1f, 0.2f).extent(range)};
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.vertical_range_multiplier = 0.6f;
        spell.target.area.include_caster = true;
        Spell.Impact heal = PaladinSpells.createHeal(0.4f);
        PaladinSpells.impactDeniedForMechanical(heal);
        heal.particles = new ParticleBatch[]{new ParticleBatch(HEALING_PARTICLES.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 15.0f, 0.02f, 0.15f), new ParticleBatch(HOLY_IMPACT_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.2f, 0.25f)};
        heal.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_2.id());
        Spell.Impact buff = PaladinSpells.createEffectImpact(PaladinEffects.ABSORPTION.id, 6.0f);
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        buff.action.status_effect.amplifier_power_multiplier = 0.25f;
        spell.impacts = List.of(heal, buff);
        PaladinSpells.configureCooldown(spell, 10.0f);
        PaladinSpells.configureItemCost(spell, "runes:healing_stone");
        spell.cost.exhaust = 0.3f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry barrier() {
        class_2960 id = class_2960.method_60655((String)"paladins", (String)"barrier");
        String title = "Barrier";
        String description = "";
        Spell spell = PaladinSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 4.0f;
        spell.tier = 4;
        spell.active.cast.duration = 0.5f;
        spell.active.cast.animation = "spell_engine:one_handed_area_charge";
        spell.active.cast.sound = Sound.withRandomness((class_2960)SpellEngineSounds.GENERIC_HEALING_CASTING.id(), (float)0.0f);
        spell.active.cast.particles = new ParticleBatch[]{PaladinSpells.castingParticles(HOLY_SPARKS.toString())};
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.release.sound = new Sound(PaladinSounds.holy_barrier_activate.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(HOLY_SPELL_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 50.0f, 1.0f, 1.0f)};
        Spell.Impact spawn = new Spell.Impact();
        spawn.action = new Spell.Impact.Action();
        spawn.action.type = Spell.Impact.Action.Type.SPAWN;
        Spell.Impact.Action.Spawn barrier = new Spell.Impact.Action.Spawn();
        barrier.entity_type_id = ((class_5321)BarrierEntity.TYPE.method_40124().method_40230().get()).method_29177().toString();
        barrier.time_to_live_seconds = 10;
        spawn.action.spawns = List.of(barrier);
        spell.impacts = List.of(spawn);
        PaladinSpells.configureCooldown(spell, 40.0f);
        PaladinSpells.configureItemCost(spell, "runes:healing_stone");
        spell.cost.exhaust = 0.4f;
        return new Entry(id, spell, title, description, null);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

