/*
 * Decompiled with CFR 0.152.
 */
package com.jackbusters.xtraarrows.lists.backend.configurations;

import net.neoforged.neoforge.common.ModConfigSpec;

public class ArrowServerConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.ConfigValue<Boolean> enableIronArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableGoldenArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableDiamondArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableNetheriteArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableExplosiveArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> explosiveArrowsDamageBlocks;
    public static final ModConfigSpec.ConfigValue<Double> explosiveArrowsRadius;
    public static final ModConfigSpec.ConfigValue<Boolean> enableLightningArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> lightningArrowsVisualOnly;
    public static final ModConfigSpec.ConfigValue<Boolean> lightningArrowsCauseFire;
    public static final ModConfigSpec.ConfigValue<Boolean> enableTorchArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableRedstoneTorchArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableSoulTorchArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableSlimeArrows;
    public static final ModConfigSpec.ConfigValue<Double> slimeArrowsBounceMultiplier;
    public static final ModConfigSpec.ConfigValue<Integer> slimeArrowsBounceAmount;
    public static final ModConfigSpec.ConfigValue<Boolean> enableEnderArrows;
    public static final ModConfigSpec.ConfigValue<Double> enderArrowFallDamage;
    public static final ModConfigSpec.ConfigValue<Boolean> enableVexingArrows;
    public static final ModConfigSpec.ConfigValue<Integer> vexingPhaseAmount;
    public static final ModConfigSpec.ConfigValue<Boolean> enableTrackingArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableAtlanteanArrows;
    public static final ModConfigSpec.ConfigValue<Double> atlanteanInertia;
    public static final ModConfigSpec.ConfigValue<Boolean> enableFreezingArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableGravityArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableLanternArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableSoulLanternArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableLifeStealArrows;
    public static final ModConfigSpec.ConfigValue<Integer> lifeStealAmount;
    public static final ModConfigSpec.ConfigValue<Boolean> enableMagneticArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableBreedingArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableCupidsArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableAppleArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableGoldenAppleArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableEnchantedGoldenAppleArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableIncendiaryArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableExtinguishingArrows;
    public static final ModConfigSpec.ConfigValue<Boolean> enableLeashingArrows;
    public static final ModConfigSpec SPEC;

    static {
        BUILDER.push("Disable/Modify Arrows");
        BUILDER.comment("Save these changes while world is not open.");
        enableIronArrows = BUILDER.comment("If set to false, iron arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableIronArrows", true);
        enableGoldenArrows = BUILDER.comment("If set to false, golden arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableGoldenArrows", true);
        enableDiamondArrows = BUILDER.comment("If set to false, diamond arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableDiamondArrows", true);
        enableNetheriteArrows = BUILDER.comment("If set to false, netherite arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableNetheriteArrows", true);
        enableExplosiveArrows = BUILDER.comment("If set to false, explosive arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableExplosiveArrows", true);
        explosiveArrowsDamageBlocks = BUILDER.comment("If set to false, explosions from explosive arrows will not damage blocks.").worldRestart().define("explosiveArrowsDamageBlocks", true);
        explosiveArrowsRadius = BUILDER.comment("Defines the radius of the explosions caused by explosive arrows.").worldRestart().defineInRange("explosiveArrowsRadius", 2.5, 0.0, 1000.0);
        enableLightningArrows = BUILDER.comment("If set to false, lightning arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableLightningArrows", true);
        lightningArrowsVisualOnly = BUILDER.comment("If set to true, the lightning spawned by lightning arrows will have no impact on the world or the entities in it. It will be only appear visually.").worldRestart().define("lightningArrowsVisualOnly", false);
        lightningArrowsCauseFire = BUILDER.comment("If set to false, the lightning spawned by lightning arrows will not cause fire at the point of impact.").worldRestart().define("lightningArrowsCauseFire", true);
        enableTorchArrows = BUILDER.comment("If set to false, torch arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableTorchArrows", true);
        enableRedstoneTorchArrows = BUILDER.comment("If set to false, redstone torch arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableRedstoneTorchArrows", true);
        enableSoulTorchArrows = BUILDER.comment("If set to false, soul torch arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableSoulTorchArrows", true);
        enableSlimeArrows = BUILDER.comment("If set to false, slime arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableSlimeArrows", true);
        slimeArrowsBounceMultiplier = BUILDER.comment("Defines the bounce multiplier of slime arrows.").worldRestart().defineInRange("slimeArrowsBounceMultiplier", 10.0, 0.0, 1000.0);
        slimeArrowsBounceAmount = BUILDER.comment("Defines how many times slime arrows bounce before coming to a stop.").worldRestart().defineInRange("slimeArrowsBounceAmount", 5, 0, 1000);
        enableEnderArrows = BUILDER.comment("If set to false, ender arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableEnderArrows", true);
        enderArrowFallDamage = BUILDER.comment("Defines fall damage caused by teleportation from ender arrows.").worldRestart().defineInRange("enderArrowFallDamage", 2.0, 0.0, 1000.0);
        enableVexingArrows = BUILDER.comment("If set to false, vexing arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableVexingArrows", true);
        vexingPhaseAmount = BUILDER.comment("Defines how many times a vexing arrow will phase through connected blocks before coming to a stop.").worldRestart().defineInRange("vexingPhaseAmount", 1, 0, 1000);
        enableTrackingArrows = BUILDER.comment("If set to false, tracking arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableTrackingArrows", true);
        enableAtlanteanArrows = BUILDER.comment("If set to false, atlantean arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableAtlanteanArrows", true);
        atlanteanInertia = BUILDER.comment("Defines underwater inertia for atlantean arrows.").worldRestart().defineInRange("atlanteanInertia", 0.99, 0.0, 0.99);
        enableFreezingArrows = BUILDER.comment("If set to false, freezing arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableFreezingArrows", true);
        enableGravityArrows = BUILDER.comment("If set to false, gravity arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableGravityArrows", true);
        enableLanternArrows = BUILDER.comment("If set to false, lantern arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableLanternArrows", true);
        enableSoulLanternArrows = BUILDER.comment("If set to false, soul lantern arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableSoulLanternArrows", true);
        enableLifeStealArrows = BUILDER.comment("If set to false, life steal arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableLifeStealArrows", true);
        lifeStealAmount = BUILDER.comment("Defines amount of health life steal arrows will steal from target. 1 = 1/6 Current Health, 2 = 1/5 Current Health, 3 = 1/4 Current Health, 4 = 1/3 Current Health").worldRestart().defineInRange("lifeStealAmount", 1, 1, 4);
        enableMagneticArrows = BUILDER.comment("If set to false, magnetic arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableMagneticArrows", true);
        enableBreedingArrows = BUILDER.comment("If set to false, breeding arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableBreedingArrows", true);
        enableCupidsArrows = BUILDER.comment("If set to false, Cupid's arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableCupidsArrows", true);
        enableAppleArrows = BUILDER.comment("If set to false, apple arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableAppleArrows", true);
        enableGoldenAppleArrows = BUILDER.comment("If set to false, golden apple arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableGoldenAppleArrows", true);
        enableEnchantedGoldenAppleArrows = BUILDER.comment("If set to false, enchanted golden apple arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableEnchantedGoldenAppleArrows", true);
        enableIncendiaryArrows = BUILDER.comment("If set to false, incendiary arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableIncendiaryArrows", true);
        enableExtinguishingArrows = BUILDER.comment("If set to false, extinguishing arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableExtinguishingArrows", true);
        enableLeashingArrows = BUILDER.comment("If set to false, leashing arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableLeashingArrows", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

