/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.pixeldreamstudios.journal.config.JournalConfig;
import net.pixeldreamstudios.journal.data.JournalComponent;
import net.pixeldreamstudios.journal.data.JournalComponents;
import net.pixeldreamstudios.journal.network.SyncJournalPayload;

public class JournalCommands {
    private static final SuggestionProvider<class_2168> SUGGEST_DISCOVERED_MOBS = (context, builder) -> {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        JournalComponent journal = (JournalComponent)JournalComponents.JOURNAL.get((Object)player);
        return class_2172.method_9257(journal.getDiscovered().keySet().stream(), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"journal").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"unlock_all").executes(JournalCommands::unlockAll))).then(class_2170.method_9247((String)"clear_all").executes(JournalCommands::clearAll))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"mob", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_DISCOVERED_MOBS).executes(JournalCommands::removeMob))));
    }

    private static int unlockAll(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        JournalComponent journal = (JournalComponent)JournalComponents.JOURNAL.get((Object)player);
        int unlocked = 0;
        for (class_1299 type : class_7923.field_41177) {
            class_2960 id;
            class_1297 entity;
            if (!type.method_5896() || !((entity = type.method_5883(player.method_37908())) instanceof class_1309) || JournalConfig.isBlacklisted(id = class_7923.field_41177.method_10221((Object)type)) || !journal.unlockMob(id)) continue;
            ++unlocked;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncJournalPayload(journal.getDiscovered()));
        int finalUnlocked = unlocked;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u2705 Unlocked " + finalUnlocked + " mobs in the journal.")), false);
        return unlocked;
    }

    private static int clearAll(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        JournalComponent journal = (JournalComponent)JournalComponents.JOURNAL.get((Object)player);
        journal.clearDiscovered();
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncJournalPayload(Collections.emptyMap()));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared all discovered mobs in the journal."), false);
        return 1;
    }

    private static int removeMob(CommandContext<class_2168> context) {
        class_2960 id;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        JournalComponent journal = (JournalComponent)JournalComponents.JOURNAL.get((Object)player);
        if (journal.removeMob(id = class_2232.method_9443(context, (String)"mob"))) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u274c Removed mob from journal: " + String.valueOf(id))), false);
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncJournalPayload(journal.getDiscovered()));
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u26a0\ufe0f Mob not found in journal: " + String.valueOf(id))), false);
        return 0;
    }
}

