/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_6880;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.class_93;
import net.pixeldreamstudios.journal.mixin.CombinedEntryAccessor;
import net.pixeldreamstudios.journal.mixin.ItemEntryAccessor;
import net.pixeldreamstudios.journal.mixin.LootPoolAccessor;
import net.pixeldreamstudios.journal.mixin.LootTableAccessor;
import net.pixeldreamstudios.journal.mixin.LootTableEntryAccessor;

public class AllLootTableItems {
    public static Set<class_1792> getAllItemsFromLootTable(class_5321<class_52> key, class_3218 world) {
        class_52 table = world.method_8503().method_58576().method_58295(key);
        HashSet<class_1792> items = new HashSet<class_1792>();
        HashSet<class_2960> visited = new HashSet<class_2960>();
        AllLootTableItems.collectItems(key.method_29177(), table, world, items, visited);
        return items;
    }

    private static void collectItems(class_2960 id, class_52 table, class_3218 world, Set<class_1792> collected, Set<class_2960> visited) {
        if (!visited.add(id)) {
            return;
        }
        List<class_55> pools = ((LootTableAccessor)table).getPools();
        for (class_55 pool : pools) {
            List<class_79> entries = ((LootPoolAccessor)pool).getEntries();
            for (class_79 entry : entries) {
                if (entry instanceof class_83) {
                    class_83 lootTableEntry = (class_83)entry;
                    LootTableEntryAccessor accessor = (LootTableEntryAccessor)lootTableEntry;
                    accessor.getValue().left().ifPresent(lootKey -> {
                        class_52 subTable = world.method_8503().method_58576().method_58295(lootKey);
                        AllLootTableItems.collectItems(lootKey.method_29177(), subTable, world, collected, visited);
                    });
                }
                if (entry instanceof class_77) {
                    class_77 itemEntry = (class_77)entry;
                    class_6880<class_1792> regItem = ((ItemEntryAccessor)itemEntry).getItem();
                    collected.add((class_1792)regItem.comp_349());
                }
                if (!(entry instanceof class_93)) continue;
                class_93 groupEntry = (class_93)entry;
                List<class_79> children = ((CombinedEntryAccessor)groupEntry).getChildren();
                for (class_79 subEntry : children) {
                    AllLootTableItems.simulateEntry(subEntry, collected);
                }
            }
        }
    }

    private static void simulateEntry(class_79 entry, Set<class_1792> collected) {
        if (entry instanceof class_77) {
            class_77 itemEntry = (class_77)entry;
            class_6880<class_1792> regItem = ((ItemEntryAccessor)itemEntry).getItem();
            collected.add((class_1792)regItem.comp_349());
        }
        if (entry instanceof class_93) {
            class_93 groupEntry = (class_93)entry;
            List<class_79> children = ((CombinedEntryAccessor)groupEntry).getChildren();
            for (class_79 subEntry : children) {
                AllLootTableItems.simulateEntry(subEntry, collected);
            }
        }
    }
}

