/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.client.toast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.pixeldreamstudios.journal.config.JournalConfig;

public class CustomToastManager {
    private static final List<CustomToastEntry> toasts = new ArrayList<CustomToastEntry>();

    public static void add(class_368 toast) {
        toasts.add(new CustomToastEntry(toast));
    }

    public static void render(class_332 context) {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        long slideDuration = 600L;
        long totalDuration = 5000L;
        boolean top = JournalConfig.toastPosition == JournalConfig.ToastPosition.TOP_LEFT || JournalConfig.toastPosition == JournalConfig.ToastPosition.TOP_RIGHT;
        boolean right = JournalConfig.toastPosition == JournalConfig.ToastPosition.TOP_RIGHT || JournalConfig.toastPosition == JournalConfig.ToastPosition.BOTTOM_RIGHT;
        int yStart = top ? 5 : screenHeight - 5;
        Iterator<CustomToastEntry> iterator = toasts.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            int x;
            CustomToastEntry entry = iterator.next();
            long elapsed = entry.getElapsed();
            long remaining = totalDuration - elapsed;
            int toastWidth = entry.toast.method_29049();
            int toastHeight = entry.toast.method_29050();
            if (elapsed < slideDuration) {
                progress = CustomToastManager.easeOutQuad((float)elapsed / (float)slideDuration);
                x = CustomToastManager.interpolateX(right, toastWidth, progress);
            } else if (remaining <= slideDuration) {
                progress = CustomToastManager.easeInQuad((float)(slideDuration - remaining) / (float)slideDuration);
                x = CustomToastManager.interpolateX(right, toastWidth, 1.0f - progress);
            } else {
                x = right ? screenWidth - toastWidth - 5 : 5;
            }
            int y = top ? yStart + index * (toastHeight + 4) : yStart - (index + 1) * (toastHeight + 4);
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)x, (float)y, 0.0f);
            class_368.class_369 result = entry.toast.method_1986(context, client.method_1566(), elapsed);
            context.method_51448().method_22909();
            if (elapsed >= totalDuration || result == class_368.class_369.field_2209) {
                iterator.remove();
                continue;
            }
            ++index;
        }
    }

    private static int interpolateX(boolean rightSide, int toastWidth, float progress) {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int startX = rightSide ? screenWidth : -toastWidth;
        int endX = rightSide ? screenWidth - toastWidth - 5 : 5;
        return (int)((float)startX + (float)(endX - startX) * progress);
    }

    private static float easeOutQuad(float t) {
        return -t * (t - 2.0f);
    }

    private static float easeInQuad(float t) {
        return t * t;
    }

    private static class CustomToastEntry {
        final class_368 toast;
        final long startTime;

        CustomToastEntry(class_368 toast) {
            this.toast = toast;
            this.startTime = System.currentTimeMillis();
        }

        long getElapsed() {
            return System.currentTimeMillis() - this.startTime;
        }
    }
}

