/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import net.minecraft.class_898;
import net.minecraft.class_9209;
import net.pixeldreamstudios.journal.client.JournalClientData;
import net.pixeldreamstudios.journal.client.gui.DetailPageTurnButton;
import net.pixeldreamstudios.journal.client.gui.JournalScreen;
import net.pixeldreamstudios.journal.client.gui.PageTurnButton;
import net.pixeldreamstudios.journal.data.MobDescriptionLoader;
import net.pixeldreamstudios.journal.mixin.LimbAnimatorAccessor;
import net.pixeldreamstudios.journal.network.RequestMobDropsPayload;
import net.pixeldreamstudios.journal.network.ToggleFavoritePayload;
import net.pixeldreamstudios.journal.util.MarkdownParser;
import net.pixeldreamstudios.journal.util.MobEntityCache;

public class MobDetailsScreen
extends class_437 {
    private static final class_2960 LEFT_PAGE = class_2960.method_60655((String)"journal", (String)"textures/book.png");
    private static final class_2960 RIGHT_PAGE = class_2960.method_60655((String)"journal", (String)"textures/book_flipped.png");
    private final int returnPage;
    private boolean isFavorite;
    private class_4185 favButton;
    private final class_2960 mobId;
    private class_1309 mob;
    private boolean expandSymbolDrawn = false;
    private PageTurnButton backButton;
    private DetailPageTurnButton nextButton;
    private DetailPageTurnButton backDescButton;
    private int descPage = 0;
    private List<List<List<MarkdownParser.ParsedLine>>> paginatedLines = new ArrayList<List<List<MarkdownParser.ParsedLine>>>();
    private final String returnQuery;
    private final int mobSlotW = 120;
    private final int mobSlotH = 140;
    private final int descSlotW = 110;
    private final int descSlotH = 130;
    private final Map<class_2960, CachedPose> poseCache = new HashMap<class_2960, CachedPose>();
    private int renderFrameCounter = 0;
    private boolean showAllDrops = false;
    private int expandButtonX = -1;
    private int expandButtonY = -1;
    private int expandButtonWidth = -1;
    private int expandButtonHeight = -1;
    private final Map<class_1309, Boolean> animatedEntities = new WeakHashMap<class_1309, Boolean>();

    public MobDetailsScreen(class_2960 mobId, int returnPage, String returnQuery) {
        super((class_2561)class_2561.method_43470((String)"Mob Info"));
        this.mobId = mobId;
        this.returnPage = returnPage;
        this.returnQuery = returnQuery;
    }

    public void rebuildWithDrops() {
        List<List<MarkdownParser.ParsedLine>> allLines = this.mob != null ? MobDescriptionLoader.getDescription(this.mobId, this.mob) : List.of(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"\u00a7cUnknown mob"))));
        ArrayList<MarkdownParser.ParsedLine> dropIcons = new ArrayList<MarkdownParser.ParsedLine>();
        int maxDrops = this.showAllDrops ? JournalClientData.LAST_DROPS.size() : Math.min(6, JournalClientData.LAST_DROPS.size());
        for (int i = 0; i < maxDrops; ++i) {
            class_1799 stack = JournalClientData.LAST_DROPS.get(i);
            MarkdownParser.ParsedLine icon = new MarkdownParser.ParsedLine(stack);
            icon.scale = 1.0f;
            dropIcons.add(icon);
        }
        if (dropIcons.isEmpty()) {
            dropIcons.add(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"\u00a77(No known drops)")));
        }
        block1: for (List<MarkdownParser.ParsedLine> line : allLines) {
            for (int i = 0; i < line.size(); ++i) {
                MarkdownParser.ParsedLine part = line.get(i);
                if (!part.isText() || !part.text.getString().contains("{INJECT_LOOT_DROPS}")) continue;
                line.remove(i);
                line.addAll(i, dropIcons);
                continue block1;
            }
        }
        this.descPage = 0;
        this.paginateDescription(allLines);
        this.updatePageButtons();
    }

    private String formatModName(String namespace) {
        String[] parts = namespace.split("_");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            builder.append(Character.toUpperCase(part.charAt(0)));
            builder.append(part.substring(1));
            builder.append(" ");
        }
        return builder.toString().trim();
    }

    protected void method_25426() {
        List<List<MarkdownParser.ParsedLine>> allLines;
        class_1309 cached;
        class_638 world = class_310.method_1551().field_1687;
        this.isFavorite = JournalClientData.FAVORITE_MOBS.contains(this.mobId);
        if (world != null && (cached = MobEntityCache.get(this.mobId, (class_1937)world)) != null) {
            this.mob = cached;
        }
        JournalClientData.LAST_DROPS.clear();
        ClientPlayNetworking.send((class_8710)new RequestMobDropsPayload(this.mobId));
        List<List<MarkdownParser.ParsedLine>> list = allLines = this.mob != null ? MobDescriptionLoader.getDescription(this.mobId, this.mob) : List.of(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"\u00a7cUnknown mob"))));
        if (MarkdownParser.containsPlaceholder(allLines, "{getLootDrops}")) {
            ArrayList<MarkdownParser.ParsedLine> dropIcons = new ArrayList<MarkdownParser.ParsedLine>();
            for (class_1799 stack : JournalClientData.LAST_DROPS) {
                MarkdownParser.ParsedLine icon = new MarkdownParser.ParsedLine(stack);
                icon.scale = 1.0f;
                dropIcons.add(icon);
            }
            if (dropIcons.isEmpty()) {
                dropIcons.add(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"\u00a77(No known drops)")));
            }
            MarkdownParser.replacePlaceholder(allLines, "{getLootDrops}", dropIcons);
        }
        this.paginateDescription(allLines);
        int pageWidth = 276;
        int pageHeight = 180;
        int totalWidth = pageWidth * 2;
        int x = (this.field_22789 - totalWidth) / 2;
        int y = (this.field_22790 - pageHeight) / 2;
        int mobSlotX = x + 145;
        int mobSlotY = y + 5;
        this.favButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.isFavorite ? "\u2605" : "\u2606")).method_27694(style -> style.method_36139(0xFFFF55)), btn -> {
            this.isFavorite = !this.isFavorite;
            ClientPlayNetworking.send((class_8710)new ToggleFavoritePayload(this.mobId, this.isFavorite));
            btn.method_25355((class_2561)class_2561.method_43470((String)(this.isFavorite ? "\u2605" : "\u2606")).method_27694(style -> style.method_36139(0xFFFF55)));
        }).method_46434(0, 0, 18, 18).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Toggle Favorite"))).method_46431();
        this.method_37063((class_364)this.favButton);
        int buttonY = y + pageHeight - 20;
        this.backButton = new PageTurnButton(x + 101, buttonY, false, () -> class_310.method_1551().method_1507((class_437)new JournalScreen(this.returnPage, this.returnQuery)));
        this.backDescButton = new DetailPageTurnButton(x + 385, buttonY, false, () -> {
            --this.descPage;
            this.updatePageButtons();
        });
        this.nextButton = new DetailPageTurnButton(x + pageWidth * 2 - 135, buttonY, true, () -> {
            ++this.descPage;
            this.updatePageButtons();
        });
        this.updatePageButtons();
    }

    private void paginateDescription(List<List<MarkdownParser.ParsedLine>> lines) {
        this.paginatedLines.clear();
        float baseScale = 0.85f;
        int maxHeight = (int)(130.0f / baseScale) - 10;
        int wrapWidth = (int)(110.0f / baseScale) - 10;
        class_327 renderer = class_310.method_1551().field_1772;
        ArrayList<List<Object>> currentPage = new ArrayList<List<Object>>();
        int currentHeight = 0;
        boolean insideLootSection = false;
        for (int rowIndex = 0; rowIndex < lines.size(); ++rowIndex) {
            boolean nextRowIsNotLoot;
            List<MarkdownParser.ParsedLine> inputRow = lines.get(rowIndex);
            boolean rowIsLoot = inputRow.stream().anyMatch(part -> part.isItem() && JournalClientData.LAST_DROPS.stream().anyMatch(stack -> class_1799.method_31577((class_1799)stack, (class_1799)part.item)));
            if (inputRow.stream().anyMatch(p -> p.isText() && p.text.getString().replace("\u00a7", "").equalsIgnoreCase("Drops"))) {
                insideLootSection = true;
            }
            ArrayList<MarkdownParser.ParsedLine> currentLine = new ArrayList<MarkdownParser.ParsedLine>();
            int currentLineWidth = 0;
            int currentLineHeight = 0;
            for (MarkdownParser.ParsedLine part2 : inputRow) {
                int height;
                int width;
                float scale = part2.scale <= 0.0f ? 1.0f : part2.scale;
                int n = width = part2.isText() ? renderer.method_27525((class_5348)part2.text) : (int)(16.0f * scale);
                if (part2.isText()) {
                    Objects.requireNonNull(renderer);
                    v1 = 9;
                } else {
                    v1 = height = (int)(16.0f * scale);
                }
                if (currentLineWidth + width > wrapWidth && !currentLine.isEmpty()) {
                    if (currentHeight + currentLineHeight > maxHeight) {
                        this.paginatedLines.add(currentPage);
                        currentPage = new ArrayList();
                        currentHeight = 0;
                    }
                    currentPage.add(currentLine);
                    currentHeight += currentLineHeight + 4;
                    currentLine = new ArrayList();
                    currentLineWidth = 0;
                    currentLineHeight = 0;
                }
                currentLine.add(part2);
                currentLineWidth += width + 2;
                currentLineHeight = Math.max(currentLineHeight, height);
            }
            if (!currentLine.isEmpty()) {
                if (currentHeight + currentLineHeight > maxHeight && !currentPage.isEmpty()) {
                    this.paginatedLines.add(currentPage);
                    currentPage = new ArrayList();
                    currentHeight = 0;
                }
                currentPage.add(currentLine);
                currentHeight += currentLineHeight + 4;
            }
            boolean bl = nextRowIsNotLoot = rowIndex + 1 >= lines.size() || lines.get(rowIndex + 1).stream().noneMatch(p -> p.isItem());
            if (!insideLootSection || !rowIsLoot || !nextRowIsNotLoot) continue;
            if (JournalClientData.LAST_DROPS.size() > 5) {
                MarkdownParser.ParsedLine expandButton = new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"{EXPAND_COLLAPSE}"));
                List<MarkdownParser.ParsedLine> expandRow = List.of(expandButton);
                Objects.requireNonNull(renderer);
                if (currentHeight + 9 > maxHeight && !currentPage.isEmpty()) {
                    this.paginatedLines.add(currentPage);
                    currentPage = new ArrayList();
                    currentHeight = 0;
                }
                currentPage.add(expandRow);
                Objects.requireNonNull(renderer);
                currentHeight += 9 + 4;
            }
            insideLootSection = false;
        }
        if (!currentPage.isEmpty()) {
            this.paginatedLines.add(currentPage);
        }
        if (this.paginatedLines.isEmpty()) {
            this.paginatedLines.add(List.of(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"\u00a7cNo content")))));
        }
    }

    private void updatePageButtons() {
        this.backDescButton.visible = this.descPage > 0;
        this.nextButton.visible = this.descPage < this.paginatedLines.size() - 1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.backButton.mouseClicked(mouseX, mouseY);
        this.backDescButton.mouseClicked(mouseX, mouseY);
        this.nextButton.mouseClicked(mouseX, mouseY);
        if (this.expandButtonX >= 0 && this.expandButtonY >= 0 && mouseX >= (double)this.expandButtonX && mouseX <= (double)(this.expandButtonX + this.expandButtonWidth) && mouseY >= (double)this.expandButtonY && mouseY <= (double)(this.expandButtonY + this.expandButtonHeight)) {
            this.showAllDrops = !this.showAllDrops;
            this.rebuildWithDrops();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int pageWidth = 276;
        int pageHeight = 180;
        int totalWidth = pageWidth * 2;
        int baseX = (this.field_22789 - totalWidth) / 2;
        int baseY = (this.field_22790 - pageHeight) / 2;
        context.method_25302(RIGHT_PAGE, baseX + 41, baseY, 0, 0, pageWidth, pageHeight);
        context.method_25302(LEFT_PAGE, baseX + pageWidth / 2 + 118, baseY, 0, 0, pageWidth, pageHeight);
        int mobSlotX = baseX + 145;
        int mobSlotY = baseY + 5;
        int descSlotX = baseX + pageWidth / 2 + 150;
        int descSlotY = baseY + 20;
        this.expandSymbolDrawn = false;
        if (this.mob != null) {
            this.drawMob(context, mobSlotX + 60, mobSlotY + 70 + 5, 30, mouseX, mouseY, this.mob);
            List<List<MarkdownParser.ParsedLine>> rows = this.paginatedLines.get(this.descPage);
            class_327 renderer = class_310.method_1551().field_1772;
            String modName = this.formatModName(this.mobId.method_12836());
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)(mobSlotX + 60), (float)(mobSlotY + 140 - 5), 0.0f);
            matrices.method_22905(0.7f, 0.7f, 1.0f);
            int modWidth = renderer.method_1727(modName);
            context.method_51433(renderer, modName, -(modWidth / 2), 0, 0x777777, false);
            matrices.method_22909();
            this.favButton.method_46421(mobSlotX + 60 - 9);
            this.favButton.method_46419(mobSlotY + 140 - 3);
            Long ticks = JournalClientData.DISCOVERED_TIME.get(this.mobId);
            if (ticks != null && ticks >= 0L) {
                int day = (int)(ticks / 24000L);
                String dayText = "Day " + day;
                matrices.method_22903();
                matrices.method_46416((float)(mobSlotX + 60), (float)(mobSlotY + 140 + 10), 0.0f);
                matrices.method_22905(0.7f, 0.7f, 1.0f);
                int dayWidth = renderer.method_1727(dayText);
                context.method_51433(renderer, dayText, -dayWidth / 2, 0, 0x777777, false);
                matrices.method_22909();
            }
            int yOffset = 0;
            boolean insideLootSection = false;
            for (List<MarkdownParser.ParsedLine> row : rows) {
                int xOffset = 0;
                int lineHeight = 0;
                for (MarkdownParser.ParsedLine part : row) {
                    List<class_2561> tooltip;
                    float scale = part.scale <= 0.0f ? 1.0f : part.scale;
                    int drawX = descSlotX + 5 + xOffset;
                    int drawY = descSlotY + yOffset;
                    if (part.isText()) {
                        String raw = part.text.getString();
                        if (raw.equalsIgnoreCase("Drops")) {
                            insideLootSection = true;
                        }
                        if (raw.equals("{EXPAND_COLLAPSE}")) {
                            String expandSymbol = this.showAllDrops ? "<< Collapse" : ">> Expand";
                            int symbolWidth = renderer.method_1727(expandSymbol);
                            matrices.method_22903();
                            matrices.method_46416((float)drawX, (float)drawY, 0.0f);
                            context.method_51433(renderer, expandSymbol, 0, 0, 0x777777, false);
                            matrices.method_22909();
                            this.expandButtonX = drawX;
                            this.expandButtonY = drawY;
                            this.expandButtonWidth = symbolWidth;
                            Objects.requireNonNull(renderer);
                            this.expandButtonHeight = 9;
                            Objects.requireNonNull(renderer);
                            lineHeight = 9;
                            continue;
                        }
                        int width = renderer.method_27525((class_5348)part.text);
                        Objects.requireNonNull(renderer);
                        int height = 9;
                        matrices.method_22903();
                        matrices.method_46416((float)drawX, (float)drawY, 0.0f);
                        context.method_51439(renderer, part.text, 0, 0, 0x535C55, false);
                        matrices.method_22909();
                        if (part.hasTooltip() && mouseX >= drawX && mouseX <= drawX + width && mouseY >= drawY && mouseY <= drawY + height) {
                            List tooltip2 = renderer.method_1728((class_5348)part.tooltip, 180);
                            context.method_51447(renderer, tooltip2, mouseX, mouseY);
                        }
                        xOffset += width + 2;
                        lineHeight = Math.max(lineHeight, height);
                        continue;
                    }
                    if (part.isItem()) {
                        int iconSize = (int)(16.0f * scale);
                        matrices.method_22903();
                        matrices.method_46416((float)drawX, (float)drawY, 0.0f);
                        matrices.method_22905(scale, scale, 1.0f);
                        context.method_51427(part.item, 0, 0);
                        context.method_51431(renderer, part.item, 0, 0);
                        matrices.method_22909();
                        if (mouseX >= drawX && mouseX <= drawX + iconSize && mouseY >= drawY && mouseY <= drawY + iconSize) {
                            tooltip = this.getEffectiveTooltip(part, part.item, mouseX, mouseY);
                            context.method_51434(renderer, tooltip, mouseX, mouseY);
                        }
                        xOffset += iconSize + 2;
                        lineHeight = Math.max(lineHeight, iconSize);
                        continue;
                    }
                    if (!part.isTexture()) continue;
                    int texSize = (int)(16.0f * scale);
                    context.method_25290(part.texture, drawX, drawY, 0.0f, 0.0f, texSize, texSize, 16, 16);
                    if (mouseX >= drawX && mouseX <= drawX + texSize && mouseY >= drawY && mouseY <= drawY + texSize && part.hasTooltip()) {
                        tooltip = renderer.method_1728((class_5348)part.tooltip, 180);
                        context.method_51447(renderer, (List)tooltip, mouseX, mouseY);
                    }
                    xOffset += texSize + 2;
                    lineHeight = Math.max(lineHeight, texSize);
                }
                yOffset += lineHeight + 4;
            }
        }
        this.backButton.render(context, mouseX, mouseY);
        this.backDescButton.render(context, mouseX, mouseY);
        this.nextButton.render(context, mouseX, mouseY);
        context.method_51452();
    }

    private List<class_2561> getEffectiveTooltip(MarkdownParser.ParsedLine part, class_1799 item, int mouseX, int mouseY) {
        if (part.isItem()) {
            if (part.hasExplicitTooltip && part.tooltip != null && !part.tooltip.getString().isBlank()) {
                return List.of(part.tooltip);
            }
            return item.method_7950(new class_1792.class_9635(this){

                public class_7225.class_7874 method_59527() {
                    return null;
                }

                public float method_59531() {
                    return 0.0f;
                }

                public class_22 method_59529(class_9209 component) {
                    return null;
                }

                public boolean isAdvanced() {
                    return class_310.method_1551().field_1690.field_1827;
                }

                public boolean isCreative() {
                    return class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_7337();
                }
            }, (class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070));
        }
        if (part.tooltip != null && !part.tooltip.getString().isBlank()) {
            return List.of(part.tooltip);
        }
        return List.of();
    }

    private void drawMob(class_332 context, int x, int y, int scale, int mouseX, int mouseY, class_1309 entity) {
        class_310 client = class_310.method_1551();
        class_898 dispatcher = client.method_1561();
        class_4587 matrices = context.method_51448();
        dispatcher.method_3948(false);
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 100.0);
        matrices.method_22905((float)scale, (float)(-scale), (float)scale);
        matrices.method_22904(0.0, -1.5, 0.0);
        try {
            this.renderFrameCounter = (this.renderFrameCounter + 1) % 3;
            boolean updatePose = this.renderFrameCounter == 0;
            CachedPose pose = this.poseCache.computeIfAbsent(this.mobId, k -> new CachedPose());
            long now = System.currentTimeMillis();
            if (updatePose || now - pose.lastUpdated > 250L) {
                pose.limbPos = (float)(now % 10000L) / 1000.0f * 3.0f;
                pose.yaw = (float)(now % 8000L) / 8000.0f * 360.0f;
                pose.age = (int)(now / 50L);
                pose.lastUpdated = now;
            }
            ((LimbAnimatorAccessor)entity.field_42108).setPos(pose.limbPos);
            entity.field_42108.method_48568(0.35f, 1.0f);
            entity.field_6283 = pose.yaw;
            entity.method_36456(pose.yaw);
            entity.method_36457(0.0f);
            entity.field_6241 = pose.yaw;
            entity.field_6012 = pose.age;
            dispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrices, (class_4597)context.method_51450(), 0xF000F0);
        }
        catch (Throwable t) {
            matrices.method_22909();
            class_327 renderer = client.field_1772;
            String errorText = "Can't render mob";
            int textWidth = renderer.method_1727(errorText);
            context.method_27535(renderer, (class_2561)class_2561.method_43470((String)errorText), x - textWidth / 2, y - 10, 0xFF5555);
            return;
        }
        dispatcher.method_3948(true);
        matrices.method_22909();
    }

    public boolean method_25421() {
        return false;
    }

    private static class CachedPose {
        float limbPos;
        float yaw;
        int age;
        long lastUpdated;

        private CachedPose() {
        }
    }
}

