/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_898;
import net.pixeldreamstudios.journal.client.JournalClientData;
import net.pixeldreamstudios.journal.client.gui.MobDetailsScreen;
import net.pixeldreamstudios.journal.client.gui.PageTurnButton;
import net.pixeldreamstudios.journal.config.JournalConfig;
import net.pixeldreamstudios.journal.events.JournalSounds;
import net.pixeldreamstudios.journal.mixin.LimbAnimatorAccessor;
import net.pixeldreamstudios.journal.util.MobEntityCache;

public class JournalScreen
extends class_437 {
    private static final class_2960 LEFT_PAGE = class_2960.method_60655((String)"journal", (String)"textures/book.png");
    private static final class_2960 RIGHT_PAGE = class_2960.method_60655((String)"journal", (String)"textures/book_flipped.png");
    private class_342 searchBox;
    private String searchQuery = "";
    private final List<class_2960> filteredMobs = new ArrayList<class_2960>();
    private final int pageWidth = 276;
    private final int pageHeight = 180;
    private int currentPage = 0;
    private int totalPages = 0;
    private PageTurnButton nextButton;
    private PageTurnButton backButton;
    public final List<MobSlot> mobSlots = new ArrayList<MobSlot>();
    private final Map<class_2960, class_1309> currentPageMobMap = new HashMap<class_2960, class_1309>();
    private final Map<class_2960, CachedPose> poseCache = new HashMap<class_2960, CachedPose>();
    private int renderFrameCounter = 0;
    private SortMode sortMode = SortMode.ALPHABETICAL;
    private long nextTypingSoundTime = 0L;

    public JournalScreen() {
        this(0, "");
    }

    public JournalScreen(int initialPage, String searchQuery) {
        super((class_2561)class_2561.method_43470((String)"Mob Journal"));
        this.currentPage = initialPage;
        this.searchQuery = searchQuery == null ? "" : searchQuery;
    }

    private void updateFilteredList() {
        this.filteredMobs.clear();
        this.currentPageMobMap.clear();
        String namespaceFilter = null;
        Object nameFilter = "";
        for (String token : this.searchQuery.split("\\s+")) {
            if (token.startsWith("@")) {
                namespaceFilter = token.substring(1);
                continue;
            }
            nameFilter = (String)nameFilter + token + " ";
        }
        nameFilter = ((String)nameFilter).trim().toLowerCase();
        for (class_2960 id2 : JournalClientData.DISCOVERED) {
            class_1299 type;
            if (JournalConfig.isBlacklisted(id2) || namespaceFilter != null && !id2.method_12836().toLowerCase().contains(namespaceFilter) || (type = (class_1299)class_7923.field_41177.method_10223(id2)) == null) continue;
            boolean nameMatch = id2.toString().contains((CharSequence)nameFilter);
            class_1309 living = this.currentPageMobMap.computeIfAbsent(id2, key -> {
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(key);
                return entityType != null ? (class_1309)entityType.method_5883((class_1937)class_310.method_1551().field_1687) : null;
            });
            if (!(living instanceof class_1309)) continue;
            class_1309 entity = living;
            String entityName = entity.method_5476().getString().toLowerCase();
            if (!nameMatch && !entityName.contains((CharSequence)nameFilter) && !((String)nameFilter).isEmpty()) continue;
            this.filteredMobs.add(id2);
        }
        switch (this.sortMode.ordinal()) {
            case 0: {
                this.filteredMobs.sort((a, b) -> {
                    class_1309 la;
                    class_1297 entB;
                    block6: {
                        block5: {
                            class_1299 typeA = (class_1299)class_7923.field_41177.method_10223(a);
                            class_1299 typeB = (class_1299)class_7923.field_41177.method_10223(b);
                            if (typeA == null || typeB == null) {
                                return 0;
                            }
                            class_638 world = class_310.method_1551().field_1687;
                            if (world == null) {
                                return 0;
                            }
                            class_1297 entA = typeA.method_5883((class_1937)world);
                            entB = typeB.method_5883((class_1937)world);
                            if (!(entA instanceof class_1309)) break block5;
                            la = (class_1309)entA;
                            if (entB instanceof class_1309) break block6;
                        }
                        return 0;
                    }
                    class_1309 lb = (class_1309)entB;
                    return la.method_5476().getString().compareToIgnoreCase(lb.method_5476().getString());
                });
                break;
            }
            case 1: {
                this.filteredMobs.sort(Comparator.comparingLong(id -> -JournalClientData.DISCOVERED_TIME.getOrDefault(id, 0L).longValue()));
                break;
            }
            case 2: {
                this.filteredMobs.sort((a, b) -> {
                    int nsCompare = a.method_12836().compareToIgnoreCase(b.method_12836());
                    if (nsCompare != 0) {
                        return nsCompare;
                    }
                    class_1299 typeA = (class_1299)class_7923.field_41177.method_10223(a);
                    class_1299 typeB = (class_1299)class_7923.field_41177.method_10223(b);
                    if (typeA == null || typeB == null) {
                        return 0;
                    }
                    String nameA = typeA.method_5897().getString();
                    String nameB = typeB.method_5897().getString();
                    return nameA.compareToIgnoreCase(nameB);
                });
            }
        }
        if (!JournalClientData.FAVORITE_MOBS.isEmpty()) {
            this.filteredMobs.sort((a, b) -> {
                boolean aFav = JournalClientData.FAVORITE_MOBS.contains(a);
                boolean bFav = JournalClientData.FAVORITE_MOBS.contains(b);
                if (aFav && !bFav) {
                    return -1;
                }
                if (!aFav && bFav) {
                    return 1;
                }
                return 0;
            });
        }
        this.totalPages = (int)Math.ceil((double)this.filteredMobs.size() / 12.0);
        if (this.currentPage >= this.totalPages) {
            this.currentPage = Math.max(this.totalPages - 1, 0);
        }
    }

    public void updateDiscoveredMobs() {
        this.updateFilteredList();
        this.updateButtons();
    }

    private int calculateDynamicScale(class_1309 entity, int maxWidth, int maxHeight, int baseScale) {
        double width = entity.method_17681();
        double height = entity.method_17682();
        if (width == 0.0 || height == 0.0) {
            return baseScale;
        }
        double padding = 0.8;
        double scaleX = (double)maxWidth / (width * 16.0) * padding;
        double scaleY = (double)maxHeight / (height * 16.0) * padding;
        double scale = Math.min(scaleX, scaleY);
        int clamped = (int)Math.max(8.0, Math.min(scale, (double)baseScale));
        return clamped;
    }

    protected void method_25426() {
        super.method_25426();
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.searchBox = new class_342(textRenderer, this.field_22789 / 2 - 96, this.field_22790 / 2 - 90 - 25, 200, 18, (class_2561)class_2561.method_43470((String)"Search..."));
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search mobs..."));
        this.searchBox.method_1852(this.searchQuery);
        this.searchBox.method_1863(query -> {
            this.searchQuery = query.toLowerCase().trim();
            this.currentPage = 0;
            this.updateFilteredList();
            this.updateButtons();
        });
        int sortButtonX = this.field_22789 / 2 + 110;
        int sortButtonY = this.searchBox.method_46427();
        class_4185 sortButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"A\u2192Z"), btn -> {
            this.sortMode = switch (this.sortMode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SortMode.DATE_DISCOVERED;
                case 1 -> SortMode.MOD_NAMESPACE;
                case 2 -> SortMode.ALPHABETICAL;
            };
            String label = switch (this.sortMode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "A\u2192Z";
                case 1 -> "\ud83d\udd52";
                case 2 -> "@mod";
            };
            class_5250 tooltipText = switch (this.sortMode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> class_2561.method_43470((String)"Sort: A \u2192 Z");
                case 1 -> class_2561.method_43470((String)"Sort: Recently Discovered");
                case 2 -> class_2561.method_43470((String)"Sort: By Mod Namespace");
            };
            btn.method_25355((class_2561)class_2561.method_43470((String)label));
            btn.method_47400(class_7919.method_47407((class_2561)tooltipText));
            this.updateFilteredList();
        }).method_46434(sortButtonX, sortButtonY, 30, 18).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Sort: A \u2192 Z"))).method_46431();
        this.method_37063((class_364)sortButton);
        this.method_25429((class_364)this.searchBox);
        this.method_48265((class_364)this.searchBox);
        int totalWidth = 552;
        int x = (this.field_22789 - totalWidth) / 2;
        int y = (this.field_22790 - 180) / 2;
        int buttonY = y + 180 - 20;
        this.nextButton = new PageTurnButton(x + 552 - 135, buttonY, true, () -> {
            ++this.currentPage;
            this.updateFilteredList();
            this.updateButtons();
        });
        this.backButton = new PageTurnButton(x + 101, buttonY, false, () -> {
            --this.currentPage;
            this.updateFilteredList();
            this.updateButtons();
        });
        this.updateFilteredList();
        this.updateButtons();
    }

    private void updateButtons() {
        this.nextButton.visible = this.currentPage < this.totalPages - 1;
        this.backButton.visible = this.currentPage > 0;
    }

    private void renderMobGrid(class_332 context, int leftStartX, int startY, int mouseX, int mouseY) {
        this.mobSlots.clear();
        this.renderFrameCounter = (this.renderFrameCounter + 1) % 3;
        boolean updatePose = this.renderFrameCounter == 0;
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null || this.filteredMobs.isEmpty()) {
            return;
        }
        int startIndex = this.currentPage * 12;
        int endIndex = Math.min(startIndex + 12, this.filteredMobs.size());
        int columns = 2;
        int spacingX = 60;
        int spacingY = 45;
        int baseScale = 8;
        int hoverScale = 11;
        int boxWidth = 30;
        int boxHeight = 40;
        int leftPageStartX = leftStartX;
        int rightPageStartX = leftPageStartX + 145;
        ArrayList<Nameplate> pendingNameplates = new ArrayList<Nameplate>();
        class_898 dispatcher = client.method_1561();
        dispatcher.method_3948(false);
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        for (int i = startIndex; i < endIndex; ++i) {
            boolean isOnScreen;
            boolean isHovered;
            class_2960 id = this.filteredMobs.get(i);
            class_1309 living = MobEntityCache.get(id, (class_1937)world);
            if (living == null) continue;
            boolean isRightPage = i - startIndex >= 6;
            int localIndex = (i - startIndex) % 6;
            int col = localIndex % columns;
            int row = localIndex / columns;
            int x = (isRightPage ? rightPageStartX : leftPageStartX) + col * spacingX;
            int y = startY + row * spacingY;
            this.mobSlots.add(new MobSlot(id, x - 15, y - 20, boxWidth, boxHeight));
            if (JournalClientData.FAVORITE_MOBS.contains(id)) {
                matrices.method_22903();
                matrices.method_46416((float)(x - boxWidth / 2 + 2), (float)(y - boxHeight / 2 + 2), 0.0f);
                matrices.method_22905(0.75f, 0.75f, 1.0f);
                context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"\u2605").method_27694(style -> style.method_36139(0xFFFF55)), 0, 0, 0xFFFF55, false);
                matrices.method_22909();
            }
            boolean bl = isHovered = mouseX >= x - boxWidth / 2 && mouseX <= x + boxWidth / 2 && mouseY >= y - boxHeight / 2 && mouseY <= y + boxHeight / 2;
            if (isHovered) {
                double pulse = Math.sin((double)System.currentTimeMillis() / 150.0) * 0.15 + 0.25;
                int alpha = (int)(pulse * 255.0);
                int color = alpha << 24 | 0x55FF55;
                context.method_25294(x - boxWidth / 2, y - boxHeight / 2, x + boxWidth / 2, y + boxHeight / 2, color);
            }
            boolean bl2 = isOnScreen = x + boxWidth / 2 >= 0 && x - boxWidth / 2 <= this.field_22789 && y + boxHeight / 2 >= 0 && y - boxHeight / 2 <= this.field_22790;
            if (isOnScreen) {
                CachedPose pose = this.poseCache.computeIfAbsent(id, k -> new CachedPose());
                long now = System.currentTimeMillis();
                if (updatePose || now - pose.lastUpdated > 250L) {
                    pose.limbPos = (float)(now % 10000L) / 1000.0f * 3.0f;
                    pose.yaw = (float)(now % 8000L) / 8000.0f * 360.0f;
                    pose.age = (int)(now / 50L);
                    pose.lastUpdated = now;
                }
                ((LimbAnimatorAccessor)living.field_42108).setPos(pose.limbPos);
                living.field_42108.method_48568(0.35f, 1.0f);
                living.field_6283 = pose.yaw;
                living.method_36456(pose.yaw);
                living.method_36457(0.0f);
                living.field_6241 = pose.yaw;
                living.field_6012 = pose.age;
            }
            int scale = isHovered ? hoverScale : baseScale;
            int targetScale = this.calculateDynamicScale(living, boxWidth, boxHeight, isHovered ? hoverScale : baseScale);
            this.drawMob(context, x, y, targetScale, mouseX, mouseY, living);
            Nameplate plate = new Nameplate(living.method_5476().getString(), x, y + scale + 10, client.field_1772);
            plate.hovered = isHovered;
            pendingNameplates.add(plate);
        }
        matrices.method_22909();
        dispatcher.method_3948(true);
        this.drawNameplate(context, pendingNameplates, client.field_1772);
    }

    private void drawNameplate(class_332 context, List<Nameplate> plates, class_327 renderer) {
        boolean changed;
        do {
            changed = false;
            for (int i = 0; i < plates.size(); ++i) {
                for (int j = i + 1; j < plates.size(); ++j) {
                    int lenB;
                    Nameplate a = plates.get(i);
                    Nameplate b = plates.get(j);
                    if (!a.bounds.intersects(b.bounds)) continue;
                    boolean trimmed = false;
                    int lenA = a.name.length();
                    if (lenA > (lenB = b.name.length()) && lenA > 3) {
                        a.trim();
                        a.bounds = a.calculateBounds(renderer);
                        trimmed = true;
                    } else if (lenB > lenA && lenB > 3) {
                        b.trim();
                        b.bounds = b.calculateBounds(renderer);
                        trimmed = true;
                    } else {
                        if (lenA > 3) {
                            a.trim();
                            a.bounds = a.calculateBounds(renderer);
                            trimmed = true;
                        }
                        if (lenB > 3) {
                            b.trim();
                            b.bounds = b.calculateBounds(renderer);
                            trimmed = true;
                        }
                    }
                    if (!trimmed) continue;
                    changed = true;
                }
            }
        } while (changed);
        for (Nameplate plate : plates) {
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)plate.centerX, (float)plate.topY, 0.0f);
            matrices.method_22905(0.75f, 0.75f, 1.0f);
            String display = plate.getDisplayName();
            context.method_51433(renderer, display, -renderer.method_1727(display) / 2, 0, 0, false);
            matrices.method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMob(class_332 context, int x, int y, int scale, int mouseX, int mouseY, class_1309 entity) {
        class_310 client = class_310.method_1551();
        class_898 dispatcher = client.method_1561();
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 100.0);
        matrices.method_22905((float)scale, (float)(-scale), (float)scale);
        matrices.method_22904(0.0, -1.5, 0.0);
        try {
            dispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrices, (class_4597)context.method_51450(), 0xF000F0);
        }
        catch (Throwable t) {
            class_327 renderer = client.field_1772;
            int textWidth = renderer.method_1727("Can't render mob");
            context.method_27535(renderer, (class_2561)class_2561.method_43470((String)"Can't render mob"), x - textWidth / 2, y - 10, 0xFF5555);
        }
        finally {
            matrices.method_22909();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (MobSlot slot : this.mobSlots) {
            if (!slot.isHovered((int)mouseX, (int)mouseY)) continue;
            if (class_310.method_1551().field_1724 != null) {
                float pitch = 0.95f + class_310.method_1551().field_1687.field_9229.method_43057() * 0.1f;
                class_310.method_1551().field_1724.method_5783(class_3417.field_17481, 1.0f, pitch);
            }
            class_310.method_1551().method_1507((class_437)new MobDetailsScreen(slot.id, this.currentPage, this.searchQuery));
            return true;
        }
        this.nextButton.mouseClicked(mouseX, mouseY);
        this.backButton.mouseClicked(mouseX, mouseY);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (super.method_25400(chr, modifiers)) {
            long currentTime = System.currentTimeMillis();
            if (currentTime >= this.nextTypingSoundTime && class_310.method_1551().field_1724 != null) {
                float pitch = 0.95f + class_310.method_1551().field_1687.field_9229.method_43057() * 0.1f;
                class_310.method_1551().field_1724.method_5783(JournalSounds.WRITING, 1.0f, pitch);
                this.nextTypingSoundTime = currentTime + 1000L;
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.searchBox.method_25404(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int totalWidth = 552;
        int x = (this.field_22789 - totalWidth) / 2;
        int y = (this.field_22790 - 180) / 2;
        context.method_25302(RIGHT_PAGE, x + 41, y, 0, 0, 276, 180);
        context.method_25302(LEFT_PAGE, x + 138 + 118, y, 0, 0, 276, 180);
        this.searchBox.method_25394(context, mouseX, mouseY, delta);
        if (this.filteredMobs.isEmpty()) {
            class_327 renderer = class_310.method_1551().field_1772;
            String message = "No discovered mobs";
            int messageWidth = renderer.method_1727(message);
            int messageX = this.field_22789 / 2 - messageWidth / 2 - 75;
            int messageY = this.field_22790 / 2 - 70;
            context.method_51433(renderer, message, messageX, messageY, 0x888888, false);
        } else {
            this.renderMobGrid(context, x + 176, y + 38, mouseX, mouseY);
        }
        context.method_51452();
        this.nextButton.render(context, mouseX, mouseY);
        this.backButton.render(context, mouseX, mouseY);
    }

    public boolean method_25421() {
        return false;
    }

    private static enum SortMode {
        ALPHABETICAL,
        DATE_DISCOVERED,
        MOD_NAMESPACE;

    }

    public static class MobSlot {
        class_2960 id;
        int x;
        int y;
        int width;
        int height;

        MobSlot(class_2960 id, int x, int y, int width, int height) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }
    }

    private static class CachedPose {
        float limbPos;
        float yaw;
        int age;
        long lastUpdated;

        private CachedPose() {
        }
    }

    private static class Nameplate {
        String fullName;
        StringBuilder name;
        int centerX;
        int topY;
        Rectangle bounds;
        int fullLength;
        boolean hovered = false;

        public Nameplate(String fullName, int centerX, int topY, class_327 renderer) {
            this.fullName = fullName;
            this.name = new StringBuilder(fullName);
            this.fullLength = fullName.length();
            this.centerX = centerX;
            this.topY = topY;
            this.bounds = this.calculateBounds(renderer);
        }

        public Rectangle calculateBounds(class_327 renderer) {
            String display = this.getDisplayName();
            int width = renderer.method_1727(display);
            return new Rectangle(this.centerX - width / 2, this.topY, width, 9);
        }

        public void trim() {
            if (this.name.length() > 3) {
                this.name.setLength(this.name.length() - 1);
            }
        }

        public String getDisplayName() {
            return this.hovered ? this.fullName : (this.name.length() < this.fullLength ? String.valueOf(this.name) + "..." : this.name.toString());
        }
    }
}

