/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import java.util.Date;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_4844;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ProgressChange {
    public static class_9139<class_2540, ProgressChange> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_48551, ProgressChange::getOriginId, (class_9139)class_9135.field_48547, ProgressChange::shouldReset, (class_9139)class_4844.field_48453, ProgressChange::getPlayerId, (class_9139)class_9135.field_48547, ProgressChange::shouldNotify, ProgressChange::createServerSide);
    private final Date date;
    private final QuestObjectBase origin;
    private final UUID playerId;
    private boolean reset;
    private boolean notifications;

    public ProgressChange(QuestObjectBase origin, UUID playerId) {
        this.origin = origin;
        this.playerId = playerId;
        this.date = new Date();
        this.reset = true;
        this.notifications = false;
    }

    public static ProgressChange createServerSide(long origin, boolean reset, UUID playerId, boolean notifications) {
        ProgressChange pc = new ProgressChange(ServerQuestFile.INSTANCE.getBase(origin), playerId);
        pc.reset = reset;
        pc.notifications = notifications;
        return pc;
    }

    public void maybeForceProgress(UUID teamId) {
        if (this.origin != null) {
            TeamData t = ServerQuestFile.INSTANCE.getOrCreateTeamData(teamId);
            this.origin.forceProgressRaw(t, this);
        }
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public Date getDate() {
        return this.date;
    }

    public ProgressChange setReset(boolean reset) {
        this.reset = reset;
        return this;
    }

    public boolean shouldReset() {
        return this.reset;
    }

    public ProgressChange withNotifications() {
        this.notifications = true;
        return this;
    }

    public boolean shouldNotify() {
        return this.notifications;
    }

    private long getOriginId() {
        return this.origin == null ? 0L : this.origin.id;
    }
}

