/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.task.AdvancementTask;
import dev.ftb.mods.ftbquests.quest.task.BiomeTask;
import dev.ftb.mods.ftbquests.quest.task.CheckmarkTask;
import dev.ftb.mods.ftbquests.quest.task.CustomTask;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.KillTask;
import dev.ftb.mods.ftbquests.quest.task.LocationTask;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.StageTask;
import dev.ftb.mods.ftbquests.quest.task.StatTask;
import dev.ftb.mods.ftbquests.quest.task.StructureTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.XPTask;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public interface TaskTypes {
    public static final Map<class_2960, TaskType> TYPES = new LinkedHashMap<class_2960, TaskType>();
    public static final TaskType ITEM = TaskTypes.register(FTBQuestsAPI.rl("item"), ItemTask::new, () -> Icon.getIcon((String)"minecraft:item/diamond"));
    public static final TaskType CUSTOM = TaskTypes.register(FTBQuestsAPI.rl("custom"), CustomTask::new, () -> Icons.COLOR_HSB);
    public static final TaskType XP = TaskTypes.register(FTBQuestsAPI.rl("xp"), XPTask::new, () -> Icon.getIcon((String)"minecraft:item/experience_bottle"));
    public static final TaskType DIMENSION = TaskTypes.register(FTBQuestsAPI.rl("dimension"), DimensionTask::new, () -> Icon.getIcon((String)"minecraft:block/nether_portal"));
    public static final TaskType STAT = TaskTypes.register(FTBQuestsAPI.rl("stat"), StatTask::new, () -> Icon.getIcon((String)"minecraft:item/iron_sword"));
    public static final TaskType KILL = TaskTypes.register(FTBQuestsAPI.rl("kill"), KillTask::new, () -> Icon.getIcon((String)"minecraft:item/diamond_sword"));
    public static final TaskType LOCATION = TaskTypes.register(FTBQuestsAPI.rl("location"), LocationTask::new, () -> Icon.getIcon((String)"minecraft:item/compass_00"));
    public static final TaskType CHECKMARK = TaskTypes.register(FTBQuestsAPI.rl("checkmark"), CheckmarkTask::new, () -> Icons.ACCEPT_GRAY);
    public static final TaskType ADVANCEMENT = TaskTypes.register(FTBQuestsAPI.rl("advancement"), AdvancementTask::new, () -> Icon.getIcon((String)"minecraft:item/wheat"));
    public static final TaskType OBSERVATION = TaskTypes.register(FTBQuestsAPI.rl("observation"), ObservationTask::new, () -> Icons.ART);
    public static final TaskType BIOME = TaskTypes.register(FTBQuestsAPI.rl("biome"), BiomeTask::new, () -> Icon.getIcon((String)"minecraft:block/oak_sapling"));
    public static final TaskType STRUCTURE = TaskTypes.register(FTBQuestsAPI.rl("structure"), StructureTask::new, () -> Icon.getIcon((String)"minecraft:item/filled_map"));
    public static final TaskType STAGE = TaskTypes.register(FTBQuestsAPI.rl("gamestage"), StageTask::new, () -> Icons.CONTROLLER);
    public static final TaskType FLUID = TaskTypes.register(FTBQuestsAPI.rl("fluid"), FluidTask::new, () -> Icon.getIcon((String)Optional.ofNullable(ClientUtils.getStillTexture((FluidStack)FluidStack.create((class_3611)class_3612.field_15910, (long)1000L))).map(class_2960::toString).orElse("missingno")).withTint(Color4I.rgb((int)0x8080FF)).combineWith(Icon.getIcon((String)FluidTask.TANK_TEXTURE.toString())));

    public static TaskType register(class_2960 name, TaskType.Provider provider, Supplier<Icon> iconSupplier) {
        return TYPES.computeIfAbsent(name, id -> new TaskType((class_2960)id, provider, iconSupplier));
    }

    public static void init() {
    }
}

