/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftbquests.client.GuiProviders;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class TaskType {
    private final class_2960 typeId;
    private final Provider provider;
    private final Supplier<Icon> iconSupplier;
    private class_2561 displayName;
    private GuiProvider guiProvider;
    public int internalId;

    TaskType(class_2960 typeId, Provider provider, Supplier<Icon> iconSupplier) {
        this.typeId = typeId;
        this.provider = provider;
        this.iconSupplier = iconSupplier;
        this.displayName = null;
        this.guiProvider = GuiProviders.defaultTaskGuiProvider(provider);
    }

    public class_2960 getTypeId() {
        return this.typeId;
    }

    @Nullable
    public static Task createTask(long id, Quest quest, String typeId) {
        if (((String)typeId).isEmpty()) {
            typeId = "ftbquests:item";
        } else if (((String)typeId).indexOf(58) == -1) {
            typeId = "ftbquests:" + (String)typeId;
        }
        TaskType type = TaskTypes.TYPES.get(class_2960.method_12829((String)typeId));
        if (type == null) {
            return null;
        }
        return type.provider.create(id, quest);
    }

    public Task createTask(long id, Quest quest) {
        return this.provider.create(id, quest);
    }

    public String getTypeForNBT() {
        return this.typeId.method_12836().equals("ftbquests") ? this.typeId.method_12832() : this.typeId.toString();
    }

    public class_2487 makeExtraNBT() {
        return (class_2487)class_156.method_654((Object)new class_2487(), t -> t.method_10582("type", this.getTypeForNBT()));
    }

    public TaskType setDisplayName(class_2561 name) {
        this.displayName = name;
        return this;
    }

    public class_2561 getDisplayName() {
        if (this.displayName == null) {
            this.displayName = class_2561.method_43471((String)("ftbquests.task." + this.typeId.method_12836() + "." + this.typeId.method_12832()));
        }
        return this.displayName;
    }

    public Icon getIconSupplier() {
        return this.iconSupplier.get();
    }

    public TaskType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    @FunctionalInterface
    public static interface Provider {
        public Task create(long var1, Quest var3);
    }

    @FunctionalInterface
    public static interface GuiProvider {
        @Environment(value=EnvType.CLIENT)
        public void openCreationGui(Panel var1, Quest var2, BiConsumer<Task, class_2487> var3);
    }
}

