/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;

public class XPLevelsReward
extends Reward {
    private int xpLevels;

    public XPLevelsReward(long id, Quest quest, int x) {
        super(id, quest);
        this.xpLevels = x;
    }

    public XPLevelsReward(long id, Quest quest) {
        this(id, quest, 5);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.XP_LEVELS;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10569("xp_levels", this.xpLevels);
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.xpLevels = nbt.method_10550("xp_levels");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10804(this.xpLevels);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.xpLevels = buffer.method_10816();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("xp_levels", this.xpLevels, v -> {
            this.xpLevels = v;
        }, 1, 1, Integer.MAX_VALUE).setNameKey("ftbquests.reward.ftbquests.xp_levels");
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        player.method_7316(this.xpLevels);
        if (notify) {
            class_5250 text = class_2561.method_43471((String)"ftbquests.reward.ftbquests.xp_levels").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)("+" + this.xpLevels)).method_27692(class_124.field_1060));
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new DisplayRewardToastMessage(this.id, (class_2561)text, (Icon)Color4I.empty(), this.disableRewardScreenBlur));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.reward.ftbquests.xp_levels").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)("+" + this.xpLevels)).method_27692(class_124.field_1060));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public String getButtonText() {
        return "+" + this.xpLevels;
    }
}

