/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8779;
import net.minecraft.class_9129;

public class AdvancementReward
extends Reward {
    private class_2960 advancement = class_2960.method_60656((String)"story/root");
    private String criterion = "";

    public AdvancementReward(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.ADVANCEMENT;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10582("advancement", this.advancement.toString());
        nbt.method_10582("criterion", this.criterion);
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.advancement = class_2960.method_12829((String)nbt.method_10558("advancement"));
        this.criterion = nbt.method_10558("criterion");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10812(this.advancement);
        buffer.method_10788(this.criterion, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.advancement = buffer.method_10810();
        this.criterion = buffer.method_10800(Short.MAX_VALUE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        if (KnownServerRegistries.client != null && !KnownServerRegistries.client.advancements().isEmpty()) {
            Map advancements = KnownServerRegistries.client.advancements();
            config.addEnum("advancement", (Object)this.advancement, v -> {
                this.advancement = v;
            }, NameMap.of((Object)((class_2960)advancements.keySet().iterator().next()), (Object[])advancements.keySet().toArray(new class_2960[0])).icon(resourceLocation -> ItemIcon.getItemIcon((class_1799)((KnownServerRegistries.AdvancementInfo)advancements.get(resourceLocation)).icon())).name(resourceLocation -> ((KnownServerRegistries.AdvancementInfo)advancements.get(resourceLocation)).name()).create()).setNameKey("ftbquests.reward.ftbquests.advancement");
        } else {
            config.addString("advancement", this.advancement.toString(), v -> {
                this.advancement = class_2960.method_12829((String)v);
            }, "minecraft:story/root").setNameKey("ftbquests.reward.ftbquests.advancement");
        }
        config.addString("criterion", this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        class_8779 advancementHolder = player.field_13995.method_3851().method_12896(this.advancement);
        if (advancementHolder != null) {
            if (this.criterion.isEmpty()) {
                for (String s : advancementHolder.comp_1920().comp_1915().keySet()) {
                    player.method_14236().method_12878(advancementHolder, s);
                }
            } else {
                player.method_14236().method_12878(advancementHolder, this.criterion);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements().get(this.advancement);
        if (info != null && !TextUtils.isComponentEmpty(info.name())) {
            return class_2561.method_43471((String)"ftbquests.reward.ftbquests.advancement").method_27693(": ").method_10852((class_2561)info.name().method_27661().method_27692(class_124.field_1054));
        }
        return super.getAltTitle();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements().get(this.advancement);
        if (info != null && !info.icon().method_7960()) {
            return ItemIcon.getItemIcon((class_1799)info.icon());
        }
        return super.getAltIcon();
    }
}

