/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.item_filtering;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.api.event.CustomFilterDisplayItemsEvent;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import org.jetbrains.annotations.NotNull;

public class DisplayStacksCache {
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Int2ObjectLinkedOpenHashMap<List<class_1799>> cache = new Int2ObjectLinkedOpenHashMap(1024);
    private static List<class_1799> extraCache = null;

    @NotNull
    public static List<class_1799> getCachedDisplayStacks(class_1799 filterStack, ItemFilterAdapter adapter) {
        int key = class_1799.method_57355((class_1799)filterStack);
        List<class_1799> result = (List<class_1799>)cache.getAndMoveToFirst(key);
        if (result == null) {
            result = DisplayStacksCache.computeMatchingStacks(adapter.getMatcher(filterStack));
            cache.put(key, result);
            if (cache.size() >= 1024) {
                cache.removeLast();
            }
        }
        return result;
    }

    private static List<class_1799> computeMatchingStacks(ItemFilterAdapter.Matcher matcher) {
        FTBQuestsClient.creativeTabDisplayParams().ifPresent(params -> {
            if (class_7706.method_47330((class_7699)params.comp_1251(), (boolean)params.comp_1252(), (class_7225.class_7874)params.comp_1253())) {
                FTBQuests.LOGGER.debug("creative tabs rebuilt, search tab now has {} items", (Object)class_7706.method_47344().method_45414().size());
            }
        });
        ImmutableList.Builder builder = ImmutableList.builder();
        class_7706.method_47344().method_45414().stream().filter(matcher).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        DisplayStacksCache.getExtraDisplayCache().stream().filter(matcher).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void clear() {
        cache.clear();
        extraCache = null;
    }

    @NotNull
    private static List<class_1799> getExtraDisplayCache() {
        if (extraCache == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            ((Consumer)CustomFilterDisplayItemsEvent.ADD_ITEMSTACK.invoker()).accept(new CustomFilterDisplayItemsEvent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)));
            extraCache = builder.build();
        }
        return extraCache;
    }
}

