/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.CompactGridLayout;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_8710;

public class ValidItemsScreen
extends BaseScreen {
    private final class_2561 title;
    private final Panel itemPanel;
    private final Button backButton;
    private final Button submitButton;

    public ValidItemsScreen(final ItemTask task, final List<class_1799> validItems, final boolean canClick) {
        this.title = class_2561.method_43469((String)"ftbquests.task.ftbquests.item.valid_for", (Object[])new Object[]{task.getTitle()});
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (class_1799 validItem : validItems) {
                    this.add((Widget)new ValidItemButton(this, validItem));
                }
            }

            public void alignWidgets() {
                this.align((WidgetLayout)new CompactGridLayout(36));
                this.setHeight(Math.min(160, this.getContentHeight()));
                this.parent.setHeight(this.height + 53);
                int off = (this.width - this.getContentWidth()) / 2;
                for (Widget widget : this.widgets) {
                    widget.setX(widget.posX + off);
                }
                ValidItemsScreen.this.itemPanel.setX((this.parent.width - this.width) / 2);
                ValidItemsScreen.this.backButton.setPosAndSize(ValidItemsScreen.this.itemPanel.posX - 1, this.height + 28, 70, 20);
                ValidItemsScreen.this.submitButton.setPosAndSize(ValidItemsScreen.this.itemPanel.posX + 75, this.height + 28, 70, 20);
            }

            public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                theme.drawButton(graphics, x - 1, y - 1, w + 2, h + 2, WidgetType.NORMAL);
            }
        };
        this.itemPanel.setPosAndSize(0, 22, 144, 0);
        this.backButton = new SimpleTextButton((Panel)this, (class_2561)class_2561.method_43471((String)"gui.back"), (Icon)Color4I.empty()){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                ValidItemsScreen.this.onBack();
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.submitButton = new SimpleTextButton((Panel)this, (class_2561)class_2561.method_43470((String)"Submit"), (Icon)Color4I.empty()){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                NetworkManager.sendToServer((class_8710)new SubmitTaskMessage(task.id));
                ValidItemsScreen.this.onBack();
            }

            public void addMouseOverText(TooltipList list) {
                if (canClick && !task.consumesResources() && !task.isTaskScreenOnly()) {
                    list.translate("ftbquests.task.auto_detected", new Object[0]);
                }
            }

            public WidgetType getWidgetType() {
                return canClick && task.consumesResources() && !task.isTaskScreenOnly() ? super.getWidgetType() : WidgetType.DISABLED;
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
    }

    public void addWidgets() {
        this.setWidth(Math.max(156, this.getTheme().getStringWidth((class_5348)this.title) + 12));
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.backButton);
        this.add((Widget)this.submitButton);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public void drawBackground(class_332 matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)this.title, x + w / 2, y + 6, Color4I.WHITE, 4);
    }

    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (key.esc()) {
            this.onBack();
            return true;
        }
        return false;
    }

    public boolean doesGuiPauseGame() {
        return ClientQuestFile.exists() && ClientQuestFile.INSTANCE.isPauseGame();
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.onBack();
        }
        return false;
    }

    private static class ValidItemButton
    extends Button {
        private final class_1799 stack;

        ValidItemButton(Panel panel, class_1799 stack) {
            super(panel, (class_2561)class_2561.method_43473(), ItemIcon.getItemIcon((class_1799)stack));
            this.stack = stack;
        }

        public void onClicked(MouseButton button) {
            FTBQuests.getRecipeModHelper().showRecipes(this.stack);
        }

        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of((Object)this.stack, (Widget)this, (boolean)true);
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22904((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 10.0);
            graphics.method_51448().method_22905(2.0f, 2.0f, 2.0f);
            GuiHelper.drawItem((class_332)graphics, (class_1799)this.stack, (int)0, (boolean)true, null);
            graphics.method_51448().method_22909();
        }
    }
}

