/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.GetEmergencyItemsMessage;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8710;

public class EmergencyItemsScreen
extends BaseScreen {
    private static long endTime = 0L;
    private final SimpleTextButton getItemsButton;
    private final SimpleTextButton cancelButton;
    private final Panel itemPanel;

    public EmergencyItemsScreen() {
        if (endTime < class_156.method_659()) {
            endTime = class_156.method_659() + (long)ClientQuestFile.INSTANCE.getEmergencyItemsCooldown() * 1000L;
        }
        this.itemPanel = new ItemPanel();
        this.cancelButton = SimpleTextButton.cancel((Panel)this, mb -> this.closeGui(), (class_2561[])new class_2561[0]);
        this.getItemsButton = new SimpleTextButton(this, (Panel)this, (class_2561)class_2561.method_43471((String)"ftbquests.file.emergency_items.get_items"), Icons.ACCEPT){

            public void onClicked(MouseButton button) {
                if (class_156.method_659() >= endTime) {
                    this.playClickSound();
                    NetworkManager.sendToServer((class_8710)GetEmergencyItemsMessage.INSTANCE);
                    endTime = class_156.method_659() + (long)ClientQuestFile.INSTANCE.getEmergencyItemsCooldown() * 1000L;
                }
            }

            public void tick() {
                class_5250 c = class_2561.method_43471((String)"ftbquests.file.emergency_items.get_items");
                this.setTitle((class_2561)(class_156.method_659() >= endTime ? c : c.method_27692(class_124.field_1063)));
            }
        };
    }

    public static void resetCooldown() {
        endTime = 0L;
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.add((Widget)this.getItemsButton);
        this.cancelButton.setPos(this.width / 2 - this.cancelButton.width - 5, this.height * 2 / 3 + 16);
        this.getItemsButton.setPos(this.cancelButton.getX() + this.cancelButton.getWidth() + 10, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)((int)((double)w / 2.0)), (float)((int)((double)h / 5.0)), 0.0f);
        poseStack.method_22905(2.0f, 2.0f, 1.0f);
        class_5250 titleMsg = class_2561.method_43471((String)"ftbquests.file.emergency_items");
        theme.drawString(graphics, (Object)titleMsg, -theme.getStringWidth((class_5348)titleMsg) / 2, 0, Color4I.WHITE, 0);
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_46416((float)((int)((double)w / 2.0)), (float)((int)((double)h / 2.5)), 0.0f);
        poseStack.method_22905(4.0f, 4.0f, 1.0f);
        long timeLeft = endTime - class_156.method_659();
        String timeStr = timeLeft <= 0L ? "00:00" : TimeUtils.getTimeString((long)(timeLeft / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(timeStr) / 2;
        theme.drawString(graphics, (Object)timeStr, x1 - 1, 0, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)timeStr, x1 + 1, 0, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)timeStr, x1, 1, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)timeStr, x1, -1, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)timeStr, x1, 0, Color4I.WHITE, 0);
        poseStack.method_22909();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ItemPanel
    extends Panel {
        public ItemPanel() {
            super((Panel)EmergencyItemsScreen.this);
        }

        public void addWidgets() {
            ClientQuestFile.INSTANCE.getEmergencyItems().forEach(stack -> this.add(new EmergencyItemWidget(this, (class_1799)stack)));
        }

        public void alignWidgets() {
            this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
            this.setHeight(22);
            this.setPos((EmergencyItemsScreen.this.width - EmergencyItemsScreen.this.itemPanel.width) / 2, EmergencyItemsScreen.this.height * 2 / 3 - 10);
        }
    }

    private static class EmergencyItemWidget
    extends Widget {
        private final class_1799 stack;

        public EmergencyItemWidget(Panel panel, class_1799 stack) {
            super(panel);
            this.stack = stack;
            this.setY(3);
            this.setSize(16, 16);
        }

        public void addMouseOverText(TooltipList list) {
            ArrayList l = new ArrayList();
            GuiHelper.addStackTooltip((class_1799)this.stack, l);
            l.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            QuestShape.get("rsquare").getOutline().draw(graphics, x - 3, y - 3, w + 6, h + 6);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22904((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
            GuiHelper.drawItem((class_332)graphics, (class_1799)this.stack, (int)0, (boolean)true, null);
            graphics.method_51448().method_22909();
        }

        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of((Object)this.stack, (Widget)this);
        }
    }
}

