/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import dev.ftb.mods.ftblibrary.util.PanelPositioning;
import dev.ftb.mods.ftbquests.client.config.LocaleValue;
import dev.ftb.mods.ftbquests.client.gui.QuestsClientConfigScreen;

public interface FTBQuestsClientConfig {
    public static final String KEY = "ftbquests-client";
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbquests-client");
    public static final SNBTConfig UI = CONFIG.addGroup("ui", 0);
    public static final BooleanValue OLD_SCROLL_WHEEL = UI.addBoolean("old_scroll_wheel", false);
    public static final EnumValue<PanelPositioning> PINNED_QUESTS_POS = UI.addEnum("pinned_quests_pos", PanelPositioning.NAME_MAP, (Object)PanelPositioning.RIGHT);
    public static final IntValue PINNED_QUESTS_INSET_X = UI.addInt("pinned_quests_inset_x", 2);
    public static final IntValue PINNED_QUESTS_INSET_Y = UI.addInt("pinned_quests_inset_y", 2);
    public static final BooleanValue SHOW_LOCK_ICON = UI.addBoolean("show_lock_icon", true);
    public static final BooleanValue BACKSPACE_HISTORY = UI.addBoolean("backspace_history", true);
    public static final BooleanValue CHAPTER_PANEL_PINNED = UI.addBoolean("chapter_panel_pinned", false);
    public static final SNBTConfig XLATE = CONFIG.addGroup("xlate", 1);
    public static final StringValue EDITING_LOCALE = (StringValue)XLATE.add((BaseValue)new LocaleValue(XLATE, "editing_locale", ""));
    public static final BooleanValue HILITE_MISSING = XLATE.addBoolean("hilite_missing", true);

    public static void openSettings(boolean pauseGame) {
        ConfigManager.getInstance().createConfigGroup(KEY).ifPresent(group -> new QuestsClientConfigScreen((ConfigGroup)group, pauseGame).openGui());
    }

    public static void setChapterPanelPinned(boolean pinned) {
        if (pinned != (Boolean)CHAPTER_PANEL_PINNED.get()) {
            CHAPTER_PANEL_PINNED.set((Object)pinned);
            ConfigManager.getInstance().save(KEY);
        }
    }
}

