/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.fabric;

import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.integration.item_filtering.ItemMatchingSystem;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.EnergyTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_9326;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class FabricTaskScreenBlockEntity
extends TaskScreenBlockEntity {
    private final ItemStorageHandler itemStorage = new ItemStorageHandler();
    private final Storage<FluidVariant> fluidStorage = new FluidStorageHandler();
    private final EnergyStorage energyStorage = new RebornEnergyStorageHandler();

    public FabricTaskScreenBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(blockPos, blockState);
    }

    public Storage<ItemVariant> getItemStorage() {
        return this.itemStorage;
    }

    public Storage<FluidVariant> getFluidStorage() {
        return this.fluidStorage;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private class ItemStorageHandler
    extends SingleVariantStorage<ItemVariant> {
        private ItemStorageHandler() {
        }

        protected ItemVariant getBlankVariant() {
            return ItemVariant.blank();
        }

        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            ItemTask itemTask;
            TeamData data = FabricTaskScreenBlockEntity.this.getCachedTeamData();
            class_1799 stack = insertedVariant.toStack();
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask && data.canStartTasks((itemTask = (ItemTask)task).getQuest())) {
                class_1799 res = itemTask.insert(data, stack, true);
                int nAdded = stack.method_7947() - res.method_7947();
                if (nAdded > 0) {
                    this.updateSnapshots(transaction);
                    this.amount = FabricTaskScreenBlockEntity.this.getCachedTeamData().getProgress(itemTask) + (long)nAdded;
                }
                return nAdded;
            }
            return 0L;
        }

        public long extract(ItemVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                TeamData data;
                ItemTask itemTask = (ItemTask)task;
                if (!FabricTaskScreenBlockEntity.this.isInputOnly() && !ItemMatchingSystem.INSTANCE.isItemFilter(itemTask.getItemStack()) && (data = FabricTaskScreenBlockEntity.this.getCachedTeamData()) != null && data.canStartTasks(itemTask.getQuest()) && !data.isCompleted(itemTask)) {
                    int nRemoved = (int)Math.min(data.getProgress(itemTask), maxAmount);
                    if (nRemoved > 0) {
                        this.updateSnapshots(transaction);
                        this.amount = FabricTaskScreenBlockEntity.this.getCachedTeamData().getProgress(itemTask) - (long)nRemoved;
                    }
                    return nRemoved;
                }
            }
            return 0L;
        }

        protected void onFinalCommit() {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask itemTask = (ItemTask)task;
                if (FabricTaskScreenBlockEntity.this.getCachedTeamData() != null) {
                    FabricTaskScreenBlockEntity.this.getCachedTeamData().setProgress(itemTask, this.amount);
                }
            }
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        protected long getCapacity(ItemVariant variant) {
            long l;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask itemTask = (ItemTask)task;
                l = itemTask.getMaxProgress();
            } else {
                l = 0L;
            }
            return l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long getAmount() {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (!(task instanceof ItemTask)) return 0L;
            ItemTask itemTask = (ItemTask)task;
            if (FabricTaskScreenBlockEntity.this.getCachedTeamData() == null) return 0L;
            long l = FabricTaskScreenBlockEntity.this.getCachedTeamData().getProgress(itemTask);
            return l;
        }

        public ItemVariant getResource() {
            ItemVariant itemVariant;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask itemTask = (ItemTask)task;
                itemVariant = ItemVariant.of((class_1799)itemTask.getItemStack());
            } else {
                itemVariant = this.getBlankVariant();
            }
            return itemVariant;
        }
    }

    private class FluidStorageHandler
    extends SingleVariantStorage<FluidVariant> {
        private FluidStorageHandler() {
        }

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            long l;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask t = (FluidTask)task;
                l = t.getMaxProgress();
            } else {
                l = 0L;
            }
            return l;
        }

        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask fluidTask = (FluidTask)task;
                TeamData data = FabricTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(fluidTask.getQuest()) && !data.isCompleted(fluidTask) && fluidTask.getFluid() == insertedVariant.getFluid()) {
                    long curProgress = data.getProgress(fluidTask);
                    long space = fluidTask.getMaxProgress() - curProgress;
                    long toAdd = Math.min(maxAmount, space);
                    if (toAdd > 0L) {
                        this.updateSnapshots(transaction);
                        this.amount = curProgress + toAdd;
                    }
                    return toAdd;
                }
            }
            return 0L;
        }

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask fluidTask = (FluidTask)task;
                TeamData data = FabricTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(fluidTask.getQuest()) && !data.isCompleted(fluidTask)) {
                    long curProgress = data.getProgress(fluidTask);
                    long toTake = Math.min(maxAmount, curProgress);
                    if (toTake > 0L) {
                        this.updateSnapshots(transaction);
                        this.amount = curProgress - toTake;
                    }
                    return toTake;
                }
            }
            return 0L;
        }

        protected void onFinalCommit() {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask fluidTask = (FluidTask)task;
                if (FabricTaskScreenBlockEntity.this.getCachedTeamData() != null) {
                    FabricTaskScreenBlockEntity.this.getCachedTeamData().setProgress(fluidTask, this.amount);
                }
            }
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public FluidVariant getResource() {
            FluidVariant fluidVariant;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask fluidTask = (FluidTask)task;
                fluidVariant = FluidVariant.of((class_3611)fluidTask.getFluid(), (class_9326)fluidTask.getFluidDataComponentPatch());
            } else {
                fluidVariant = this.getBlankVariant();
            }
            return fluidVariant;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long getAmount() {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (!(task instanceof FluidTask)) return 0L;
            FluidTask fluidTask = (FluidTask)task;
            if (FabricTaskScreenBlockEntity.this.getCachedTeamData() == null) return 0L;
            long l = FabricTaskScreenBlockEntity.this.getCachedTeamData().getProgress(fluidTask);
            return l;
        }
    }

    private class RebornEnergyStorageHandler
    extends SimpleEnergyStorage {
        public RebornEnergyStorageHandler() {
            super(Long.MAX_VALUE, Long.MAX_VALUE, 0L);
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof EnergyTask) {
                EnergyTask energyTask = (EnergyTask)task;
                TeamData data = FabricTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(energyTask.getQuest()) && !data.isCompleted(energyTask)) {
                    long space = energyTask.getMaxProgress() - data.getProgress(energyTask);
                    long toAdd = Math.min(energyTask.getMaxInput(), Math.min(maxAmount, space));
                    if (toAdd > 0L) {
                        this.updateSnapshots(transaction);
                        this.amount = data.getProgress(energyTask) + toAdd;
                    }
                    return toAdd;
                }
            }
            return 0L;
        }

        protected void onFinalCommit() {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof EnergyTask) {
                EnergyTask energyTask = (EnergyTask)task;
                if (FabricTaskScreenBlockEntity.this.getCachedTeamData() != null) {
                    FabricTaskScreenBlockEntity.this.getCachedTeamData().setProgress(energyTask, this.amount);
                }
            }
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public boolean supportsExtraction() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long getAmount() {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (!(task instanceof EnergyTask)) return 0L;
            EnergyTask energyTask = (EnergyTask)task;
            if (FabricTaskScreenBlockEntity.this.getCachedTeamData() == null) return 0L;
            long l = (int)FabricTaskScreenBlockEntity.this.getCachedTeamData().getProgress(energyTask);
            return l;
        }

        public long getCapacity() {
            long l;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof EnergyTask) {
                EnergyTask energyTask = (EnergyTask)task;
                l = energyTask.getValue();
            } else {
                l = 0L;
            }
            return l;
        }
    }
}

