/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5156;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;

public class BasaltBlobFeature
extends class_3031<class_5156> {
    private static final Supplier<ImmutableList<class_2248>> CANNOT_PLACE_ON = Suppliers.memoize(() -> ImmutableList.of((Object)class_2246.field_10445, (Object)class_2246.field_10351, (Object)class_2246.field_10596, (Object)class_2246.field_9989, (Object)class_2246.field_10405, (Object)class_2246.field_10207, (Object)class_2246.field_10056, (Object)class_2246.field_10065, (Object)class_2246.field_10416, (Object)class_2246.field_10131, (Object)class_2246.field_9986, (Object)class_2246.field_10478, (Object[])new class_2248[]{class_2246.field_10497, class_2246.field_10024, class_2246.field_10131, class_2246.field_10381, class_2246.field_10515, class_2246.field_10114, class_2246.field_10093, class_2246.field_10346, class_2246.field_10289, class_2246.field_10322, class_2246.field_10412, class_2246.field_10329, class_2246.field_9994, class_2246.field_10310, class_2246.field_10435, class_2246.field_10576, class_2246.field_22090, class_2246.field_10255, class_2246.field_10024, class_2246.field_10164, class_2246.field_9987, class_2246.field_10092, class_2246.field_10114, class_2246.field_10266, class_2246.field_10364, class_2246.field_10159, class_2246.field_9974, class_2246.field_10034, RuBlocks.ASH_VENT.get(), RuBlocks.DEAD_LEAVES.get()}));

    public BasaltBlobFeature(Codec<class_5156> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_5156> context) {
        int i = context.method_33653().method_16398();
        class_2338 blockpos = context.method_33655();
        class_5281 worldgenlevel = context.method_33652();
        class_5819 randomsource = context.method_33654();
        class_5156 columnfeatureconfiguration = (class_5156)context.method_33656();
        if (!BasaltBlobFeature.canPlaceAt((class_1936)worldgenlevel, i, blockpos.method_25503())) {
            return false;
        }
        int j = columnfeatureconfiguration.method_30394().method_35008(randomsource);
        boolean flag = randomsource.method_43057() < 0.9f;
        int k = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (class_2338 blockpos1 : class_2338.method_27156((class_5819)randomsource, (int)l, (int)(blockpos.method_10263() - k), (int)blockpos.method_10264(), (int)(blockpos.method_10260() - k), (int)(blockpos.method_10263() + k), (int)blockpos.method_10264(), (int)(blockpos.method_10260() + k))) {
            int i1 = j - blockpos1.method_19455((class_2382)blockpos);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn((class_1936)worldgenlevel, i, blockpos1, i1, columnfeatureconfiguration.method_30391().method_35008(randomsource));
        }
        return flag1;
    }

    private boolean placeColumn(class_1936 level, int ylevel, class_2338 pos, int k, int offset) {
        boolean flag = false;
        block0: for (class_2338 blockpos : class_2338.method_10094((int)(pos.method_10263() - offset), (int)pos.method_10264(), (int)(pos.method_10260() - offset), (int)(pos.method_10263() + offset), (int)pos.method_10264(), (int)(pos.method_10260() + offset))) {
            int i = blockpos.method_19455((class_2382)pos);
            class_2338 pos1 = BasaltBlobFeature.isAirOrLavaOcean(level, ylevel, blockpos) ? BasaltBlobFeature.findSurface(level, ylevel, blockpos.method_25503(), i) : BasaltBlobFeature.findAir(level, blockpos.method_25503(), i);
            if (pos1 == null) continue;
            class_2338.class_2339 blockpos$mutableblockpos = pos1.method_25503();
            for (int j = k - i / 2; j >= 0; --j) {
                if (BasaltBlobFeature.isAirOrLavaOcean(level, ylevel, (class_2338)blockpos$mutableblockpos)) {
                    this.method_13153((class_1945)level, (class_2338)blockpos$mutableblockpos, class_2246.field_22091.method_9564());
                    blockpos$mutableblockpos.method_10098(class_2350.field_11036);
                    flag = true;
                    continue;
                }
                if (!level.method_8320((class_2338)blockpos$mutableblockpos).method_27852(class_2246.field_22091)) continue block0;
                blockpos$mutableblockpos.method_10098(class_2350.field_11036);
            }
        }
        return flag;
    }

    private static class_2338 findSurface(class_1936 level, int ylevel, class_2338.class_2339 pos, int i) {
        while (pos.method_10264() > level.method_31607() + 1 && i > 0) {
            --i;
            if (BasaltBlobFeature.canPlaceAt(level, ylevel, pos)) {
                return pos;
            }
            pos.method_10098(class_2350.field_11033);
        }
        return null;
    }

    private static boolean canPlaceAt(class_1936 level, int ylevel, class_2338.class_2339 pos) {
        if (!BasaltBlobFeature.isAirOrLavaOcean(level, ylevel, (class_2338)pos)) {
            return false;
        }
        class_2680 blockstate = level.method_8320((class_2338)pos.method_10098(class_2350.field_11033));
        pos.method_10098(class_2350.field_11036);
        return !blockstate.method_26215() && !CANNOT_PLACE_ON.get().contains((Object)blockstate.method_26204());
    }

    private static class_2338 findAir(class_1936 level, class_2338.class_2339 pos, int i) {
        while (pos.method_10264() < level.method_31600() && i > 0) {
            --i;
            class_2680 blockstate = level.method_8320((class_2338)pos);
            if (CANNOT_PLACE_ON.get().contains((Object)blockstate.method_26204())) {
                return null;
            }
            if (blockstate.method_26215()) {
                return pos;
            }
            pos.method_10098(class_2350.field_11036);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(class_1936 levelAccessor, int ylevel, class_2338 pos) {
        class_2680 blockstate = levelAccessor.method_8320(pos);
        return blockstate.method_26215() || blockstate.method_27852(class_2246.field_10164) || blockstate.method_26164(RuTags.REPLACEABLE_BLOCKS) || blockstate.method_27852(class_2246.field_10382) && pos.method_10264() <= ylevel;
    }
}

