/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.entity.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_881;
import net.regions_unexplored.Constants;
import net.regions_unexplored.entity.custom.RuBoat;
import net.regions_unexplored.entity.custom.RuChestBoat;
import org.joml.Quaternionf;

public class RuBoatRenderer
extends class_881 {
    private final Map<RuBoat.ModelType, Pair<class_2960, class_4595<class_1690>>> boatResources = (Map)Stream.of(RuBoat.ModelType.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)Constants.id(RuBoatRenderer.getTextureLocation(model, chest)), (Object)this.createBoatModel(context, (RuBoat.ModelType)((Object)model), chest))));

    public RuBoatRenderer(class_5617.class_5618 context, boolean chest) {
        super(context, false);
    }

    public void method_3888(class_1690 entity, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        float h;
        Pair<class_2960, class_4595<class_1690>> pair = null;
        if (entity instanceof RuBoat) {
            RuBoat entity1 = (RuBoat)entity;
            pair = this.boatResources.get((Object)entity1.getModel());
        } else if (entity instanceof RuChestBoat) {
            RuChestBoat entity2 = (RuChestBoat)entity;
            pair = this.boatResources.get((Object)entity2.getModel());
        }
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.375f, 0.0f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entityYaw));
        float f = (float)entity.method_54295() - partialTicks;
        float g = entity.method_54294() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * g / 10.0f * (float)entity.method_54296()));
        }
        if (!class_3532.method_15347((float)(h = entity.method_7547(partialTicks)), (float)0.0f)) {
            matrixStack.method_22907(new Quaternionf().setAngleAxis(entity.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        class_2960 resourceLocation = (class_2960)pair.getFirst();
        class_4595 listModel = (class_4595)pair.getSecond();
        matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        listModel.method_2819((class_1297)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = buffer.getBuffer(listModel.method_23500(resourceLocation));
        listModel.method_60879(matrixStack, vertexConsumer, packedLight, class_4608.field_21444);
        if (!entity.method_5869()) {
            class_4588 vertexConsumer2 = buffer.getBuffer(class_1921.method_23589());
            if (listModel instanceof class_7755) {
                class_7755 waterPatchModel = (class_7755)listModel;
                waterPatchModel.method_22954().method_22698(matrixStack, vertexConsumer2, packedLight, class_4608.field_21444);
            }
        }
        matrixStack.method_22909();
    }

    private static String getTextureLocation(RuBoat.ModelType type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    private class_554 createBoatModel(class_5617.class_5618 context, RuBoat.ModelType type, boolean chest) {
        class_5601 modellayerlocation = chest ? RuBoatRenderer.chestBoatTextureLocation(type) : RuBoatRenderer.boatTextureLocation(type);
        class_630 baked = context.method_32167(modellayerlocation);
        return chest ? new class_7752(baked) : new class_554(baked);
    }

    private static class_5601 getModel(String name, String model) {
        return new class_5601(Constants.id(name), model);
    }

    public static class_5601 boatTextureLocation(RuBoat.ModelType type) {
        return RuBoatRenderer.getModel("boat/" + type.getName(), "main");
    }

    public static class_5601 chestBoatTextureLocation(RuBoat.ModelType type) {
        return RuBoatRenderer.getModel("chest_boat/" + type.getName(), "main");
    }
}

