/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5819;

public class MthUtils {
    public static final float PHI = (float)(1.0 + (Math.sqrt(5.0) - 1.0) / 2.0);

    public static float[] polarToCartesian(float a, float r) {
        float x = r * class_3532.method_15362((float)a);
        float y = r * class_3532.method_15374((float)a);
        return new float[]{x, y};
    }

    public static float signedAngleDiff(double to, double from) {
        float x1 = class_3532.method_15362((float)((float)to));
        float y1 = class_3532.method_15374((float)((float)to));
        float x2 = class_3532.method_15362((float)((float)from));
        float y2 = class_3532.method_15374((float)((float)from));
        return (float)class_3532.method_15349((double)(x1 * y1 - y1 * x2), (double)(x1 * x2 + y1 * y2));
    }

    public static float clampDegrees(float angle, float first, float second) {
        float diffB;
        float distanceToB;
        angle = (angle % 360.0f + 360.0f) % 360.0f;
        if ((first = (first % 360.0f + 360.0f) % 360.0f) == (second = (second % 360.0f + 360.0f) % 360.0f)) {
            return angle;
        }
        float deltaThetaA = (angle - first + 360.0f) % 360.0f;
        float deltaAB = (second - first + 360.0f) % 360.0f;
        if (deltaThetaA <= deltaAB) {
            return angle;
        }
        float diffA = Math.abs(angle - first);
        float distanceToA = Math.min(diffA, 360.0f - diffA);
        return class_3532.method_15393((float)(distanceToA < (distanceToB = Math.min(diffB = Math.abs(angle - second), 360.0f - diffB)) ? first : second));
    }

    public static class_243 changeBasisN(class_243 newBasisYVector, class_243 rot) {
        class_243 y = newBasisYVector.method_1029();
        class_243 x = new class_243(y.field_1351, y.field_1350, y.field_1352).method_1029();
        class_243 z = y.method_1036(x).method_1029();
        return MthUtils.changeBasis(x, y, z, rot);
    }

    public static class_243 changeBasis(class_243 newX, class_243 newY, class_243 newZ, class_243 rot) {
        return newX.method_1021(rot.field_1352).method_1019(newY.method_1021(rot.field_1351)).method_1019(newZ.method_1021(rot.field_1350));
    }

    public static class_243 getNormalFrom3DData(int direction) {
        return MthUtils.V3itoV3(class_2350.method_10143((int)direction).method_10163());
    }

    public static class_243 V3itoV3(class_2382 v) {
        return new class_243((double)v.method_10263(), (double)v.method_10264(), (double)v.method_10260());
    }

    private static double isClockWise(UnaryOperator<class_243> rot, class_2350 dir) {
        class_243 v = MthUtils.V3itoV3(dir.method_10163());
        class_243 v2 = (class_243)rot.apply(v);
        return v2.method_1026(new class_243(0.0, 1.0, 0.0));
    }

    public static class_243 rotateVec3(class_243 vec, class_2350 dir) {
        double cos = 1.0;
        double sin = 0.0;
        switch (dir) {
            case field_11035: {
                cos = -1.0;
                sin = 0.0;
                break;
            }
            case field_11039: {
                cos = 0.0;
                sin = 1.0;
                break;
            }
            case field_11034: {
                cos = 0.0;
                sin = -1.0;
                break;
            }
            case field_11036: {
                return new class_243(vec.field_1352, -vec.field_1350, vec.field_1351);
            }
            case field_11033: {
                return new class_243(vec.field_1352, vec.field_1350, vec.field_1351);
            }
        }
        double dx = vec.field_1352 * cos + vec.field_1350 * sin;
        double dy = vec.field_1351;
        double dz = vec.field_1350 * cos - vec.field_1352 * sin;
        return new class_243(dx, dy, dz);
    }

    public static float averageAngles(Float ... angles) {
        float x = 0.0f;
        float y = 0.0f;
        Float[] floatArray = angles;
        int n = floatArray.length;
        for (int i = 0; i < n; ++i) {
            float a = floatArray[i].floatValue();
            x += class_3532.method_15362((float)((float)((double)a * Math.PI * 2.0)));
            y += class_3532.method_15374((float)((float)((double)a * Math.PI * 2.0)));
        }
        return (float)(class_3532.method_15349((double)y, (double)x) / (Math.PI * 2));
    }

    public static double getPitch(class_243 vec3) {
        return -Math.toDegrees(Math.asin(vec3.field_1351));
    }

    public static double getYaw(class_243 vec3) {
        return Math.toDegrees(Math.atan2(-vec3.field_1352, vec3.field_1350));
    }

    public static double getRoll(class_243 vec3) {
        return Math.toDegrees(Math.atan2(vec3.field_1351, vec3.field_1352));
    }

    public static double wrapRad(double pValue) {
        double p = Math.PI * 2;
        double d0 = pValue % p;
        if (d0 >= Math.PI) {
            d0 -= p;
        }
        if (d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    public static float wrapRad(float pValue) {
        float p = (float)Math.PI * 2;
        float d0 = pValue % p;
        if ((double)d0 >= Math.PI) {
            d0 -= p;
        }
        if ((double)d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    public static float nextWeighted(class_5819 rand, float max, float bias) {
        float r = rand.method_43057();
        if (bias <= 0.0f) {
            if (bias == 0.0f) {
                return r * max;
            }
            bias = -bias / (bias - 1.0f);
        }
        return max * (1.0f - r) / (bias * max * r + 1.0f);
    }

    public static float nextWeighted(class_5819 rand, float max, float bias, float min) {
        return MthUtils.nextWeighted(rand, max - min, bias) + min;
    }

    public static float nextWeighted(class_5819 rand, float max) {
        return MthUtils.nextWeighted(rand, max, 1.0f);
    }

    public static <T extends BaseColor<T>> T lerpColorScale(List<T> palette, float phase) {
        if (phase >= 1.0f) {
            phase %= 1.0f;
        }
        int n = palette.size();
        float g = (float)n * phase;
        int ind = (int)Math.floor(g);
        float delta = g % 1.0f;
        BaseColor start = (BaseColor)palette.get(ind);
        BaseColor end = (BaseColor)palette.get((ind + 1) % n);
        return (T)start.mixWith(end, delta);
    }

    public static boolean isWithinRectangle(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static class_265 rotateVoxelShape(class_265 source, class_2350 direction) {
        if (direction == class_2350.field_11043) {
            return source;
        }
        AtomicReference<class_265> newShape = new AtomicReference<class_265>(class_259.method_1073());
        source.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            class_243 min = new class_243(minX - 0.5, minY - 0.5, minZ - 0.5);
            class_243 max = new class_243(maxX - 0.5, maxY - 0.5, maxZ - 0.5);
            class_243 v1 = MthUtils.rotateVec3(min, direction);
            class_243 v2 = MthUtils.rotateVec3(max, direction);
            class_265 s = class_259.method_31943((double)(0.5 + Math.min(v1.field_1352, v2.field_1352)), (double)(0.5 + Math.min(v1.field_1351, v2.field_1351)), (double)(0.5 + Math.min(v1.field_1350, v2.field_1350)), (double)(0.5 + Math.max(v1.field_1352, v2.field_1352)), (double)(0.5 + Math.max(v1.field_1351, v2.field_1351)), (double)(0.5 + Math.max(v1.field_1350, v2.field_1350)));
            newShape.set(class_259.method_1084((class_265)((class_265)newShape.get()), (class_265)s));
        });
        return newShape.get();
    }

    public static class_265 moveVoxelShape(class_265 source, class_243 v) {
        AtomicReference<class_265> newShape = new AtomicReference<class_265>(class_259.method_1073());
        source.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            class_265 s = class_259.method_31943((double)(minX + v.field_1352), (double)(minY + v.field_1351), (double)(minZ + v.field_1350), (double)(maxX + v.field_1352), (double)(maxY + v.field_1351), (double)(maxZ + v.field_1350));
            newShape.set(class_259.method_1084((class_265)((class_265)newShape.get()), (class_265)s));
        });
        return newShape.get();
    }

    public static double lambertW0(double x) {
        double maxError = 1.0E-6;
        if (x == -0.36787944117144233) {
            return -1.0;
        }
        if (x >= -0.36787944117144233) {
            double nLog = Math.log(x);
            double nLog0 = 1.0;
            while (Math.abs(nLog0 - nLog) > maxError) {
                nLog0 = x * Math.exp(-nLog) / (1.0 + nLog);
                nLog = x * Math.exp(-nLog0) / (1.0 + nLog0);
            }
            return Math.round(1000000.0 * nLog) / 1000000L;
        }
        throw new IllegalArgumentException("Not in valid range for lambertW function. x has to be greater than or equal to -1/e.");
    }

    public static double lambertW1(double x) {
        double maxError = 1.0E-6;
        if (x == -0.36787944117144233) {
            return -1.0;
        }
        if (x < 0.0 && x > -0.36787944117144233) {
            double nLog = Math.log(-x);
            double nLog0 = 1.0;
            while (Math.abs(nLog0 - nLog) > maxError) {
                nLog0 = (nLog * nLog + x / Math.exp(nLog)) / (nLog + 1.0);
                nLog = (nLog0 * nLog0 + x / Math.exp(nLog0)) / (nLog0 + 1.0);
            }
            return Math.round(1000000.0 * nLog) / 1000000L;
        }
        if (x == 0.0) {
            return 0.0;
        }
        throw new IllegalArgumentException("Not in valid range for lambertW function. x has to be in [-1/e,0]");
    }

    private static float exp01(float t, float base) {
        return (float)((double)base * Math.pow(1.0f / base + 1.0f, t) - (double)base);
    }

    public static float normalizedExponent(float t, float curve) {
        if (curve == 0.0f) {
            return t;
        }
        float base = curve > 0.0f ? (float)(-Math.log(curve)) : (float)(Math.log(-curve) - 1.0);
        return MthUtils.exp01(t, base);
    }

    public static class_3965 collideWithSweptAABB(class_1297 entity, class_243 movement, double maxStep) {
        class_238 aabb = entity.method_5829();
        return MthUtils.collideWithSweptAABB(entity.method_19538(), aabb, movement, entity.method_37908(), maxStep);
    }

    public static class_3965 collideWithSweptAABB(class_243 myPos, class_238 myBox, class_243 movement, class_1937 level, double maxStep) {
        double len = movement.method_1033();
        if (maxStep >= len) {
            return MthUtils.collideWithSweptAABB(myPos, myBox, movement, level);
        }
        class_243 stepMovement = movement.method_1029().method_1021(maxStep);
        class_243 currentPos = myPos;
        for (double moved = 0.0; moved < len; moved += maxStep) {
            class_3965 result;
            if (moved + maxStep > len) {
                stepMovement = movement.method_1021((len - moved) / len);
            }
            if ((result = MthUtils.collideWithSweptAABB(currentPos, myBox, stepMovement, level)).method_17783() != class_239.class_240.field_1333) {
                return result;
            }
            currentPos = currentPos.method_1019(stepMovement);
            myBox = myBox.method_997(stepMovement);
        }
        class_243 missPos = myPos.method_1019(movement);
        return class_3965.method_17778((class_243)missPos, (class_2350)class_2350.field_11036, (class_2338)class_2338.method_49638((class_2374)missPos));
    }

    public static class_3965 collideWithSweptAABB(class_243 myPos, class_238 myBox, class_243 movement, class_1937 level) {
        class_238 encompassing = myBox.method_18804(movement);
        Set positions = class_2338.method_29715((class_238)encompassing).map(class_2338::method_10062).collect(Collectors.toSet());
        CollisionResult earliestCollision = null;
        class_2338 hitPos = null;
        for (class_2338 pos : positions) {
            class_2680 state = level.method_8320(pos);
            if (state.method_26215()) continue;
            List boxes = state.method_26220((class_1922)level, pos).method_1090();
            for (class_238 box : boxes) {
                CollisionResult result = MthUtils.sweptAABB(myBox, box = box.method_996(pos), movement);
                if (result == null || result.entryTime < 0.0) continue;
                if (earliestCollision == null) {
                    earliestCollision = result;
                    hitPos = pos;
                    continue;
                }
                if (result.entryTime == earliestCollision.entryTime) {
                    class_243 collidedPos = myPos.method_1019(movement.method_1021(result.entryTime));
                    if (!(pos.method_19770((class_2374)collidedPos) < hitPos.method_19770((class_2374)collidedPos))) continue;
                    earliestCollision = result;
                    hitPos = pos;
                    continue;
                }
                if (!(result.entryTime < earliestCollision.entryTime)) continue;
                earliestCollision = result;
                hitPos = pos;
            }
        }
        if (earliestCollision != null && earliestCollision.entryTime < 1.0) {
            double entryTime = earliestCollision.entryTime - (double)1.0E-5f;
            movement = movement.method_1021(entryTime);
            class_243 finalPos = myPos.method_1019(movement);
            return new class_3965(finalPos, earliestCollision.direction.method_10153(), hitPos, false);
        }
        class_243 missPos = myPos.method_1019(movement);
        return class_3965.method_17778((class_243)missPos, (class_2350)class_2350.field_11036, (class_2338)class_2338.method_49638((class_2374)missPos));
    }

    private static CollisionResult sweptAABB(class_238 movingBox, class_238 staticBox, class_243 movement) {
        double exitZ;
        double entryZ;
        double exitY;
        double entryY;
        double exitX;
        double entryX;
        if (movement.field_1352 > 0.0) {
            entryX = (staticBox.field_1323 - movingBox.field_1320) / movement.field_1352;
            exitX = (staticBox.field_1320 - movingBox.field_1323) / movement.field_1352;
        } else if (movement.field_1352 < 0.0) {
            entryX = (staticBox.field_1320 - movingBox.field_1323) / movement.field_1352;
            exitX = (staticBox.field_1323 - movingBox.field_1320) / movement.field_1352;
        } else {
            entryX = Double.NEGATIVE_INFINITY;
            exitX = Double.POSITIVE_INFINITY;
        }
        if (movement.field_1351 > 0.0) {
            entryY = (staticBox.field_1322 - movingBox.field_1325) / movement.field_1351;
            exitY = (staticBox.field_1325 - movingBox.field_1322) / movement.field_1351;
        } else if (movement.field_1351 < 0.0) {
            entryY = (staticBox.field_1325 - movingBox.field_1322) / movement.field_1351;
            exitY = (staticBox.field_1322 - movingBox.field_1325) / movement.field_1351;
        } else {
            entryY = Double.NEGATIVE_INFINITY;
            exitY = Double.POSITIVE_INFINITY;
        }
        if (movement.field_1350 > 0.0) {
            entryZ = (staticBox.field_1321 - movingBox.field_1324) / movement.field_1350;
            exitZ = (staticBox.field_1324 - movingBox.field_1321) / movement.field_1350;
        } else if (movement.field_1350 < 0.0) {
            entryZ = (staticBox.field_1324 - movingBox.field_1321) / movement.field_1350;
            exitZ = (staticBox.field_1321 - movingBox.field_1324) / movement.field_1350;
        } else {
            entryZ = Double.NEGATIVE_INFINITY;
            exitZ = Double.POSITIVE_INFINITY;
        }
        double entryTime = Math.max(Math.max(entryX, entryY), entryZ);
        double exitTime = Math.min(Math.min(exitX, exitY), exitZ);
        if (entryTime > exitTime || entryX < 0.0 && entryY < 0.0 && entryZ < 0.0 || entryX > 1.0 || entryY > 1.0 || entryZ > 1.0) {
            return null;
        }
        class_2350 collisionDirection = entryX > entryY && entryX > entryZ ? (movement.field_1352 > 0.0 ? class_2350.field_11034 : class_2350.field_11039) : (entryY > entryZ ? (movement.field_1351 > 0.0 ? class_2350.field_11036 : class_2350.field_11033) : (movement.field_1350 > 0.0 ? class_2350.field_11035 : class_2350.field_11043));
        return new CollisionResult(entryTime, collisionDirection);
    }

    private record CollisionResult(double entryTime, class_2350 direction) {
    }
}

