/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.core.set.BlocksColorInternal;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public class BlocksColorAPI {
    public static final List<class_1767> SORTED_COLORS = (List)class_156.method_656(() -> {
        ImmutableList.Builder b = ImmutableList.builder();
        List<class_1767> l = List.of(class_1767.field_7952, class_1767.field_7967, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957, class_1767.field_7964, class_1767.field_7946, class_1767.field_7947, class_1767.field_7961, class_1767.field_7942, class_1767.field_7955, class_1767.field_7951, class_1767.field_7966, class_1767.field_7945, class_1767.field_7958, class_1767.field_7954);
        b.addAll(l);
        for (class_1767 v : class_1767.values()) {
            if (l.contains(v)) continue;
            b.add((Object)v);
        }
        return b.build();
    });

    @Nullable
    public static class_1767 getColor(class_2248 block) {
        return BlocksColorInternal.getColor(block);
    }

    @Nullable
    public static class_1767 getColor(class_1792 item) {
        return BlocksColorInternal.getColor(item);
    }

    @Nullable
    public static class_1792 getColoredItem(String key, @Nullable class_1767 color) {
        return BlocksColorInternal.getColoredItem(key, color);
    }

    @Nullable
    public static class_2248 getColoredBlock(String key, @Nullable class_1767 color) {
        return BlocksColorInternal.getColoredBlock(key, color);
    }

    public static boolean isDefaultColor(class_2248 block) {
        String key = BlocksColorAPI.getKey(block);
        if (key == null) {
            return true;
        }
        return BlocksColorAPI.getColoredBlock(key, null) == block;
    }

    public static boolean isDefaultColor(class_1792 item) {
        String key = BlocksColorAPI.getKey(item);
        if (key == null) {
            return true;
        }
        return BlocksColorAPI.getColoredItem(key, null) == item;
    }

    @Nullable
    public static class_2248 changeColor(class_2248 old, @Nullable class_1767 newColor) {
        return BlocksColorInternal.changeColor(old, newColor);
    }

    @Nullable
    public static class_1792 changeColor(class_1792 old, @Nullable class_1767 newColor) {
        return BlocksColorInternal.changeColor(old, newColor);
    }

    @Nullable
    public static String getKey(class_2248 block) {
        return BlocksColorInternal.getKey(block);
    }

    @Nullable
    public static String getKey(class_1792 item) {
        return BlocksColorInternal.getKey(item);
    }

    public static Set<String> getBlockKeys() {
        return BlocksColorInternal.getBlockKeys();
    }

    public static Set<String> getItemKeys() {
        return BlocksColorInternal.getItemKeys();
    }

    @Nullable
    public static class_6885<class_2248> getBlockHolderSet(String key) {
        return BlocksColorInternal.getBlockHolderSet(key);
    }

    @Nullable
    public static class_6885<class_1792> getItemHolderSet(String key) {
        return BlocksColorInternal.getItemHolderSet(key);
    }

    public static void registerBlockColorSet(class_2960 key, EnumMap<class_1767, class_2248> blocks, @Nullable class_2248 defaultBlock) {
        BlocksColorInternal.registerBlockColorSet(key, blocks, defaultBlock);
    }

    public static void registerItemColorSet(class_2960 key, EnumMap<class_1767, class_1792> items, @Nullable class_1792 defaultItem) {
        BlocksColorInternal.registerItemColorSet(key, items, defaultItem);
    }

    public static <T> Stream<T> ordered(Map<class_1767, T> map) {
        return map.entrySet().stream().sorted(Comparator.comparing(entry -> SORTED_COLORS.indexOf(entry.getKey()))).map(Map.Entry::getValue);
    }
}

