/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3542;
import net.minecraft.class_4966;
import net.minecraft.class_4970;
import org.apache.commons.lang3.tuple.Triple;

public enum StructurePlacement implements class_3542
{
    SURFACE((context, box) -> StructurePlacement.findFromTop(context, box, class_2902.class_2903.field_13194, 10, 3.0, class_4970.class_4971::method_51367)),
    CEILING((context, box) -> {
        List positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.comp_562().method_18028(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()), context.comp_569().method_31600());
            class_4966 column = context.comp_562().method_26261(pos.method_10263(), pos.method_10260(), context.comp_569(), context.comp_564());
            for (int y = context.comp_569().method_31607() + 1; y < highest; ++y) {
                if (column.method_32892(y).method_26215()) continue;
                return pos.method_33098(y);
            }
            return null;
        }).collect(Collectors.toList());
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int[] heights = positions.stream().mapToInt(class_2382::method_10264).toArray();
        int average = (int)Math.round(IntStream.of(heights).average().getAsDouble());
        if (IntStream.of(heights).map(y -> Math.abs(average - y)).average().getAsDouble() > 4.0) {
            return null;
        }
        return average;
    }),
    ON_WATER((context, box) -> StructurePlacement.findFromTop(context, box, class_2902.class_2903.field_13194, 1, 1.0, state -> state.method_27852(class_2246.field_10382))),
    ON_LAVA((context, box) -> StructurePlacement.findFromTop(context, box, class_2902.class_2903.field_13194, 1, 1.0, state -> state.method_27852(class_2246.field_10164))),
    UNDERGROUND((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.comp_562().method_18028(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()), context.comp_569().method_31600());
            class_4966 column = context.comp_562().method_26261(pos.method_10263(), pos.method_10260(), context.comp_569(), context.comp_564());
            int lowest = context.comp_569().method_31607();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.method_32892(y).method_26215()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.comp_569().method_31607()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.method_14660()) {
            return null;
        }
        return min + 1 + context.comp_566().method_43048(max - min - box.method_14660() - 2);
    }),
    UNDERGROUND_SURFACE((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.comp_562().method_18028(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()), context.comp_569().method_31600());
            class_4966 column = context.comp_562().method_26261(pos.method_10263(), pos.method_10260(), context.comp_569(), context.comp_564());
            int lowest = context.comp_569().method_31607();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.method_32892(y).method_26215()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.comp_569().method_31607()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.method_14660()) {
            return null;
        }
        int height = min + 1 + context.comp_566().method_43048(max - min - box.method_14660() - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            class_4966 column = (class_4966)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.method_32892(y).method_26215(); --y, ++i) {
            }
            if (!column.method_32892(y).method_26215()) {
                return null;
            }
            --y;
            for (i = 0; i < 20 && column.method_32892(y).method_26215(); ++i) {
                --y;
            }
            if (!column.method_32892(y).method_51367()) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).max().getAsInt() > 5) {
            return null;
        }
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).average().getAsDouble() > 3.0) {
            return null;
        }
        return average;
    }),
    UNDERGROUND_CEILING((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.comp_562().method_18028(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()), context.comp_569().method_31600());
            class_4966 column = context.comp_562().method_26261(pos.method_10263(), pos.method_10260(), context.comp_569(), context.comp_564());
            int lowest = context.comp_569().method_31607();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.method_32892(y).method_26215()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.comp_569().method_31607()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.method_14660()) {
            return null;
        }
        int height = min + 1 + context.comp_566().method_43048(max - min - box.method_14660() - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            class_4966 column = (class_4966)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.method_32892(y).method_26215(); ++y, ++i) {
            }
            if (!column.method_32892(y).method_26215()) {
                return null;
            }
            ++y;
            for (i = 0; i < 30 && column.method_32892(y).method_26215(); ++i) {
                ++y;
            }
            if (!column.method_32892(y).method_51367()) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).max().getAsInt() > 5) {
            return null;
        }
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).average().getAsDouble() > 3.0) {
            return null;
        }
        return average;
    }),
    UNDERGROUND_BURIED((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.comp_562().method_18028(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()), context.comp_569().method_31600());
            class_4966 column = context.comp_562().method_26261(pos.method_10263(), pos.method_10260(), context.comp_569(), context.comp_564());
            int lowest = context.comp_569().method_31607();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.method_32892(y).method_26215()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.comp_569().method_31607()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.method_14660()) {
            return null;
        }
        int ySpan = box.method_14660();
        int height = min + ySpan + 1 + context.comp_566().method_43048(max - min - ySpan - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            class_4966 column = (class_4966)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.method_32892(y).method_51367(); --y, ++i) {
            }
            if (!column.method_32892(y).method_51367()) {
                return null;
            }
            y -= 2;
            for (i = 0; i < ySpan; ++i) {
                if (!column.method_32892(y).method_51367()) {
                    return null;
                }
                --y;
            }
            if (!column.method_32892(y).method_51367() || !column.method_32892(y - 1).method_51367()) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (!positions.stream().allMatch(t -> {
            class_4966 column = (class_4966)t.getLeft();
            return column.method_32892(average).method_51367() && column.method_32892(average + ySpan).method_51367();
        })) {
            return null;
        }
        return average;
    }),
    UNDERGROUND_ON_LAVA((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.comp_562().method_18028(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()), context.comp_569().method_31600());
            class_4966 column = context.comp_562().method_26261(pos.method_10263(), pos.method_10260(), context.comp_569(), context.comp_564());
            int lowest = context.comp_569().method_31607();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.method_32892(y).method_26215()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.comp_569().method_31607()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.method_14660()) {
            return null;
        }
        int height = min + 1 + context.comp_566().method_43048(max - min - box.method_14660() - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            class_4966 column = (class_4966)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.method_32892(y).method_26215(); --y, ++i) {
            }
            if (!column.method_32892(y).method_26215()) {
                return null;
            }
            --y;
            for (i = 0; i < 40 && column.method_32892(y).method_26215(); ++i) {
                --y;
            }
            if (!column.method_32892(y).method_27852(class_2246.field_10164)) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).max().getAsInt() > 5) {
            return null;
        }
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).average().getAsDouble() > 3.0) {
            return null;
        }
        return average;
    });

    public static final Codec<StructurePlacement> CODEC;
    final BiFunction<class_3195.class_7149, class_3341, Integer> locator;

    private StructurePlacement(BiFunction<class_3195.class_7149, class_3341, Integer> locator) {
        this.locator = locator;
    }

    public Optional<Integer> findHeight(class_3195.class_7149 context, class_3341 boundingBox) {
        return Optional.ofNullable(this.locator.apply(context, boundingBox));
    }

    public String method_15434() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private static Stream<class_2338.class_2339> cornersAndCenter(class_3341 box) {
        class_2338 center = box.method_22874();
        return Stream.of(new class_2338.class_2339(box.method_35415(), 0, box.method_35417()), new class_2338.class_2339(box.method_35415(), 0, box.method_35420()), new class_2338.class_2339(box.method_35418(), 0, box.method_35420()), new class_2338.class_2339(box.method_35418(), 0, box.method_35417()), new class_2338.class_2339(center.method_10263(), 0, center.method_10260()));
    }

    private static Integer findFromTop(class_3195.class_7149 context, class_3341 box, class_2902.class_2903 heightmap, int maxOffset, double maxAverageOffset, Predicate<class_2680> target) {
        List positions = StructurePlacement.cornersAndCenter(box).map(pos -> pos.method_33098(context.comp_562().method_18028(pos.method_10263(), pos.method_10260(), heightmap, context.comp_569(), context.comp_564()))).collect(Collectors.toList());
        int[] heights = positions.stream().mapToInt(class_2382::method_10264).toArray();
        if (IntStream.of(heights).anyMatch(y -> y <= context.comp_569().method_31607())) {
            return null;
        }
        if (positions.stream().anyMatch(pos -> !target.test(context.comp_562().method_26261(pos.method_10263(), pos.method_10260(), context.comp_569(), context.comp_564()).method_32892(pos.method_10264())))) {
            return null;
        }
        int average = (int)Math.round(IntStream.of(heights).average().getAsDouble());
        if (IntStream.of(heights).map(y -> Math.abs(average - y)).max().getAsInt() > maxOffset) {
            return null;
        }
        if (IntStream.of(heights).map(y -> Math.abs(average - y)).average().getAsDouble() > maxAverageOffset) {
            return null;
        }
        return average;
    }

    static {
        CODEC = class_3542.method_28140(StructurePlacement::values);
    }
}

