/*
 * Decompiled with CFR 0.152.
 */
package net.oblivion.block.entity;

import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.oblivion.block.MultiOreBlock;
import net.oblivion.init.BlockInit;
import org.jetbrains.annotations.Nullable;

public class MultiOreBlockEntity
extends class_2586 {
    private int drillCount = 7;

    public MultiOreBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockInit.MULTI_ORE_BLOCK_ENTITY, pos, state);
    }

    public MultiOreBlockEntity(class_2338 pos, class_2680 state, int drillCount) {
        this(pos, state);
        this.drillCount = drillCount;
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.drillCount = nbt.method_10550("DrillCount");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("DrillCount", this.drillCount);
    }

    public void decrementDrillCount(@Nullable class_2338 dropStackPos) {
        --this.drillCount;
        this.handleMultiOre(dropStackPos);
    }

    public int getDrillCount() {
        return this.drillCount;
    }

    private void handleMultiOre(@Nullable class_2338 dropStackPos) {
        if (this.method_10997() != null && !this.method_10997().method_8608()) {
            class_2338 class_23382 = dropStackPos = dropStackPos != null ? dropStackPos : this.method_11016();
            if (this.drillCount > 0) {
                class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_10997()).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.method_11016())).method_51874(class_181.field_1229, (Object)new class_1799((class_1935)class_1802.field_22024));
                Storage storage = (Storage)ItemStorage.SIDED.find(this.field_11863, dropStackPos, null);
                for (class_1799 stack : this.method_11010().method_26189(builder)) {
                    if (storage != null) {
                        Transaction transaction = Transaction.openOuter();
                        try {
                            long amountInserted = storage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
                            if (amountInserted == (long)stack.method_7947()) {
                                transaction.commit();
                                continue;
                            }
                            class_1264.method_5449((class_1937)this.method_10997(), (double)dropStackPos.method_10263(), (double)dropStackPos.method_10264(), (double)dropStackPos.method_10260(), (class_1799)stack);
                            continue;
                        }
                        finally {
                            if (transaction != null) {
                                transaction.close();
                            }
                            continue;
                        }
                    }
                    class_1264.method_5449((class_1937)this.method_10997(), (double)dropStackPos.method_10263(), (double)dropStackPos.method_10264(), (double)dropStackPos.method_10260(), (class_1799)stack);
                }
            } else {
                List<class_2338> list = ((MultiOreBlock)this.method_11010().method_26204()).getMultiOreBlockPoses(this.method_10997(), this.method_11016());
                if (!list.isEmpty()) {
                    boolean isMultiOreEmpty = true;
                    for (class_2338 blockPos : list) {
                        MultiOreBlockEntity multiOreBlockEntity;
                        class_2586 class_25862;
                        if (!(this.method_10997().method_8320(blockPos).method_26204() instanceof MultiOreBlock) || !((class_25862 = this.method_10997().method_8321(blockPos)) instanceof MultiOreBlockEntity) || (multiOreBlockEntity = (MultiOreBlockEntity)class_25862).getDrillCount() <= 0) continue;
                        isMultiOreEmpty = false;
                        multiOreBlockEntity.decrementDrillCount(dropStackPos);
                        break;
                    }
                    if (isMultiOreEmpty) {
                        ((MultiOreBlock)this.method_11010().method_26204()).breakMultiOre(this.method_10997(), this.method_11016(), null);
                    }
                } else {
                    ((MultiOreBlock)this.method_11010().method_26204()).breakMultiOre(this.method_10997(), this.method_11016(), null);
                }
            }
        }
    }
}

