/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.BaseTrade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_3518;

public record EntityTrades(Map<TradeRarity, List<BaseTrade>> map) {
    public EntityTrades(Map<TradeRarity, List<BaseTrade>> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<TradeRarity, List<BaseTrade>> tradeMap = (Map)class_156.method_656(() -> {
            EnumMap map = new EnumMap(TradeRarity.class);
            Arrays.stream(TradeRarity.values()).forEach(rarity -> map.put((TradeRarity)((Object)((Object)rarity)), new ArrayList()));
            return map;
        });

        private Builder() {
        }

        public void deserialize(TradeRarity rarity, JsonObject object) {
            List<BaseTrade> trades = this.tradeMap.get((Object)rarity);
            if (class_3518.method_15258((JsonObject)object, (String)"replace", (boolean)false)) {
                trades.clear();
            }
            JsonArray tradeArray = class_3518.method_15261((JsonObject)object, (String)"trades");
            for (JsonElement tradeElement : tradeArray) {
                JsonObject tradeObject = tradeElement.getAsJsonObject();
                BaseTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)tradeObject).result().ifPresent(trades::add);
            }
        }

        public EntityTrades build() {
            return new EntityTrades(this.tradeMap);
        }
    }
}

