/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tradecycling.compatibility;

import de.maxhenkel.tradecycling.TradeCyclingMod;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.class_1646;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_3222;

public class VisibleTraders {
    @Nullable
    private static Method regenerateTrades;
    @Nullable
    private static Method sendMerchantOffers;

    public static void forceTradeGeneration(class_1646 villager) {
        if (regenerateTrades == null) {
            return;
        }
        try {
            regenerateTrades.invoke((Object)villager, new Object[0]);
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to regenerate visible traders trades", e);
            regenerateTrades = null;
        }
    }

    public static boolean sendTrades(class_3222 player, class_1915 merchant, int containerId, class_1916 merchantOffers, int level, int villagerXp, boolean showProgressBar, boolean canRestock) {
        if (sendMerchantOffers == null) {
            return false;
        }
        try {
            sendMerchantOffers.invoke((Object)player, merchant, containerId, merchantOffers, level, villagerXp, showProgressBar, canRestock);
            return true;
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to regenerate visible traders trades", e);
            sendMerchantOffers = null;
            return false;
        }
    }

    public static void init(TradeCyclingMod mod) {
        if (!mod.isModLoaded("visibletraders")) {
            return;
        }
        regenerateTrades = VisibleTraders.getRegenerateMethod();
        sendMerchantOffers = VisibleTraders.getSendMerchantOffersMethod();
    }

    private static Method getRegenerateMethod() {
        try {
            Method forceTradeGeneration = class_1646.class.getDeclaredMethod("visibleTraders$forceTradeGeneration", new Class[0]);
            forceTradeGeneration.setAccessible(true);
            return forceTradeGeneration;
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to initialize visible traders integration", e);
            return null;
        }
    }

    private static Method getSendMerchantOffersMethod() {
        try {
            Method sendMerchantOffers = class_3222.class.getDeclaredMethod("visibleTraders$wrapAndSendMerchantOffers", class_1915.class, Integer.TYPE, class_1916.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            sendMerchantOffers.setAccessible(true);
            return sendMerchantOffers;
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to initialize visible traders integration", e);
            return null;
        }
    }
}

