/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.artificers.data;

import com.cleannrooster.artificers.Armors;
import com.cleannrooster.artificers.Items;
import com.cleannrooster.artificers.spells.ArtificersSpells;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_7225;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;

public class ArtificersDataGen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ArtificersSpellGen::new);
        pack.addProvider(ItemTagGenerator::new);
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.generateArmorTags(Armors.entries);
            this.generateWeaponTags(Items.entries);
            List<RPGSeriesDataGen.BowEntry> bowEntries = Items.rangedEntries.stream().map(entry -> new RPGSeriesDataGen.BowEntry(entry.id(), entry.weaponType, entry.lootProperties)).toList();
            this.generateBowTags(bowEntries);
        }
    }

    public static class ArtificersSpellGen
    extends SpellGenerator {
        public ArtificersSpellGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (ArtificersSpells.Entry entry : ArtificersSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }
}

