/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.artificers;

import com.cleannrooster.artificers.Armors;
import com.cleannrooster.artificers.ArtificersAttributes;
import com.cleannrooster.artificers.ArtificersSchools;
import com.cleannrooster.artificers.Entities;
import com.cleannrooster.artificers.Items;
import com.cleannrooster.artificers.Signed;
import com.cleannrooster.artificers.Spells;
import com.cleannrooster.artificers.config.ArtificersConfig;
import com.cleannrooster.artificers.config.Default;
import com.cleannrooster.artificers.config.TweaksConfig;
import com.cleannrooster.artificers.effects.Effects;
import com.cleannrooster.artificers.mixin.EntityAttributeInstanceInvoker;
import com.cleannrooster.artificers.spells.ArtificersCustomImpacts;
import mod.azure.azurelib.rewrite.animation.cache.AzIdentityRegistry;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1792;
import net.tinyconfig.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Artificers
implements ModInitializer {
    public static final String MOD_ID = "artificers";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"artificers");
    public static ConfigManager<TweaksConfig> tweaksConfig;
    public static ConfigManager<ArtificersConfig> itemConfig;

    public void onInitialize() {
        itemConfig.refresh();
        tweaksConfig.refresh();
        Items.registerRanged(((ArtificersConfig)Artificers.itemConfig.value).ranged_weapons);
        Items.registerWeapons(((ArtificersConfig)Artificers.itemConfig.value).melee_weapons);
        Entities.register();
        Effects.register();
        Armors.register(((ArtificersConfig)Artificers.itemConfig.value).armor_sets);
        Spells.registerDeliveries();
        ArtificersSchools.register();
        ArtificersCustomImpacts.registerImpacts();
        ArtificersAttributes.register();
        if (Items.ruby_rifle != null) {
            AzIdentityRegistry.register((class_1792)Items.iron_rifle.item, (class_1792[])new class_1792[]{Items.diamond_rifle.item, Items.netherite_rifle.item, Items.gold_rifle.item, Items.ruby_rifle.item});
        } else {
            AzIdentityRegistry.register((class_1792)Items.iron_rifle.item, (class_1792[])new class_1792[]{Items.diamond_rifle.item, Items.netherite_rifle.item, Items.gold_rifle.item});
        }
        itemConfig.save();
        LOGGER.info("Hello Fabric world!");
    }

    @SafeVarargs
    public static double applyAttributeModifiers(double initial, Signed<class_1324> ... attributes) {
        for (Signed<class_1324> signedAttribute : attributes) {
            if (signedAttribute.value() == null) continue;
            block13: for (class_1322 modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(class_1322.class_1323.field_6328)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        initial += modifier.comp_2449();
                        continue block13;
                    }
                    case NEGATIVE: {
                        initial -= modifier.comp_2449();
                        continue block13;
                    }
                }
                throw new IllegalStateException();
            }
        }
        double result = initial;
        for (Signed<class_1324> signedAttribute : attributes) {
            if (signedAttribute.value() == null) continue;
            block15: for (class_1322 modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(class_1322.class_1323.field_6330)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        result += initial * modifier.comp_2449();
                        continue block15;
                    }
                    case NEGATIVE: {
                        result -= initial * modifier.comp_2449();
                        continue block15;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (Signed<class_1324> signedAttribute : attributes) {
            if (signedAttribute.value() == null) continue;
            block17: for (class_1322 modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(class_1322.class_1323.field_6331)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        result *= 1.0 + modifier.comp_2449();
                        continue block17;
                    }
                    case NEGATIVE: {
                        result *= 1.0 - modifier.comp_2449();
                        continue block17;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (Signed<class_1324> signedAttribute : attributes) {
            if (signedAttribute.value() == null) continue;
            result = ((class_1320)signedAttribute.value().method_6198().comp_349()).method_6165(result);
        }
        return result;
    }

    static {
        itemConfig = new ConfigManager("equipment_v2", (Object)Default.itemConfig).builder().setDirectory(MOD_ID).sanitize(true).build();
        tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory(MOD_ID).sanitize(true).build();
    }
}

