/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.amendments.common.LiquidMixer;
import net.mehvahdjukaar.amendments.common.block.DyeCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9331;

public class LiquidCauldronBlockTile
extends class_2586
implements IExtraModelDataProvider,
ISoftFluidTankProvider {
    public static final ModelDataKey<class_5321<SoftFluid>> FLUID = new ModelDataKey(class_5321.class);
    public static final ModelDataKey<Boolean> GLOWING = new ModelDataKey(Boolean.class);
    private final SoftFluidTank fluidTank;
    private boolean hasGlowInk = false;

    public SoftFluidTank makeTank(class_2680 blockState) {
        return blockState.method_26204() instanceof DyeCauldronBlock ? this.createCauldronDyeTank() : this.createCauldronLiquidTank();
    }

    private boolean canMixPotions() {
        CommonConfigs.MixingMode config = CommonConfigs.POTION_MIXING.get();
        return config == CommonConfigs.MixingMode.ON || config == CommonConfigs.MixingMode.ONLY_BOILING && (Boolean)this.method_11010().method_11654((class_2769)LiquidCauldronBlock.BOILING) != false;
    }

    public LiquidCauldronBlockTile(class_2338 blockPos, class_2680 blockState) {
        super(ModRegistry.LIQUID_CAULDRON_TILE.get(), blockPos, blockState);
        this.fluidTank = this.makeTank(blockState);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(FLUID, (Object)((class_5321)this.fluidTank.getFluid().getHolder().method_40230().get()));
        builder.with(GLOWING, (Object)this.hasGlowInk);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidTank;
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.fluidTank.load(tag, registries);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.fluidTank.refreshTintCache();
            this.requestModelReload();
        }
        this.hasGlowInk = tag.method_10577("glow_ink");
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        this.fluidTank.save(tag, registries);
        if (this.hasGlowInk) {
            tag.method_10556("glow_ink", true);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public void method_5431() {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
        class_2680 state = this.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ModCauldronBlock) {
            ModCauldronBlock cb = (ModCauldronBlock)class_22482;
            state = cb.updateStateOnFluidChange(state, this.field_11863, this.field_11867, this.fluidTank.getFluid());
        }
        if (state != this.method_11010()) {
            this.field_11863.method_8501(this.field_11867, state);
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), state, 2);
        super.method_5431();
    }

    public boolean interactWithPlayerItem(class_1657 player, class_1268 hand, class_1799 stack) {
        if (this.fluidTank.interactWithPlayer(player, hand, this.field_11863, this.field_11867)) {
            this.field_11863.method_33596((class_1297)player, (class_6880)class_5712.field_28733, this.field_11867);
            this.method_5431();
            return true;
        }
        return false;
    }

    public void consumeOneLayer() {
        this.fluidTank.getFluid().shrink(1);
        this.method_5431();
    }

    public SoftFluidTank createCauldronLiquidTank() {
        return new SoftFluidTank(PlatHelper.getPlatform().isFabric() ? 3 : 4){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is(MLBuiltinSoftFluids.WATER)) {
                    return false;
                }
                if (LiquidCauldronBlockTile.this.canMixPotions() && fluidStack.is(MLBuiltinSoftFluids.POTION) && fluidStack.is(this.getFluid().getHolder())) {
                    return this.fluidStack.method_57825((class_9331)MoonlightRegistry.BOTTLE_TYPE.get(), (Object)PotionBottleType.REGULAR) == fluidStack.method_57825((class_9331)MoonlightRegistry.BOTTLE_TYPE.get(), (Object)PotionBottleType.REGULAR);
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack incoming) {
                SoftFluidStack newStack;
                if (LiquidCauldronBlockTile.this.canMixPotions() && incoming.is(MLBuiltinSoftFluids.POTION) && (newStack = LiquidMixer.mixPotions(this.fluidStack, incoming)) != null) {
                    this.setFluid(newStack);
                    this.needsColorRefresh = true;
                }
                super.addFluidOntoExisting(incoming);
            }
        };
    }

    public SoftFluidTank createCauldronDyeTank() {
        return new SoftFluidTank(this, 3){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is(ModRegistry.DYE_SOFT_FLUID) && fluidStack.is(this.getFluid().getHolder())) {
                    return true;
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack fluidStack) {
                SoftFluidStack mixed;
                if (fluidStack.is(ModRegistry.DYE_SOFT_FLUID) && (mixed = LiquidMixer.mixDye(this.fluidStack, fluidStack)) != null) {
                    this.setFluid(mixed);
                    this.needsColorRefresh = true;
                }
                super.addFluidOntoExisting(fluidStack);
            }
        };
    }

    public boolean isGlowing() {
        return this.hasGlowInk;
    }

    public void setGlowing(boolean b) {
        this.hasGlowInk = b;
        this.method_5431();
    }
}

