/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.item;

import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class DyeBottleItem
extends class_1792 {
    protected static final HashBiMap<class_1767, Integer> COLOR_TO_DIFFUSE = Arrays.stream(class_1767.values()).collect(Collectors.toMap(Function.identity(), class_1767::method_7787, (color, color2) -> color2, HashBiMap::create));
    private static final class_9282 DEFAULT_COLOR = new class_9282(DyeBottleItem.getDyeInt(class_1767.field_7952).intValue(), false);
    public static final class_9282 RED_COLOR = new class_9282(DyeBottleItem.getDyeInt(class_1767.field_7964).intValue(), false);

    public DyeBottleItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static SoftFluidStack createFluidStack(class_1767 color, int amount) {
        SoftFluidStack stack = SoftFluidStack.of(ModRegistry.DYE_SOFT_FLUID, (int)amount);
        stack.set(class_9334.field_49644, (Object)new class_9282(DyeBottleItem.getDyeInt(color).intValue(), true));
        return stack;
    }

    public static class_1799 fromFluidStack(SoftFluidStack stack) {
        class_1799 item = new class_1799((class_1935)ModRegistry.DYE_BOTTLE_ITEM.get());
        item.method_57379(class_9334.field_49644, (Object)((class_9282)stack.method_57825(class_9334.field_49644, (Object)DEFAULT_COLOR)));
        return item;
    }

    public static int mixColor(int oldColor, int newColor, int oldAmount, int newAmount) {
        return new RGBColor(oldColor).asHCL().mixWith(new RGBColor(newColor).asHCL(), (float)newAmount / (float)(oldAmount + newAmount)).asRGB().toInt();
    }

    @NotNull
    private static Integer getDyeInt(class_1767 color) {
        return (Integer)COLOR_TO_DIFFUSE.get((Object)color);
    }

    public static class_1767 getClosestDye(SoftFluidStack stack) {
        return DyeBottleItem.getClosestDye(((class_9282)stack.method_57825(class_9334.field_49644, (Object)DEFAULT_COLOR)).comp_2384());
    }

    public static class_1767 getClosestDye(class_1799 stack) {
        return DyeBottleItem.getClosestDye(((class_9282)stack.method_57824(class_9334.field_49644)).comp_2384());
    }

    public static class_1767 getClosestDye(int tintColor) {
        LABColor color = new RGBColor(tintColor).asLAB();
        double minDist = Double.MAX_VALUE;
        class_1767 minColor = null;
        for (class_1767 dyeColor : class_1767.values()) {
            LABColor c2 = new RGBColor(DyeBottleItem.getDyeInt(dyeColor).intValue()).asLAB();
            double dist = c2.distTo((BaseColor)color);
            if (!(dist < minDist)) continue;
            minDist = dist;
            minColor = dyeColor;
        }
        return minColor;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> list, class_1836 tooltipFlag) {
        super.method_7851(stack, context, list, tooltipFlag);
        class_9282 color = (class_9282)stack.method_57824(class_9334.field_49644);
        if (color == null) {
            return;
        }
        class_1767 dye = (class_1767)COLOR_TO_DIFFUSE.inverse().get((Object)color.comp_2384());
        if (dye != null) {
            list.add((class_2561)class_2561.method_43471((String)("item.amendments.dye_bottle." + dye.method_7792())).method_27692(class_124.field_1080));
        } else if (tooltipFlag.method_8035()) {
            list.add((class_2561)class_2561.method_43469((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", color.comp_2384())}).method_27692(class_124.field_1080));
        } else {
            list.add((class_2561)class_2561.method_43471((String)"item.dyed").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        }
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 interactionTarget, class_1268 usedHand) {
        if (interactionTarget instanceof class_1472) {
            class_1472 sheep = (class_1472)interactionTarget;
            class_1767 dye = DyeBottleItem.getClosestDye(stack);
            if (sheep.method_5805() && !sheep.method_6629() && sheep.method_6633() != dye) {
                sheep.method_37908().method_43129(player, (class_1297)sheep, class_3417.field_28391, class_3419.field_15248, 1.0f, 1.0f);
                if (!player.method_37908().field_9236) {
                    sheep.method_6631(dye);
                    stack.method_7934(1);
                }
                return class_1269.method_29236((boolean)player.method_37908().field_9236);
            }
        }
        return class_1269.field_5811;
    }
}

