/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.content;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchools;
import net.wizards.content.WizardsSounds;
import org.jetbrains.annotations.Nullable;

public class WizardSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    private static final String PRIMARY_GROUP = "primary";
    private static final float BASIC_PROJECTILE_RANGE = 48.0f;
    public static Entry arcane_bolt = WizardSpells.add(WizardSpells.arcane_bolt());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        return spell;
    }

    private static ParticleBatch arcaneCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.ARCANE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static Spell.Impact damage(float coefficient, float knockback) {
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = Spell.Impact.Action.Type.DAMAGE;
        impact.action.damage = new Spell.Impact.Action.Damage();
        impact.action.damage.spell_power_coefficient = coefficient;
        impact.action.damage.knockback = knockback;
        return impact;
    }

    private static void configureArcaneRuneCost(Spell spell) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.item = new Spell.Cost.Item();
        spell.cost.item.id = "runes:arcane_stone";
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = duration;
    }

    private static Entry arcane_bolt() {
        class_2960 id = class_2960.method_60655((String)"wizards", (String)"arcane_bolt");
        Spell spell = WizardSpells.activeSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.group = PRIMARY_GROUP;
        spell.tier = 0;
        spell.range = 48.0f;
        spell.active.cast.duration = 1.0f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_ARCANE_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.arcaneCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_projectile_release";
        spell.release.sound = new Sound(WizardsSounds.ARCANE_MISSILE_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 1.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 10;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.ARCANE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.05f, 0.1f, 0.0f, 0.0f)};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/arcane_bolt";
        projectile.client_data.model.scale = 0.5f;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = WizardSpells.damage(0.7f, 0.6f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.ARCANE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.2f, 0.7f, 0.0f, 0.0f)};
        damage.sound = new Sound(WizardsSounds.ARCANE_MISSILE_IMPACT.id());
        spell.impacts = List.of(damage);
        WizardSpells.configureArcaneRuneCost(spell);
        return new Entry(id, spell, "", "", null);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

