/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2960;

public record SearchTerms(List<Term> terms) {
    public static SearchTerms parse(String str) {
        if (str.isEmpty()) {
            return new SearchTerms(List.of());
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String s : str.toLowerCase().split(" +")) {
            terms.add(Term.of(s));
        }
        return new SearchTerms((List<Term>)ImmutableList.copyOf(terms));
    }

    public boolean match(class_2960 id, String displayName, Predicate<class_2960> tagMatcher) {
        return this.terms.stream().allMatch(term -> {
            if (term.value.isEmpty()) {
                return true;
            }
            return switch (term.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> id.method_12836().contains(term.value);
                case 2 -> tagMatcher.test(id);
                case 0 -> displayName.toLowerCase().contains(term.value);
            };
        });
    }

    public record Term(TermType type, String value) {
        public static Term of(String s) {
            if (s.isEmpty()) {
                return new Term(TermType.SIMPLE, "");
            }
            return switch (s.charAt(0)) {
                case '@' -> new Term(TermType.MOD, s.substring(1));
                case '#' -> new Term(TermType.TAG, s.substring(1));
                default -> new Term(TermType.SIMPLE, s);
            };
        }
    }

    private static enum TermType {
        SIMPLE,
        MOD,
        TAG;

    }
}

