/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.SNBTEOFException;
import dev.ftb.mods.ftblibrary.snbt.SNBTSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBTUtils;
import dev.ftb.mods.ftblibrary.snbt.SpecialTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

class SNBTParser {
    private final char[] buffer;
    private int position;

    private SNBTParser(List<String> lines) {
        StringBuilder bufferBuilder = new StringBuilder();
        for (String line : lines) {
            String tline = line.trim();
            if (!tline.startsWith("//") && !tline.startsWith("#")) {
                bufferBuilder.append(line);
            }
            bufferBuilder.append('\n');
        }
        this.buffer = bufferBuilder.toString().toCharArray();
        if (this.buffer.length < 2) {
            throw new SNBTSyntaxException("File has to have at least two characters!");
        }
        this.position = 0;
    }

    static SNBTCompoundTag read(List<String> lines) {
        SNBTParser parser = new SNBTParser(lines);
        return (SNBTCompoundTag)SpecialTag.unwrap(parser.readTag(parser.nextNS()));
    }

    private String posString() {
        return this.posString(this.position);
    }

    private String posString(int p) {
        if (p >= this.buffer.length) {
            return "EOF";
        }
        int row = 0;
        int col = 0;
        for (int i = 0; i < p; ++i) {
            if (this.buffer[i] == '\n') {
                ++row;
                col = 0;
                continue;
            }
            ++col;
        }
        return row + 1 + ":" + (col + 1);
    }

    private char next() {
        if (this.position >= this.buffer.length) {
            throw new SNBTEOFException();
        }
        char c = this.buffer[this.position];
        ++this.position;
        return c;
    }

    private char nextNS() {
        char c;
        while ((c = this.next()) <= ' ') {
        }
        return c;
    }

    private class_2520 readTag(char first) {
        String s;
        switch (first) {
            case '{': {
                return this.readCompound();
            }
            case '[': {
                return this.readCollection();
            }
            case '\"': {
                return class_2519.method_23256((String)this.readQuotedString('\"'));
            }
            case '\'': {
                return class_2519.method_23256((String)this.readQuotedString('\''));
            }
        }
        return switch (s = this.readWordString(first)) {
            case "true" -> SpecialTag.TRUE;
            case "false" -> SpecialTag.FALSE;
            case "null", "end", "END" -> class_2491.field_21033;
            case "Infinity", "Infinityd", "+Infinity", "+Infinityd", "\u221e", "\u221ed", "+\u221e", "+\u221ed" -> SpecialTag.POS_INFINITY_D;
            case "-Infinity", "-Infinityd", "-\u221e", "-\u221ed" -> SpecialTag.NEG_INFINITY_D;
            case "NaN", "NaNd" -> SpecialTag.NAN_D;
            case "Infinityf", "+Infinityf", "\u221ef", "+\u221ef" -> SpecialTag.POS_INFINITY_F;
            case "-Infinityf", "-\u221ef" -> SpecialTag.NEG_INFINITY_F;
            case "NaNf" -> SpecialTag.NAN_F;
            default -> {
                switch (SNBTUtils.getNumberType(s)) {
                    case 1: {
                        yield class_2481.method_23233((byte)Byte.parseByte(s.substring(0, s.length() - 1)));
                    }
                    case 2: {
                        yield class_2516.method_23254((short)Short.parseShort(s.substring(0, s.length() - 1)));
                    }
                    case 3: {
                        yield class_2497.method_23247((int)Integer.parseInt(s));
                    }
                    case 4: {
                        yield class_2503.method_23251((long)Long.parseLong(s.substring(0, s.length() - 1)));
                    }
                    case 5: {
                        yield class_2494.method_23244((float)Float.parseFloat(s.substring(0, s.length() - 1)));
                    }
                    case 6: {
                        yield class_2489.method_23241((double)Double.parseDouble(s.substring(0, s.length() - 1)));
                    }
                    case -6: {
                        yield class_2489.method_23241((double)Double.parseDouble(s));
                    }
                }
                yield class_2519.method_23256((String)s);
            }
        };
    }

    private SNBTCompoundTag readCompound() {
        char n;
        SNBTCompoundTag tag = new SNBTCompoundTag();
        while (true) {
            char c;
            if ((c = this.nextNS()) == '}') {
                return tag;
            }
            if (c == ',' || c == '\n') continue;
            String key = c == '\"' ? this.readQuotedString('\"') : (c == '\'' ? this.readQuotedString('\'') : this.readWordString(c));
            n = this.nextNS();
            if (n != ':' && n != '=') break;
            class_2520 t = this.readTag(this.nextNS());
            if (t == SpecialTag.TRUE) {
                tag.getOrCreateProperties((String)key).valueType = 2;
            } else if (t == SpecialTag.FALSE) {
                tag.getOrCreateProperties((String)key).valueType = 1;
            }
            tag.method_10566(key, SpecialTag.unwrap(t));
        }
        throw new SNBTSyntaxException("Expected ':', got '" + n + "' @ " + this.posString());
    }

    private class_2483<?> readCollection() {
        int prevPos = this.position;
        char next1 = this.nextNS();
        char next2 = this.nextNS();
        if (next2 == ';' && (next1 == 'I' || next1 == 'i' || next1 == 'L' || next1 == 'l' || next1 == 'B' || next1 == 'b')) {
            return this.readArray(prevPos, next1);
        }
        this.position = prevPos;
        return this.readList();
    }

    private class_2499 readList() {
        class_2499 tag = new class_2499();
        while (true) {
            int prevPos = this.position;
            char c = this.nextNS();
            if (c == ']') {
                return tag;
            }
            if (c == ',') continue;
            class_2520 t = SpecialTag.unwrap(this.readTag(c));
            try {
                tag.add((Object)t);
            }
            catch (UnsupportedOperationException ex) {
                throw new SNBTSyntaxException("Unexpected tag '" + String.valueOf(t) + "' in list @ " + this.posString(prevPos) + " - can't mix two different tag types in a list!");
            }
        }
    }

    private class_2483<?> readArray(int pos, char type) {
        class_2520 tag;
        ArrayList<Integer> intList = new ArrayList<Integer>();
        ArrayList<Long> longList = new ArrayList<Long>();
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        type = Character.toLowerCase(type);
        while (true) {
            char c;
            if ((c = this.nextNS()) == ']') {
                return switch (type) {
                    case 'i' -> new class_2495(intList);
                    case 'l' -> new class_2501(longList);
                    case 'b' -> new class_2479(byteList);
                    default -> throw new SNBTSyntaxException("Unknown array type: " + type + " @ " + this.posString(pos));
                };
            }
            if (c == ',') continue;
            tag = SpecialTag.unwrap(this.readTag(c));
            if (!(tag instanceof class_2514)) break;
            class_2514 numericTag = (class_2514)tag;
            switch (type) {
                case 'i': {
                    intList.add(numericTag.method_10701());
                    break;
                }
                case 'l': {
                    longList.add(numericTag.method_10699());
                    break;
                }
                case 'b': {
                    byteList.add(numericTag.method_10698());
                }
            }
        }
        throw new SNBTSyntaxException("Unexpected tag '" + String.valueOf(tag) + "' in list @ " + this.posString() + " - expected a numeric tag!");
    }

    private String readWordString(char first) {
        char c;
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        while (SNBTUtils.isSimpleCharacter(c = this.next())) {
            sb.append(c);
        }
        --this.position;
        return sb.toString();
    }

    private String readQuotedString(char stop) {
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        while (true) {
            char c;
            if ((c = this.next()) == '\n') {
                throw new SNBTSyntaxException("New line without closing string with " + stop + " @ " + this.posString(this.position - 1) + "!");
            }
            if (escape) {
                escape = false;
                if (SNBTUtils.REVERSE_ESCAPE_CHARS[c] == '\u0000') continue;
                sb.append(SNBTUtils.REVERSE_ESCAPE_CHARS[c]);
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == stop) {
                return sb.toString();
            }
            sb.append(c);
        }
    }
}

