/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.icon.CustomIconItem;
import dev.ftb.mods.ftblibrary.icon.IResourceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.LazyIcon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_811;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ItemIcon
extends Icon
implements IResourceIcon {
    private final class_1799 stack;

    private ItemIcon(class_1799 is) {
        this.stack = is;
    }

    public static Icon getItemIcon(class_1799 stack) {
        if (stack.method_7960()) {
            return ItemIcon.empty();
        }
        if (stack.method_7909() instanceof CustomIconItem) {
            return ((CustomIconItem)stack.method_7909()).getCustomIcon(stack);
        }
        return new ItemIcon(stack);
    }

    public static Icon getItemIcon(class_1792 item) {
        return item == class_1802.field_8162 ? ItemIcon.empty() : ItemIcon.getItemIcon(item.method_7854());
    }

    public static Icon getItemIcon(final String lazyStackString) {
        if (lazyStackString.isEmpty()) {
            return ItemIcon.empty();
        }
        return new LazyIcon(() -> {
            String[] s = lazyStackString.split(" ", 4);
            class_1799 stack = ((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)s[0]))).method_7854();
            if (s.length >= 2 && !s[1].equals("1")) {
                stack.method_7939(Integer.parseInt(s[1]));
            }
            if (s.length >= 3 && !s[2].equals("0")) {
                stack.method_7974(Integer.parseInt(s[2]));
            }
            if (s.length >= 4 && !s[3].equals("null")) {
                try {
                    class_9323.field_50234.parse((DynamicOps)class_2509.field_11560, (Object)class_2522.method_10718((String)s[3])).resultOrPartial(err -> FTBLibrary.LOGGER.error("can't parse data component map for {}: {}", (Object)s[3], err)).ifPresent(arg_0 -> ((class_1799)stack).method_57365(arg_0));
                }
                catch (CommandSyntaxException ex) {
                    FTBLibrary.LOGGER.error("can't parse data component tag for item icon: {} ({})", (Object)lazyStackString, (Object)ex.getMessage());
                }
            }
            if (stack.method_7960()) {
                class_1799 fallback = new class_1799((class_1935)class_1802.field_8077);
                fallback.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)lazyStackString));
                return ItemIcon.getItemIcon(fallback);
            }
            return ItemIcon.getItemIcon(stack);
        }){

            @Override
            public String toString() {
                return "item:" + lazyStackString;
            }
        };
    }

    @Environment(value=EnvType.CLIENT)
    public static void drawItem3D(class_332 graphics, class_1799 stack) {
        class_310.method_1551().method_1480().method_23178(stack, class_811.field_4319, 240, class_4608.field_21444, graphics.method_51448(), (class_4597)class_310.method_1551().method_22940().method_23000(), (class_1937)class_310.method_1551().field_1687, 0);
    }

    public class_1799 getStack() {
        return this.stack;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw(class_332 graphics, int x, int y, int w, int h) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22904((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 0.0);
        if (w != 16 || h != 16) {
            float s = (float)Math.min(w, h) / 16.0f;
            poseStack.method_22905(s, s, s);
        }
        GuiHelper.drawItem(graphics, this.getStack(), 0, true, null);
        poseStack.method_22909();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawStatic(class_332 graphics, int x, int y, int w, int h) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22904((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 0.0);
        if (w != 16 || h != 16) {
            float s = (float)Math.min(w, h) / 16.0f;
            poseStack.method_22905(s, s, s);
        }
        GuiHelper.drawItem(graphics, this.getStack(), 0, false, null);
        poseStack.method_22909();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw3D(class_332 graphics) {
        ItemIcon.drawItem3D(graphics, this.getStack());
    }

    public String toString() {
        class_1799 stack = this.getStack();
        StringBuilder builder = new StringBuilder("item:");
        builder.append(RegistrarManager.getId((Object)stack.method_7909(), (class_5321)class_7924.field_41197));
        int count = stack.method_7947();
        int damage = stack.method_7919();
        class_2520 nbt = class_9323.field_50234.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack.method_57353()).result().orElse(null);
        if (count > 1 || damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(damage);
        }
        if (nbt != null) {
            builder.append(' ');
            builder.append(nbt);
        }
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return class_1799.method_57355((class_1799)this.getStack());
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ItemIcon && class_1799.method_7973((class_1799)this.getStack(), (class_1799)((ItemIcon)o).getStack());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getStack();
    }

    @Override
    public class_2960 getResourceLocation() {
        return class_7923.field_41178.method_10221((Object)this.stack.method_7909());
    }
}

