/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceIcon
extends Icon {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceIcon.class);
    private static final HashMap<UUID, FaceIcon> CACHE = new HashMap();
    public final GameProfile profile;
    public Icon skin;
    public Icon head;
    public Icon hat;

    private FaceIcon(GameProfile p) {
        this.profile = p;
        this.skin = new ImageIcon(class_1068.method_4648((UUID)this.profile.getId()).comp_1626());
        this.head = this.skin.withUV(8.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f);
        this.hat = Icon.empty();
        class_310.method_1551().method_1582().method_52863(this.profile).whenComplete((playerSkin, throwable) -> {
            if (playerSkin != null) {
                class_2960 texture = playerSkin.comp_1626();
                this.skin = new ImageIcon(texture);
                this.head = this.skin.withUV(8.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f);
                this.hat = this.skin.withUV(40.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f);
            } else if (throwable != null) {
                LOGGER.warn("Failed to load skin for {}: {} ", (Object)this.profile.getName(), (Object)throwable.getMessage());
            } else {
                LOGGER.warn("Failed to load skin for {} ?", (Object)this.profile.getName());
            }
        });
    }

    public static FaceIcon getFace(GameProfile profile) {
        FaceIcon icon = CACHE.get(profile.getId());
        if (icon == null) {
            icon = new FaceIcon(profile);
            CACHE.put(profile.getId(), icon);
        }
        return icon;
    }

    @Override
    public void draw(class_332 poseStack, int x, int y, int w, int h) {
        this.head.draw(poseStack, x, y, w, h);
        this.hat.draw(poseStack, x, y, w, h);
    }
}

