/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.google.common.collect.Lists;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.apace100.origins.screen.OriginDisplayScreen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class ViewOriginScreen
extends OriginDisplayScreen {
    private final ArrayList<class_3545<OriginLayer, Origin>> originLayers;
    private class_4185 chooseOriginButton;
    private int currentLayerIndex = 0;

    public ViewOriginScreen() {
        super((class_2561)class_2561.method_43471((String)"origins.screen.view_origin"), false);
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            this.originLayers = new ArrayList(5);
            return;
        }
        Map<OriginLayer, Origin> origins = ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getOrigins();
        this.originLayers = new ArrayList(origins.size());
        origins.forEach((arg_0, arg_1) -> this.lambda$new$0((class_1657)player, arg_0, arg_1));
        this.originLayers.sort(Comparator.comparing(class_3545::method_15442));
        if (this.originLayers.isEmpty()) {
            this.showOrigin(null, null, false);
        } else {
            class_3545<OriginLayer, Origin> currentOriginAndLayer = this.originLayers.get(this.currentLayerIndex);
            this.showOrigin((Origin)currentOriginAndLayer.method_15441(), (OriginLayer)currentOriginAndLayer.method_15442(), false);
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        class_310 client = class_310.method_1551();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"origins.gui.close"), button -> client.method_1507(null)).method_46434(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20).method_46431());
        if (this.originLayers.isEmpty() || !OriginsClient.isServerRunningOrigins) {
            return;
        }
        this.chooseOriginButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"origins.gui.choose"), button -> client.method_1507((class_437)new ChooseOriginScreen(Lists.newArrayList((Object[])new OriginLayer[]{this.getCurrentLayer()}), 0, false))).method_46434(this.guiLeft + 88 - 50, this.guiTop + 182 - 40, 100, 20).method_46431();
        this.method_37063((class_364)this.chooseOriginButton);
        class_746 player = client.field_1724;
        this.chooseOriginButton.field_22764 = this.getCurrentOrigin() == Origin.EMPTY && this.getCurrentLayer().getOriginOptionCount((class_1657)player) > 0;
        this.chooseOriginButton.field_22763 = this.chooseOriginButton.field_22764;
        if (this.originLayers.size() <= 1) {
            return;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"<"), arg_0 -> this.lambda$init$3((class_1657)player, arg_0)).method_46434(this.guiLeft - 40, this.field_22790 / 2 - 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)">"), arg_0 -> this.lambda$init$4((class_1657)player, arg_0)).method_46434(this.guiLeft + 176 + 20, this.field_22790 / 2 - 10, 20, 20).method_46431());
    }

    @Override
    public OriginLayer getCurrentLayer() {
        return (OriginLayer)this.originLayers.get(this.currentLayerIndex).method_15442();
    }

    @Override
    public Origin getCurrentOrigin() {
        return (Origin)this.originLayers.get(this.currentLayerIndex).method_15441();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (!this.originLayers.isEmpty()) {
            return;
        }
        String translationKey = "origins.gui.view_origin." + (OriginsClient.isServerRunningOrigins ? "empty" : "not_installed");
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)translationKey), this.field_22789 / 2, this.guiTop + 48, 0xFFFFFF);
    }

    @Override
    protected class_2561 getTitleText() {
        return super.getCurrentLayer().getViewOriginTitle();
    }

    private /* synthetic */ void lambda$init$4(class_1657 player, class_4185 button) {
        this.currentLayerIndex = (this.currentLayerIndex + 1) % this.originLayers.size();
        this.showOrigin(this.getCurrentOrigin(), this.getCurrentLayer(), false);
        this.chooseOriginButton.field_22764 = this.getCurrentOrigin() == Origin.EMPTY && this.getCurrentLayer().getOriginOptionCount(player) > 0;
        this.chooseOriginButton.field_22763 = this.chooseOriginButton.field_22764;
    }

    private /* synthetic */ void lambda$init$3(class_1657 player, class_4185 button) {
        this.currentLayerIndex = (this.currentLayerIndex - 1 + this.originLayers.size()) % this.originLayers.size();
        this.showOrigin(this.getCurrentOrigin(), this.getCurrentLayer(), false);
        this.chooseOriginButton.field_22764 = this.getCurrentOrigin() == Origin.EMPTY && this.getCurrentLayer().getOriginOptionCount(player) > 0;
        this.chooseOriginButton.field_22763 = this.chooseOriginButton.field_22764;
    }

    private /* synthetic */ void lambda$new$0(class_1657 player, OriginLayer layer, Origin origin) {
        class_1799 iconStack = origin.getDisplayItem();
        if (iconStack.method_31574(class_1802.field_8575) && !iconStack.method_57826(class_9334.field_49617)) {
            iconStack.method_57379(class_9334.field_49617, (Object)new class_9296(player.method_7334()));
        }
        if (!(layer.isHidden() || origin == Origin.EMPTY && layer.getOriginOptionCount(player) <= 0)) {
            this.originLayers.add((class_3545<OriginLayer, Origin>)new class_3545((Object)layer, (Object)origin));
        }
    }
}

