/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.apace100.apoli.power.PowerManager;
import io.github.apace100.calio.CalioServer;
import io.github.apace100.calio.data.IdentifiableMultiJsonDataLoader;
import io.github.apace100.calio.data.MultiJsonDataContainer;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.networking.packet.s2c.SyncOriginsS2CPacket;
import io.github.apace100.origins.origin.Origin;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class OriginManager
extends IdentifiableMultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    public static final Set<class_2960> DEPENDENCIES = (Set)class_156.method_654(new HashSet(), set -> set.add(PowerManager.ID));
    public static final class_2960 ID = Origins.identifier("origins");
    private static final Object2ObjectOpenHashMap<class_2960, Origin> ORIGINS_BY_ID = new Object2ObjectOpenHashMap();
    private static final ObjectOpenHashSet<class_2960> DISABLED_ORIGINS = new ObjectOpenHashSet();
    private static final Object2ObjectOpenHashMap<class_2960, Integer> LOADING_PRIORITIES = new Object2ObjectOpenHashMap();
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public OriginManager() {
        super(GSON, "origins", class_3264.field_14190);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.addPhaseOrdering(PowerManager.ID, ID);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(ID, (player, joined) -> OriginManager.send(player));
    }

    protected void apply(MultiJsonDataContainer prepared, class_3300 manager, class_3695 profiler) {
        Origins.LOGGER.info("Reading origins from data packs...");
        class_5455 dynamicRegistries = CalioServer.getDynamicRegistries().orElse(null);
        OriginManager.startBuilding();
        if (dynamicRegistries == null) {
            Origins.LOGGER.error("Can't read origins from data packs without access to dynamic registries!");
            OriginManager.endBuilding();
            return;
        }
        AtomicBoolean hasConfigChanged = new AtomicBoolean(false);
        prepared.forEach((packName, id, jsonElement) -> {
            try {
                SerializableData.CURRENT_NAMESPACE = id.method_12836();
                SerializableData.CURRENT_PATH = id.method_12832();
                if (!(jsonElement instanceof JsonObject)) {
                    throw new JsonSyntaxException("Not a JSON object: " + String.valueOf(jsonElement));
                }
                JsonObject jsonObject = (JsonObject)jsonElement;
                jsonObject.addProperty("id", id.toString());
                Origin origin = (Origin)Origin.DATA_TYPE.read((DynamicOps)dynamicRegistries.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)jsonObject).getOrThrow();
                int prevLoadingPriority = (Integer)LOADING_PRIORITIES.getOrDefault((Object)id, (Object)0);
                int currLoadingPriority = class_3518.method_15282((JsonObject)jsonObject, (String)"loading_priority", (int)0);
                if (!OriginManager.contains(id)) {
                    origin.validate();
                    OriginManager.register(id, origin);
                    LOADING_PRIORITIES.put((Object)id, (Object)currLoadingPriority);
                } else if (prevLoadingPriority < currLoadingPriority) {
                    Origins.LOGGER.warn("Overriding origin \"{}\" (with prev. loading priority of {}) with a higher loading priority of {} from data pack [{}]!", (Object)id, (Object)prevLoadingPriority, (Object)currLoadingPriority, (Object)packName);
                    origin.validate();
                    OriginManager.update(id, origin);
                    LOADING_PRIORITIES.put((Object)id, (Object)currLoadingPriority);
                }
                origin = OriginManager.get(id);
                hasConfigChanged.set(hasConfigChanged.get() | Origins.config.addToConfig(origin));
                if (Origins.config.isOriginDisabled(id)) {
                    OriginManager.disable(id);
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading origin \"{}\": {}", (Object)id, (Object)e.getMessage());
            }
        });
        SerializableData.CURRENT_NAMESPACE = null;
        SerializableData.CURRENT_PATH = null;
        Origins.LOGGER.info("Finished reading origins from data packs. Registry contains {} origins.", (Object)OriginManager.size());
        OriginManager.endBuilding();
        if (hasConfigChanged.get()) {
            Origins.serializeConfig();
        }
    }

    public void onReject(String packName, class_2960 resourceId) {
        if (!OriginManager.contains(resourceId)) {
            OriginManager.disable(resourceId);
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return DEPENDENCIES;
    }

    public static Set<Map.Entry<class_2960, Origin>> entrySet() {
        return new ObjectOpenHashSet((ObjectCollection)ORIGINS_BY_ID.object2ObjectEntrySet());
    }

    public static Set<class_2960> keySet() {
        return new ObjectOpenHashSet((ObjectCollection)ORIGINS_BY_ID.keySet());
    }

    public static Collection<Origin> values() {
        return new ObjectOpenHashSet(ORIGINS_BY_ID.values());
    }

    public static DataResult<Origin> getResult(class_2960 id) {
        return OriginManager.contains(id) ? DataResult.success((Object)((Origin)ORIGINS_BY_ID.get((Object)id))) : DataResult.error(() -> "Could not get origin from ID \"" + String.valueOf(id) + "\", as it was not registered!");
    }

    public static Optional<Origin> getOptional(class_2960 id) {
        return OriginManager.getResult(id).result();
    }

    @Nullable
    public static Origin getNullable(class_2960 id) {
        return (Origin)ORIGINS_BY_ID.get((Object)id);
    }

    public static Origin get(class_2960 id) {
        return (Origin)OriginManager.getResult(id).getOrThrow();
    }

    public static boolean contains(Origin origin) {
        return OriginManager.contains(origin.getId());
    }

    public static boolean contains(class_2960 id) {
        return ORIGINS_BY_ID.containsKey((Object)id);
    }

    public static int size() {
        return ORIGINS_BY_ID.size();
    }

    private static void startBuilding() {
        LOADING_PRIORITIES.clear();
        ORIGINS_BY_ID.clear();
        DISABLED_ORIGINS.clear();
    }

    private static void endBuilding() {
        LOADING_PRIORITIES.clear();
        ORIGINS_BY_ID.put((Object)Origin.EMPTY.getId(), (Object)Origin.EMPTY);
        ORIGINS_BY_ID.trim();
        DISABLED_ORIGINS.trim();
    }

    private static Origin register(class_2960 id, Origin origin) {
        if (OriginManager.contains(id)) {
            throw new IllegalArgumentException("Tried to register duplicate origin with ID \"" + String.valueOf(id) + "\"!");
        }
        DISABLED_ORIGINS.remove((Object)id);
        ORIGINS_BY_ID.put((Object)id, (Object)origin);
        return origin;
    }

    private static Origin remove(class_2960 id) {
        return (Origin)ORIGINS_BY_ID.remove((Object)id);
    }

    private static Origin update(class_2960 id, Origin origin) {
        OriginManager.remove(id);
        return OriginManager.register(id, origin);
    }

    public static boolean isDisabled(class_2960 id) {
        return DISABLED_ORIGINS.contains((Object)id);
    }

    public static void disable(class_2960 id) {
        OriginManager.remove(id);
        DISABLED_ORIGINS.add((Object)id);
    }

    public static void send(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncOriginsS2CPacket((Map<class_2960, Origin>)ORIGINS_BY_ID));
    }

    @Environment(value=EnvType.CLIENT)
    public static void receive(SyncOriginsS2CPacket packet, ClientPlayNetworking.Context context) {
        OriginManager.startBuilding();
        packet.originsById().entrySet().stream().peek(e -> ((Origin)e.getValue()).validate()).forEach(e -> OriginManager.update((class_2960)e.getKey(), (Origin)e.getValue()));
        OriginManager.endBuilding();
    }
}

