/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.ImmutableList;
import io.github.apace100.apoli.condition.EntityCondition;
import io.github.apace100.apoli.util.TextUtil;
import io.github.apace100.calio.data.CompoundSerializableDataType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.data.OriginsDataTypes;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginManager;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OriginLayer
implements Comparable<OriginLayer> {
    public static final CompoundSerializableDataType<OriginLayer> DATA_TYPE = SerializableDataType.compound((SerializableData)new SerializableData().add("id", SerializableDataTypes.IDENTIFIER).addSupplied("order", SerializableDataTypes.INT, OriginLayerManager::size).add("origins", OriginsDataTypes.ORIGINS_OR_CONDITIONED_ORIGINS).add("replace_origins", SerializableDataTypes.BOOLEAN, (Object)false).add("replace", SerializableDataTypes.BOOLEAN, (Object)false).add("enabled", SerializableDataTypes.BOOLEAN, (Object)true).add("name", SerializableDataTypes.TEXT, null).add("gui_title", OriginsDataTypes.GUI_TITLE, null).add("missing_name", SerializableDataTypes.TEXT, null).add("missing_description", SerializableDataTypes.TEXT, null).add("allow_random", SerializableDataTypes.BOOLEAN, (Object)false).add("allow_random_unchoosable", SerializableDataTypes.BOOLEAN, (Object)false).add("exclude_random", SerializableDataTypes.IDENTIFIERS, new LinkedList()).add("replace_exclude_random", SerializableDataTypes.BOOLEAN, (Object)false).add("default_origin", SerializableDataTypes.IDENTIFIER, null).add("auto_choose", SerializableDataTypes.BOOLEAN, (Object)false).add("hidden", SerializableDataTypes.BOOLEAN, (Object)false), data -> new OriginLayer((class_2960)data.get("id"), (Integer)data.get("order"), (Collection)data.get("origins"), (Boolean)data.get("replace_origins"), (Boolean)data.get("replace"), (Boolean)data.get("enabled"), (class_2561)data.get("name"), (GuiTitle)data.get("gui_title"), (class_2561)data.get("missing_name"), (class_2561)data.get("missing_description"), (Boolean)data.get("allow_random"), (Boolean)data.get("allow_random_unchoosable"), (Collection)data.get("exclude_random"), (Boolean)data.get("replace_exclude_random"), (class_2960)data.get("default_origin"), (Boolean)data.get("auto_choose"), (Boolean)data.get("hidden")), (layer, serializableData) -> serializableData.instance().set("id", (Object)layer.getId()).set("order", (Object)layer.getOrder()).set("origins", layer.getConditionedOrigins()).set("replace_origins", (Object)layer.shouldReplaceOrigins()).set("replace", (Object)layer.shouldReplace()).set("enabled", (Object)layer.isEnabled()).set("name", (Object)layer.getName()).set("gui_title", (Object)layer.getGuiTitle()).set("missing_name", (Object)layer.getMissingName()).set("missing_description", (Object)layer.getMissingDescription()).set("allow_random", (Object)layer.isRandomAllowed()).set("allow_random_unchoosable", (Object)layer.isUnchoosableRandomAllowed()).set("exclude_random", layer.getOriginsExcludedFromRandom()).set("replace_exclude_random", (Object)layer.shouldReplaceExcludedOriginsFromRandom()).set("default_origin", (Object)layer.getDefaultOrigin()).set("auto_choose", (Object)layer.shouldAutoChoose()).set("hidden", (Object)layer.isHidden()));
    private final class_2960 id;
    private final int order;
    private final Set<ConditionedOrigin> origins;
    private final boolean replaceOrigins;
    private final boolean replace;
    private final boolean enabled;
    private final class_2561 name;
    private final GuiTitle guiTitle;
    @Nullable
    private final class_2561 missingName;
    @Nullable
    private final class_2561 missingDescription;
    private final boolean randomAllowed;
    private final boolean unchoosableRandomAllowed;
    private final Set<class_2960> originsExcludedFromRandom;
    private final boolean replaceOriginsExcludedFromRandom;
    @Nullable
    private final class_2960 defaultOrigin;
    private final boolean autoChoose;
    private final boolean hidden;

    protected OriginLayer(class_2960 id, int order, Collection<ConditionedOrigin> origins, boolean replaceOrigins, boolean replace, boolean enabled, @Nullable class_2561 name, GuiTitle guiTitle, @Nullable class_2561 missingName, @Nullable class_2561 missingDescription, boolean randomAllowed, boolean unchoosableRandomAllowed, Collection<class_2960> originsExcludedFromRandom, boolean replaceOriginsExcludedFromRandom, @Nullable class_2960 defaultOrigin, boolean autoChoose, boolean hidden) {
        this.id = id;
        String baseTranslationKey = class_156.method_646((String)"layer", (class_2960)id);
        this.order = order;
        this.origins = new ObjectLinkedOpenHashSet(origins);
        this.replaceOrigins = replaceOrigins;
        this.replace = replace;
        this.enabled = enabled;
        this.name = TextUtil.forceTranslatable((String)(baseTranslationKey + ".name"), Optional.ofNullable(name));
        if (guiTitle == null) {
            class_5250 viewOriginText = class_2561.method_43469((String)"origins.gui.view_origin.title", (Object[])new Object[]{this.name});
            class_5250 chooseOriginText = class_2561.method_43469((String)"origins.gui.choose_origin.title", (Object[])new Object[]{this.name});
            this.guiTitle = new GuiTitle((class_2561)viewOriginText, (class_2561)chooseOriginText);
        } else {
            class_2561 viewOriginText = TextUtil.forceTranslatable((String)(baseTranslationKey + ".view_origin.name"), Optional.ofNullable(guiTitle.viewOrigin()));
            class_2561 chooseOriginText = TextUtil.forceTranslatable((String)(baseTranslationKey + ".choose_origin.name"), Optional.ofNullable(guiTitle.chooseOrigin()));
            this.guiTitle = new GuiTitle(viewOriginText, chooseOriginText);
        }
        this.missingName = missingName;
        this.missingDescription = missingDescription;
        this.randomAllowed = randomAllowed;
        this.unchoosableRandomAllowed = unchoosableRandomAllowed;
        this.originsExcludedFromRandom = new ObjectLinkedOpenHashSet(originsExcludedFromRandom);
        this.replaceOriginsExcludedFromRandom = replaceOriginsExcludedFromRandom;
        this.defaultOrigin = defaultOrigin;
        this.autoChoose = autoChoose;
        this.hidden = hidden;
    }

    public int getOrder() {
        return this.order;
    }

    public ImmutableList<ConditionedOrigin> getConditionedOrigins() {
        return ImmutableList.copyOf(this.origins);
    }

    public ImmutableList<class_2960> getOriginsExcludedFromRandom() {
        return ImmutableList.copyOf(this.originsExcludedFromRandom);
    }

    public GuiTitle getGuiTitle() {
        return this.guiTitle;
    }

    public class_2561 getName() {
        return this.name;
    }

    @Nullable
    public class_2561 getMissingName() {
        return this.missingName;
    }

    @Nullable
    public class_2561 getMissingDescription() {
        return this.missingDescription;
    }

    public class_2561 getViewOriginTitle() {
        return this.guiTitle.viewOrigin();
    }

    public class_2561 getChooseOriginTitle() {
        return this.guiTitle.chooseOrigin();
    }

    public boolean shouldReplace() {
        return this.replace;
    }

    public boolean shouldReplaceOrigins() {
        return this.replaceOrigins;
    }

    public boolean shouldReplaceExcludedOriginsFromRandom() {
        return this.replaceOriginsExcludedFromRandom;
    }

    public class_2960 getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasDefaultOrigin() {
        return this.getDefaultOrigin() != null;
    }

    @Nullable
    public class_2960 getDefaultOrigin() {
        return this.defaultOrigin;
    }

    public boolean shouldAutoChoose() {
        return this.autoChoose;
    }

    public List<class_2960> getOrigins() {
        return this.getOrigins(null);
    }

    public List<class_2960> getOrigins(@Nullable class_1657 playerEntity) {
        return this.origins.stream().filter(co -> playerEntity == null || co.isConditionFulfilled(playerEntity)).flatMap(co -> co.origins.stream()).filter(OriginManager::contains).collect(Collectors.toList());
    }

    public int getOriginOptionCount(class_1657 playerEntity) {
        int choosableOrigins = (int)this.getOrigins(playerEntity).stream().map(OriginManager::get).filter(Origin::isChoosable).count();
        if (choosableOrigins > 1 && this.randomAllowed && !this.getRandomOrigins(playerEntity).isEmpty()) {
            ++choosableOrigins;
        }
        return choosableOrigins;
    }

    public boolean contains(class_2960 originId) {
        return this.origins.stream().flatMap(co -> co.origins().stream()).anyMatch(arg_0 -> ((class_2960)originId).equals(arg_0));
    }

    public boolean contains(Origin origin) {
        return this.contains(origin.getId());
    }

    public boolean contains(class_2960 originId, class_1657 playerEntity) {
        return this.origins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.origins().stream()).anyMatch(arg_0 -> ((class_2960)originId).equals(arg_0));
    }

    public boolean contains(Origin origin, class_1657 playerEntity) {
        return this.contains(origin.getId(), playerEntity);
    }

    public boolean isRandomAllowed() {
        return this.randomAllowed;
    }

    public boolean isUnchoosableRandomAllowed() {
        return this.unchoosableRandomAllowed;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<class_2960> getRandomOrigins(class_1657 playerEntity) {
        return this.origins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.origins.stream()).filter(OriginManager::contains).filter(oId -> !this.originsExcludedFromRandom.contains(oId)).filter(oid -> this.unchoosableRandomAllowed || OriginManager.get(oid).isChoosable()).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof OriginLayer)) return false;
        OriginLayer that = (OriginLayer)obj;
        if (!Objects.equals(this.getId(), that.getId())) return false;
        return true;
    }

    @Override
    public int compareTo(OriginLayer that) {
        return Integer.compare(this.order, that.order);
    }

    public String toString() {
        return "OriginLayer{id=" + String.valueOf(this.id) + ", order=" + this.order + ", origins=" + String.valueOf(this.getOrigins()) + ", replaceOrigins=" + this.replaceOrigins + ", enabled=" + this.enabled + ", name=" + String.valueOf(this.name) + ", guiTitle=" + String.valueOf(this.guiTitle) + ", missingName=" + String.valueOf(this.missingName) + ", missingDescription=" + String.valueOf(this.missingDescription) + ", randomAllowed=" + this.randomAllowed + ", unchoosableRandomAllowed=" + this.unchoosableRandomAllowed + ", originsExcludedFromRandom=" + String.valueOf(this.originsExcludedFromRandom) + ", replaceOriginsExcludedFromRandom=" + this.replaceOriginsExcludedFromRandom + ", defaultOrigin=" + String.valueOf(this.defaultOrigin) + ", autoChoose=" + this.autoChoose + ", hidden=" + this.hidden + "}";
    }

    public record GuiTitle(@Nullable class_2561 viewOrigin, @Nullable class_2561 chooseOrigin) {
        public static final CompoundSerializableDataType<GuiTitle> DATA_TYPE = SerializableDataType.compound((SerializableData)new SerializableData().add("view_origin", SerializableDataTypes.TEXT, null).add("choose_origin", SerializableDataTypes.TEXT, null), data -> new GuiTitle((class_2561)data.get("view_origin"), (class_2561)data.get("choose_origin")), (guiTitle, serializableData) -> serializableData.instance().set("view_origin", (Object)guiTitle.viewOrigin()).set("choose_origin", (Object)guiTitle.chooseOrigin()));
    }

    public record ConditionedOrigin(@NotNull Optional<EntityCondition> condition, List<class_2960> origins) {
        public static final CompoundSerializableDataType<ConditionedOrigin> DATA_TYPE = SerializableDataType.compound((SerializableData)new SerializableData().add("condition", EntityCondition.DATA_TYPE.optional(), Optional.empty()).add("origins", SerializableDataTypes.IDENTIFIERS), data -> new ConditionedOrigin((Optional)data.get("condition"), (List)data.get("origins")), (conditionedOrigin, serializableData) -> serializableData.instance().set("condition", conditionedOrigin.condition()).set("origins", conditionedOrigin.origins()));

        public boolean isConditionFulfilled(class_1657 playerEntity) {
            return this.condition().map(condition -> condition.test((class_1297)playerEntity)).orElse(true);
        }
    }
}

