/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.packet.VersionHandshakePacket;
import io.github.apace100.origins.networking.packet.s2c.ConfirmOriginS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.OpenChooseOriginScreenS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.OriginsInstalledS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.SyncBadgesS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.SyncOriginLayersS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.SyncOriginsS2CPacket;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_8674;
import net.minecraft.class_8710;

public class ModPacketsS2C {
    @Environment(value=EnvType.CLIENT)
    public static void register() {
        ClientConfigurationConnectionEvents.START.register(ModPacketsS2C::resetOriginsInstallationStatus);
        ClientConfigurationNetworking.registerGlobalReceiver(VersionHandshakePacket.PACKET_ID, ModPacketsS2C::sendHandshakeReply);
        ClientConfigurationNetworking.registerGlobalReceiver(OriginsInstalledS2CPacket.PACKET_ID, ModPacketsS2C::receiveOriginsInstallationStatus);
        ClientPlayConnectionEvents.INIT.register((clientPlayNetworkHandler, minecraftClient) -> {
            ClientPlayNetworking.registerReceiver(ConfirmOriginS2CPacket.PACKET_ID, ModPacketsS2C::receiveOriginConfirmation);
            ClientPlayNetworking.registerReceiver(OpenChooseOriginScreenS2CPacket.PACKET_ID, ModPacketsS2C::openOriginScreen);
            ClientPlayNetworking.registerReceiver(SyncOriginLayersS2CPacket.PACKET_ID, OriginLayerManager::receive);
            ClientPlayNetworking.registerReceiver(SyncOriginsS2CPacket.PACKET_ID, OriginManager::receive);
            ClientPlayNetworking.registerReceiver(SyncBadgesS2CPacket.PACKET_ID, BadgeManager::receive);
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveOriginConfirmation(ConfirmOriginS2CPacket packet, ClientPlayNetworking.Context context) {
        class_746 player = context.player();
        OriginLayer layer = OriginLayerManager.get(packet.layerId());
        Origin origin = OriginManager.get(packet.originId());
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        component.setOrigin(layer, origin);
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof WaitForNextLayerScreen) {
            WaitForNextLayerScreen nextLayerScreen = (WaitForNextLayerScreen)class_4372;
            nextLayerScreen.openSelection();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void openOriginScreen(OpenChooseOriginScreenS2CPacket packet, ClientPlayNetworking.Context context) {
        ObjectArrayList layers = new ObjectArrayList();
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)context.player());
        OriginLayerManager.values().stream().filter(OriginLayer::isEnabled).filter(Predicate.not(component::hasOrigin)).forEach(((List)layers)::add);
        Collections.sort(layers);
        class_310.method_1551().method_1507((class_437)new ChooseOriginScreen((List<OriginLayer>)layers, 0, packet.showBackground()));
    }

    @Environment(value=EnvType.CLIENT)
    private static void sendHandshakeReply(VersionHandshakePacket packet, ClientConfigurationNetworking.Context context) {
        context.responseSender().sendPacket((class_8710)new VersionHandshakePacket(Origins.SEMVER));
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveOriginsInstallationStatus(OriginsInstalledS2CPacket packet, ClientConfigurationNetworking.Context context) {
        context.client().method_5385(() -> {
            OriginsClient.isServerRunningOrigins = true;
            return true;
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void resetOriginsInstallationStatus(class_8674 handler, class_310 client) {
        client.method_5385(() -> {
            OriginsClient.isServerRunningOrigins = false;
            return false;
        });
    }
}

