/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.packet.VersionHandshakePacket;
import io.github.apace100.origins.networking.packet.c2s.ChooseOriginC2SPacket;
import io.github.apace100.origins.networking.packet.c2s.ChooseRandomOriginC2SPacket;
import io.github.apace100.origins.networking.packet.s2c.ConfirmOriginS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.OriginsInstalledS2CPacket;
import io.github.apace100.origins.networking.task.VersionHandshakeTask;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.registry.ModComponents;
import java.util.Arrays;
import java.util.List;
import joptsimple.internal.Strings;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ModPacketsC2S {
    public static void register() {
        if (Origins.config.performVersionCheck) {
            ServerConfigurationConnectionEvents.CONFIGURE.register(ModPacketsC2S::sendHandshake);
            ServerConfigurationNetworking.registerGlobalReceiver(VersionHandshakePacket.PACKET_ID, ModPacketsC2S::receiveHandshakeReply);
        }
        ServerConfigurationConnectionEvents.CONFIGURE.register(ModPacketsC2S::sendOriginsInstallationStatus);
        ServerPlayNetworking.registerGlobalReceiver(ChooseOriginC2SPacket.PACKET_ID, ModPacketsC2S::onChooseOrigin);
        ServerPlayNetworking.registerGlobalReceiver(ChooseRandomOriginC2SPacket.PACKET_ID, ModPacketsC2S::chooseRandomOrigin);
    }

    private static void onChooseOrigin(ChooseOriginC2SPacket packet, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        OriginLayer layer = OriginLayerManager.get(packet.layerId());
        if (component.hasAllOrigins() && component.hasOrigin(layer)) {
            Origins.LOGGER.warn("Player {} tried to choose origin for layer \"{}\" while having one already.", (Object)player.method_5477().getString(), (Object)packet.layerId());
            return;
        }
        Origin origin = OriginManager.get(packet.originId());
        if (!origin.isChoosable() && !layer.contains(origin, (class_1657)player)) {
            Origins.LOGGER.warn("Player {} tried to choose unchoosable origin \"{}\" from layer \"{}\"!", (Object)player.method_5477().getString(), (Object)packet.originId(), (Object)packet.layerId());
            component.setOrigin(layer, Origin.EMPTY);
        } else {
            boolean hadOriginBefore = component.hadOriginBefore();
            boolean hadAllOrigins = component.hasAllOrigins();
            component.setOrigin(layer, origin);
            component.checkAutoChoosingLayers((class_1657)player, false);
            if (component.hasAllOrigins() && !hadAllOrigins) {
                OriginComponent.onChosen((class_1657)player, hadOriginBefore);
            }
            Origins.LOGGER.info("Player {} chose origin \"{}\" for layer \"{}\"", (Object)player.method_5477().getString(), (Object)packet.originId(), (Object)packet.layerId());
        }
        ModPacketsC2S.confirmOrigin(player, layer, component.getOrigin(layer));
        component.selectingOrigin(false);
        component.sync();
    }

    private static void chooseRandomOrigin(ChooseRandomOriginC2SPacket packet, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        OriginLayer layer = OriginLayerManager.get(packet.layerId());
        if (component.hasAllOrigins() && component.hasOrigin(layer)) {
            Origins.LOGGER.warn("Player {} tried to choose origin for layer \"{}\" while having one already.", (Object)player.method_5477().getString(), (Object)packet.layerId());
            return;
        }
        List<class_2960> randomOriginIds = layer.getRandomOrigins((class_1657)player);
        if (!layer.isRandomAllowed() || randomOriginIds.isEmpty()) {
            Origins.LOGGER.warn("Player {} tried to choose a random origin for layer \"{}\", which is not allowed!", (Object)player.method_5477().getString(), (Object)packet.layerId());
            component.setOrigin(layer, Origin.EMPTY);
        } else {
            class_2960 randomOriginId = randomOriginIds.get(player.method_59922().method_43048(randomOriginIds.size()));
            Origin origin = OriginManager.get(randomOriginId);
            boolean hadOriginBefore = component.hadOriginBefore();
            boolean hadAllOrigins = component.hasAllOrigins();
            component.setOrigin(layer, origin);
            component.checkAutoChoosingLayers((class_1657)player, false);
            if (component.hasAllOrigins() && !hadAllOrigins) {
                OriginComponent.onChosen((class_1657)player, hadOriginBefore);
            }
            Origins.LOGGER.info("Player {} was randomly assigned the following origin: {}", (Object)player.method_5477().getString(), (Object)randomOriginId);
        }
        ModPacketsC2S.confirmOrigin(player, layer, component.getOrigin(layer));
        component.selectingOrigin(false);
        component.sync();
    }

    private static void receiveHandshakeReply(VersionHandshakePacket packet, ServerConfigurationNetworking.Context context) {
        class_8610 handler = context.networkHandler();
        boolean mismatch = packet.semver().length != Origins.SEMVER.length;
        for (int i = 0; !mismatch && i < packet.semver().length - 1; ++i) {
            mismatch = packet.semver()[i] != Origins.SEMVER[i];
        }
        if (mismatch) {
            handler.method_52396((class_2561)class_2561.method_43469((String)"origins.gui.version_mismatch", (Object[])new Object[]{Origins.VERSION, Strings.join(Arrays.stream(packet.semver()).mapToObj(String::valueOf).toList(), (String)".")}));
        } else {
            handler.completeTask(VersionHandshakeTask.KEY);
        }
    }

    private static void sendOriginsInstallationStatus(class_8610 handler, MinecraftServer server) {
        handler.method_14364(ServerConfigurationNetworking.createS2CPacket((class_8710)OriginsInstalledS2CPacket.INSTANCE));
    }

    private static void sendHandshake(class_8610 handler, MinecraftServer server) {
        if (ServerConfigurationNetworking.canSend((class_8610)handler, VersionHandshakePacket.PACKET_ID)) {
            handler.addTask((class_8605)new VersionHandshakeTask(Origins.SEMVER));
        } else {
            handler.method_52396(class_2561.method_30163((String)("This server requires you to install the Origins mod (v " + Origins.VERSION + ") to play.")));
        }
    }

    private static void confirmOrigin(class_3222 player, OriginLayer layer, Origin origin) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfirmOriginS2CPacket(layer.getId(), origin.getId()));
    }
}

