/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.type.ModifyPlayerSpawnPowerType;
import io.github.apace100.apoli.power.type.PowerType;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.power.type.OriginsActionOnCallbackPowerType;
import io.github.apace100.origins.registry.ModComponents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public interface OriginComponent
extends AutoSyncedComponent,
ServerTickingComponent {
    public Map<OriginLayer, Origin> getOrigins();

    public Origin getOrigin(OriginLayer var1);

    public boolean hasSelectionInvulnerability();

    public boolean isSelectingOrigin();

    public boolean hasOrigin(OriginLayer var1);

    public boolean hasAllOrigins();

    public boolean hadOriginBefore();

    public void selectingOrigin(boolean var1);

    public void removeLayer(OriginLayer var1);

    public void setOrigin(OriginLayer var1, Origin var2);

    public void sync();

    public static void sync(class_1657 player) {
        ModComponents.ORIGIN.sync((Object)player);
    }

    public static void onChosen(class_1657 player, boolean hadOriginBefore) {
        if (!hadOriginBefore) {
            PowerHolderComponent.getPowerTypes((class_1297)player, ModifyPlayerSpawnPowerType.class).stream().max(Comparator.comparing(ModifyPlayerSpawnPowerType::getPriority)).ifPresent(ModifyPlayerSpawnPowerType::teleportToModifiedSpawn);
        }
        PowerHolderComponent.withPowerTypes((class_1297)player, OriginsActionOnCallbackPowerType.class, p -> true, p -> p.onChosen(hadOriginBefore));
    }

    public static void partialOnChosen(class_1657 player, boolean hadOriginBefore, Origin origin) {
        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.getOptional((class_1297)player).orElseThrow();
        for (Power power : powerComponent.getPowersFromSource(origin.getId())) {
            PowerType powerType = powerComponent.getPowerType(power);
            if (powerType instanceof ModifyPlayerSpawnPowerType) {
                ModifyPlayerSpawnPowerType mps = (ModifyPlayerSpawnPowerType)powerType;
                if (!hadOriginBefore) {
                    mps.teleportToModifiedSpawn();
                    continue;
                }
            }
            if (!(powerType instanceof OriginsActionOnCallbackPowerType)) continue;
            OriginsActionOnCallbackPowerType ocp = (OriginsActionOnCallbackPowerType)powerType;
            ocp.onChosen(hadOriginBefore);
        }
    }

    default public boolean checkAutoChoosingLayers(class_1657 player, boolean includeDefaults) {
        ArrayList layers = new ArrayList();
        boolean choseOneAutomatically = false;
        OriginLayerManager.values().stream().filter(OriginLayer::isEnabled).forEach(layers::add);
        Collections.sort(layers);
        for (OriginLayer layer : layers) {
            if (!layer.isEnabled() || this.hasOrigin(layer)) continue;
            if (includeDefaults && layer.hasDefaultOrigin()) {
                this.setOrigin(layer, OriginManager.get(layer.getDefaultOrigin()));
                choseOneAutomatically = true;
                continue;
            }
            if (layer.getOriginOptionCount(player) != 1 || !layer.shouldAutoChoose()) continue;
            List<Origin> origins = layer.getOrigins(player).stream().map(OriginManager::get).filter(Origin::isChoosable).toList();
            if (!origins.isEmpty()) {
                this.setOrigin(layer, origins.getFirst());
                choseOneAutomatically = true;
                continue;
            }
            if (!layer.isRandomAllowed() || layer.getRandomOrigins(player).isEmpty()) continue;
            List<class_2960> randomOriginIds = layer.getRandomOrigins(player);
            int randomOriginIndex = player.method_59922().method_43048(randomOriginIds.size());
            this.setOrigin(layer, OriginManager.get(randomOriginIds.get(randomOriginIndex)));
            choseOneAutomatically = true;
        }
        return choseOneAutomatically;
    }
}

