/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.type.ModifyCraftingPowerType;
import io.github.apace100.apoli.util.InventoryUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactories;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.badge.TooltipBadge;
import io.github.apace100.origins.screen.tooltip.CraftingRecipeTooltipComponent;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3955;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_5630;
import net.minecraft.class_5684;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public record CraftingRecipeBadge(class_2960 spriteId, class_8786<class_3955> recipe, @Nullable class_2561 prefix, @Nullable class_2561 suffix) implements Badge
{
    public CraftingRecipeBadge(SerializableData.Instance instance) {
        this(instance.getId("sprite"), (class_8786<class_3955>)((class_8786)instance.get("recipe")), (class_2561)instance.get("prefix"), (class_2561)instance.get("suffix"));
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    public class_2371<class_1799> peekInputs(float time) {
        class_2371 inputs = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        class_2371 ingredients = ((class_3955)this.recipe.comp_1933()).method_8117();
        int seed = class_3532.method_15375((float)(time / 30.0f));
        for (int index = 0; index < ingredients.size(); ++index) {
            class_1799[] stacks = ((class_1856)ingredients.get(index)).method_8105();
            if (stacks.length <= 0) continue;
            inputs.set(index, (Object)stacks[seed % stacks.length]);
        }
        return inputs;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<class_5684> getTooltipComponents(Power power, int widthLimit, float time, class_327 textRenderer) {
        int n;
        class_310 client = class_310.method_1551();
        LinkedList<class_5684> tooltips = new LinkedList<class_5684>();
        if (client.field_1687 == null) {
            Origins.LOGGER.warn("Could not construct crafting recipe badge, as world was null!");
            return tooltips;
        }
        class_1860 class_18602 = this.recipe.comp_1933();
        if (class_18602 instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)class_18602;
            n = shapedRecipe.method_8150();
        } else {
            n = 3;
        }
        int recipeWidth = n;
        class_5455 registryManager = client.field_1687.method_30349();
        class_5630 outputStackReference = InventoryUtil.createStackReference((class_1799)((class_3955)this.recipe.comp_1933()).method_8110((class_7225.class_7874)registryManager));
        PowerHolderComponent.getPowerTypes((class_1297)client.field_1724, ModifyCraftingPowerType.class).stream().filter(p -> p.doesApply(this.recipe.comp_1932(), outputStackReference.method_32327())).max(Comparator.comparing(ModifyCraftingPowerType::getPriority)).ifPresent(p -> p.getNewResult(outputStackReference));
        CraftingRecipeTooltipComponent recipeTooltip = new CraftingRecipeTooltipComponent(recipeWidth, this.peekInputs(time), outputStackReference.method_32327());
        if (client.field_1690.field_1827) {
            class_5250 recipeIdText = class_2561.method_43470((String)this.recipe.comp_1932().toString()).method_27692(class_124.field_1063);
            widthLimit = Math.max(130, textRenderer.method_27525((class_5348)recipeIdText));
            if (this.prefix != null) {
                TooltipBadge.addLines(tooltips, this.prefix, textRenderer, widthLimit);
            }
            tooltips.add(recipeTooltip);
            if (this.suffix != null) {
                TooltipBadge.addLines(tooltips, this.suffix, textRenderer, widthLimit);
            }
            TooltipBadge.addLines(tooltips, (class_2561)recipeIdText, textRenderer, widthLimit);
        } else {
            widthLimit = 130;
            if (this.prefix != null) {
                TooltipBadge.addLines(tooltips, this.prefix, textRenderer, widthLimit);
            }
            tooltips.add(recipeTooltip);
            if (this.suffix != null) {
                TooltipBadge.addLines(tooltips, this.suffix, textRenderer, widthLimit);
            }
        }
        return tooltips;
    }

    @Override
    public SerializableData.Instance toData(SerializableData.Instance instance) {
        instance.set("sprite", (Object)this.spriteId);
        instance.set("recipe", this.recipe);
        instance.set("prefix", (Object)this.prefix);
        instance.set("suffix", (Object)this.suffix);
        return instance;
    }

    @Override
    public BadgeFactory getBadgeFactory() {
        return BadgeFactories.CRAFTING_RECIPE;
    }
}

