/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.integration.PostPowerLoadCallback;
import io.github.apace100.apoli.integration.PowerOverrideCallback;
import io.github.apace100.apoli.integration.PrePowerReloadCallback;
import io.github.apace100.apoli.power.MultiplePower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerManager;
import io.github.apace100.apoli.power.type.Active;
import io.github.apace100.apoli.power.type.PowerType;
import io.github.apace100.apoli.power.type.RecipePowerType;
import io.github.apace100.apoli.power.type.ToggleNightVisionPowerType;
import io.github.apace100.apoli.power.type.TogglePowerType;
import io.github.apace100.calio.data.DataException;
import io.github.apace100.calio.registry.DataObjectFactory;
import io.github.apace100.calio.registry.DataObjectRegistry;
import io.github.apace100.calio.util.DynamicIdentifier;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactories;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.badge.CraftingRecipeBadge;
import io.github.apace100.origins.badge.KeybindBadge;
import io.github.apace100.origins.integration.AutoBadgeCallback;
import io.github.apace100.origins.networking.packet.s2c.SyncBadgesS2CPacket;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_8710;
import net.minecraft.class_8786;

public final class BadgeManager {
    public static final DataObjectRegistry<Badge> REGISTRY = new DataObjectRegistry.Builder(Origins.identifier("badge")).readFromData("badges", true).dataErrorHandler((id, packName, exception) -> Origins.LOGGER.error("Error trying to read badge \"" + String.valueOf(id) + "\" from data pack [" + packName + "]: " + String.valueOf(exception))).defaultFactory((DataObjectFactory)BadgeFactories.KEYBIND).buildAndRegister();
    private static final Map<class_2960, List<Badge>> BADGES_BY_ID = new HashMap<class_2960, List<Badge>>();
    private static final class_2960 TOGGLE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/toggle.png");
    private static final class_2960 ACTIVE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/active.png");
    private static final class_2960 RECIPE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/recipe.png");
    private static final class_2960 TOGGLE_BADGE_ID = Origins.identifier("toggle");
    private static final class_2960 ACTIVE_BADGE_ID = Origins.identifier("active");

    public static void init() {
        BadgeManager.register(BadgeFactories.SPRITE);
        BadgeManager.register(BadgeFactories.TOOLTIP);
        BadgeManager.register(BadgeFactories.CRAFTING_RECIPE);
        BadgeManager.register(BadgeFactories.KEYBIND);
        PrePowerReloadCallback.EVENT.register(BADGES_BY_ID::clear);
        PowerManager.registerAdditionalData((String)"badges", BadgeManager::readCustomBadges);
        PowerOverrideCallback.EVENT.register(BADGES_BY_ID::remove);
        PostPowerLoadCallback.EVENT.register(BadgeManager::readAutoBadges);
        AutoBadgeCallback.EVENT.register(BadgeManager::createAutoBadges);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.addPhaseOrdering(PowerManager.ID, REGISTRY.getRegistryId());
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(REGISTRY.getRegistryId(), (player, joined) -> BadgeManager.send(player));
    }

    public static void send(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncBadgesS2CPacket(BADGES_BY_ID));
    }

    @Environment(value=EnvType.CLIENT)
    public static void receive(SyncBadgesS2CPacket packet, ClientPlayNetworking.Context context) {
        BADGES_BY_ID.clear();
        BADGES_BY_ID.putAll(packet.badgesById());
    }

    public static void register(BadgeFactory factory) {
        REGISTRY.registerFactory(factory.id(), (DataObjectFactory)factory);
    }

    public static List<Badge> getPowerBadges(class_2960 powerId) {
        return BADGES_BY_ID.getOrDefault(powerId, List.of());
    }

    public static boolean hasPowerBadges(class_2960 powerId) {
        return BADGES_BY_ID.containsKey(powerId);
    }

    public static boolean hasPowerBadges(Power power) {
        return BadgeManager.hasPowerBadges(power.getId());
    }

    private static void readCustomBadges(class_2960 powerId, class_2960 factoryId, boolean isSubPower, JsonElement data, Power power) {
        if (power.isHidden() || isSubPower) {
            return;
        }
        try {
            if (!(data instanceof JsonArray)) {
                throw new JsonSyntaxException("Not a JSON array: " + String.valueOf(data));
            }
            JsonArray dataArray = (JsonArray)data;
            List badges = BADGES_BY_ID.computeIfAbsent(powerId, id -> new LinkedList());
            for (int i = 0; i < dataArray.size(); ++i) {
                Badge badge;
                JsonElement jsonElement;
                JsonElement badgeJson = dataArray.get(i);
                Objects.requireNonNull(badgeJson);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonObject.class, JsonPrimitive.class}, (Object)jsonElement, n)) {
                    case 0: {
                        Badge badge2;
                        JsonObject jsonObject = (JsonObject)jsonElement;
                        try {
                            badge = badge2 = (Badge)REGISTRY.readDataObject((JsonElement)jsonObject);
                            break;
                        }
                        catch (DataException de) {
                            throw de.prependArray(i);
                        }
                        catch (Exception e) {
                            throw new DataException(DataException.Phase.READING, i, e);
                        }
                    }
                    case 1: {
                        Badge badge2;
                        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
                        class_2960 badgeId = DynamicIdentifier.of((JsonElement)jsonPrimitive);
                        Badge referencedBadge = (Badge)REGISTRY.get(badgeId);
                        if (referencedBadge != null) {
                            badge = badge2 = referencedBadge;
                            break;
                        }
                        throw new DataException(DataException.Phase.READING, i, "Badge \"" + String.valueOf(badgeId) + "\" is undefined!");
                    }
                    default: {
                        throw new JsonSyntaxException("Not a JSON object or string: " + String.valueOf(badgeJson));
                    }
                }
                Badge badge3 = badge;
                badges.add(badge3);
            }
        }
        catch (Exception e) {
            Origins.LOGGER.error("There was a problem reading badges of power \"{}\": {}", (Object)powerId, e.getMessage() != null ? e.getMessage() : e);
        }
    }

    private static void readAutoBadges(class_2960 powerId, class_2960 factoryId, boolean isSubPower, JsonObject json, Power power) {
        if (!(BadgeManager.hasPowerBadges(powerId) || power instanceof MultiplePower || !isSubPower && power.isHidden())) {
            ((AutoBadgeCallback)AutoBadgeCallback.EVENT.invoker()).createAutoBadge(powerId, power, BADGES_BY_ID.computeIfAbsent(powerId, id -> new LinkedList()));
        }
    }

    private static void createAutoBadges(class_2960 powerId, Power power, List<Badge> badgeList) {
        PowerType powerType = power.getPowerType();
        Objects.requireNonNull(powerType);
        PowerType powerType2 = powerType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Active.class, RecipePowerType.class}, (Object)powerType2, n)) {
            case 0: {
                class_2960 autoBadgeId;
                Active active = (Active)powerType2;
                boolean toggle = active instanceof TogglePowerType || active instanceof ToggleNightVisionPowerType;
                class_2960 class_29602 = autoBadgeId = toggle ? TOGGLE_BADGE_ID : ACTIVE_BADGE_ID;
                if (REGISTRY.containsId(autoBadgeId)) {
                    badgeList.add((Badge)REGISTRY.get(autoBadgeId));
                    break;
                }
                class_2960 spriteId = toggle ? TOGGLE_BADGE_SPRITE : ACTIVE_BADGE_SPRITE;
                String key = toggle ? "origins.gui.badge.toggle" : "origins.gui.badge.active";
                badgeList.add(new KeybindBadge(spriteId, key));
                break;
            }
            case 1: {
                class_3955 craftingRecipe;
                RecipePowerType recipePowerType = (RecipePowerType)powerType2;
                class_3955 class_39552 = craftingRecipe = recipePowerType.getRecipe();
                Objects.requireNonNull(class_39552);
                class_3955 class_39553 = class_39552;
                int n2 = 0;
                String type = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1869.class, class_1867.class}, (Object)class_39553, n2)) {
                    case 0 -> {
                        class_1869 ignored = (class_1869)class_39553;
                        yield "shaped";
                    }
                    case 1 -> {
                        class_1867 ignored = (class_1867)class_39553;
                        yield "shapeless";
                    }
                    default -> "unknown";
                };
                badgeList.add(new CraftingRecipeBadge(RECIPE_BADGE_SPRITE, (class_8786<class_3955>)new class_8786(powerId, (class_1860)craftingRecipe), (class_2561)class_2561.method_43471((String)("origins.gui.badge.recipe.crafting." + type)), null));
                break;
            }
        }
    }
}

