/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.filter;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractSmartFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.util.PlatformUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentFilter
extends AbstractSmartFilter {
    public static final class_2960 ID = FTBFilterSystemAPI.rl("component");
    protected final class_9323 map;
    private final boolean fuzzyMatch;

    public ComponentFilter(@Nullable SmartFilter.Compound parent) {
        this(parent, true, class_9323.field_49584);
    }

    public ComponentFilter(SmartFilter.Compound parent, boolean fuzzyMatch, class_9323 map) {
        super(parent);
        this.fuzzyMatch = fuzzyMatch;
        this.map = map;
    }

    @NotNull
    public static String getPrefixStr(boolean fuzzy) {
        return fuzzy ? "fuzzy:" : "strict:";
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public boolean test(class_1799 stack) {
        return PlatformUtil.hasComponentPatch(stack) ? (this.fuzzyMatch ? this.fuzzyMatch(stack.method_57353()) : stack.method_57353().equals((Object)this.map)) : this.map.method_57837();
    }

    private boolean fuzzyMatch(class_9323 toMatch) {
        return this.map.method_57833().allMatch(tc -> toMatch.method_57832(tc.comp_2443()) && toMatch.method_57829(tc.comp_2443()).equals(tc.comp_2444()));
    }

    @Override
    public String getStringArg() {
        try {
            class_2520 tag = (class_2520)class_9323.field_50234.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.map).getOrThrow();
            return ComponentFilter.getPrefixStr(this.fuzzyMatch) + tag.toString();
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    public class_9323 getComponentMap() {
        return this.map;
    }

    public boolean isFuzzyMatch() {
        return this.fuzzyMatch;
    }

    public static ComponentFilter fromString(SmartFilter.Compound parent, String str) {
        try {
            boolean fuzzy = true;
            if (str.startsWith("strict:") || str.startsWith("fuzzy:")) {
                fuzzy = str.startsWith("fuzzy:");
                str = str.substring(str.indexOf(58) + 1);
            }
            class_9323 map = (class_9323)class_9323.field_50234.parse((DynamicOps)class_2509.field_11560, (Object)ComponentFilter.parseNBT(str)).getOrThrow(FilterException::new);
            return new ComponentFilter(parent, fuzzy, map);
        }
        catch (CommandSyntaxException e) {
            throw new FilterException("invalid NBT tag: " + str, e);
        }
    }

    private static class_2487 parseNBT(String str) throws CommandSyntaxException {
        if (!((String)str).startsWith("{") && !((String)str).endsWith("}")) {
            str = "{" + (String)str + "}";
        }
        return class_2522.method_10718((String)str);
    }
}

