/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client;

import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_768;

public class GuiUtil {
    public static void drawPanel(class_332 graphics, class_768 area, int bgColor, int borderColor, BorderStyle borderStyle, int borderWidth) {
        int xMax = area.method_3321() + area.method_3319();
        int yMax = area.method_3322() + area.method_3320();
        graphics.method_25294(area.method_3321(), area.method_3322(), xMax, yMax, bgColor);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)(-borderWidth / 2), (float)(-borderWidth / 2), 0.0f);
        int brCol = borderStyle.bottomRight(bgColor, borderColor);
        graphics.method_25294(area.method_3321() + 1, yMax, xMax, yMax + borderWidth, brCol);
        graphics.method_25294(xMax, area.method_3322() + 1, xMax + borderWidth, yMax, brCol);
        int tlCol = borderStyle.topLeft(bgColor, borderColor);
        graphics.method_25294(area.method_3321(), area.method_3322(), xMax, area.method_3322() + borderWidth, tlCol);
        graphics.method_25294(area.method_3321(), area.method_3322(), area.method_3321() + borderWidth, yMax, tlCol);
        graphics.method_51448().method_22909();
    }

    public static int brighten(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return GuiUtil.makeRGB(a, i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return GuiUtil.makeRGB(a, Math.min((int)((float)r / factor), 255), Math.min((int)((float)g / factor), 255), Math.min((int)((float)b / factor), 255));
    }

    public static int darken(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return GuiUtil.makeRGB(a, Math.max((int)((float)r * factor), 0), Math.max((int)((float)g * factor), 0), Math.max((int)((float)b * factor), 0));
    }

    private static int makeRGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static class_768 outsetRect(class_768 orig, int amount) {
        return new class_768(orig.method_3321() - amount, orig.method_3322() - amount, orig.method_3319() + amount * 2, orig.method_3320() + amount * 2);
    }

    public static class_5348 ellipsize(class_327 font, class_5348 text, int maxWidth) {
        int width = font.method_27525(text);
        int eWidth = font.method_27525((class_5348)class_5244.field_39678);
        if (width > maxWidth) {
            return eWidth >= maxWidth ? font.method_1714(text, maxWidth) : class_5348.method_29433((class_5348[])new class_5348[]{font.method_1714(text, maxWidth - eWidth), class_5244.field_39678});
        }
        return text;
    }

    public static enum BorderStyle {
        NONE,
        PLAIN,
        OUTSET,
        INSET;


        public int topLeft(int bgColor, int borderColor) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> bgColor;
                case 1 -> borderColor;
                case 2 -> GuiUtil.brighten(borderColor, 0.7f);
                case 3 -> GuiUtil.darken(borderColor, 0.7f);
            };
        }

        public int bottomRight(int bgColor, int borderColor) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> bgColor;
                case 1 -> borderColor;
                case 2 -> GuiUtil.darken(borderColor, 0.7f);
                case 3 -> GuiUtil.brighten(borderColor, 0.7f);
            };
        }
    }
}

