/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem;

import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemRegistry;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.DumpedFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.filter.ItemTagFilter;
import dev.ftb.mods.ftbfiltersystem.registry.FilterRegistry;
import dev.ftb.mods.ftbfiltersystem.registry.ModItems;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public enum FilterSystemAPIImpl implements FTBFilterSystemAPI.API
{
    INSTANCE;


    @Override
    public FTBFilterSystemRegistry getRegistry() {
        return FilterRegistry.INSTANCE;
    }

    @Override
    public boolean isFilterItem(class_1799 stack) {
        return stack.method_7909() instanceof SmartFilterItem;
    }

    @Override
    public class_1792 filterItem() {
        return Objects.requireNonNull((class_1792)ModItems.SMART_FILTER.get());
    }

    @Override
    public boolean doesFilterMatch(class_1799 filterStack, class_1799 toMatch) {
        try {
            return this.isFilterItem(filterStack) && FilterParser.parse(SmartFilterItem.getFilterString(filterStack)).test(toMatch);
        }
        catch (FilterException e) {
            return false;
        }
    }

    @Override
    public List<DumpedFilter> dump(SmartFilter filter) {
        return this.dump(filter, 0, new ArrayList<DumpedFilter>());
    }

    @Override
    public Optional<SmartFilter> createDefaultFilter(SmartFilter.Compound parent, class_2960 filterId) {
        return FilterRegistry.INSTANCE.createDefaultFilter(parent, filterId);
    }

    @Override
    public SmartFilter parseFilter(String filterStr) throws FilterException {
        return FilterParser.parse(filterStr);
    }

    @Override
    public SmartFilter parseFilter(class_1799 filterStack) throws FilterException {
        return this.parseFilter(SmartFilterItem.getFilterString(filterStack));
    }

    @Override
    public List<SmartFilter> parseFilterList(SmartFilter.Compound parent, String filterStr) throws FilterException {
        return FilterParser.parseFilterList(parent, filterStr);
    }

    @Override
    public class_1799 makeTagFilter(class_6862<class_1792> tagKey) {
        class_1799 res = new class_1799((class_1935)ModItems.SMART_FILTER.get());
        SmartFilterItem.setFilter(res, String.valueOf(ItemTagFilter.ID) + "(" + String.valueOf(tagKey.comp_327()) + ")");
        return res;
    }

    private List<DumpedFilter> dump(SmartFilter filter, int indent, List<DumpedFilter> res) {
        res.add(new DumpedFilter(indent, filter));
        if (filter instanceof SmartFilter.Compound) {
            SmartFilter.Compound cf = (SmartFilter.Compound)filter;
            cf.getChildren().forEach(f -> this.dump((SmartFilter)f, indent + 1, res));
        }
        return res;
    }
}

