/*
 * Decompiled with CFR 0.152.
 */
package com.mythicmetals.item.tools;

import com.mythicmetals.component.GoldFoldedComponent;
import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.item.tools.MythicTools;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class MidasGoldSword
extends class_1829 {
    public MidasGoldSword(class_1832 material, class_1792.class_1793 settings) {
        super(material, settings);
    }

    public void method_7860(class_1799 stack) {
        class_9285 currentAttributes = (class_9285)stack.method_57824(class_9334.field_49636);
        int goldCount = ((GoldFoldedComponent)stack.method_57825(MythicDataComponents.GOLD_FOLDED, (Object)GoldFoldedComponent.of(0))).goldFolded();
        AtomicReference<Double> originalDamage = new AtomicReference<Double>(0.0);
        ((class_9285)stack.method_58658().method_57829(class_9334.field_49636)).comp_2393().forEach(entry -> {
            if (entry.comp_2396().comp_2447().equals((Object)field_8006)) {
                originalDamage.set(entry.comp_2396().comp_2449());
            }
        });
        double goldDmgBonus = this.computeBonusDamage(goldCount);
        AtomicReference<Double> speed = new AtomicReference<Double>(0.0);
        currentAttributes.comp_2393().forEach(entry -> {
            if (entry.comp_2395().equals((Object)class_5134.field_23723)) {
                speed.set(entry.comp_2396().comp_2449());
            }
        });
        if (goldDmgBonus > 0.0) {
            class_9285 changedComponent = class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(field_8006, originalDamage.get() + goldDmgBonus, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(field_8001, speed.get().doubleValue(), class_1322.class_1323.field_6328), class_9274.field_49217).method_57486();
            stack.method_57379(class_9334.field_49636, (Object)changedComponent);
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> lines, class_1836 type) {
        if (stack.method_57826(MythicDataComponents.GOLD_FOLDED)) {
            ((GoldFoldedComponent)stack.method_57824(MythicDataComponents.GOLD_FOLDED)).method_57409(context, lines::add, type);
        }
    }

    public int computeBonusDamage(int goldCount) {
        int bonus = class_3532.method_15340((int)class_3532.method_15375((float)((float)goldCount / 64.0f)), (int)0, (int)6);
        if (goldCount >= 1280) {
            ++bonus;
        }
        return bonus;
    }

    public static float countGold(int goldCount) {
        if (goldCount >= 1280) {
            return 1.0f;
        }
        return switch (goldCount / 64) {
            case 1 -> 0.1f;
            case 2, 3 -> 0.2f;
            case 4 -> 0.3f;
            case 5, 6, 7, 8, 9 -> 0.4f;
            case 10, 11 -> 0.5f;
            case 12, 13 -> 0.6f;
            case 14, 15 -> 0.7f;
            case 16, 17 -> 0.8f;
            case 18 -> 0.9f;
            case 19 -> 1.0f;
            default -> 0.0f;
        };
    }

    public static int calculateSwordLevel(int goldCount) {
        if (goldCount < 64) {
            return 0;
        }
        return goldCount / 64;
    }

    public static enum Type {
        REGULAR,
        GILDED,
        ROYAL;


        @Nullable
        public static Type getSwordType(class_1799 stack) {
            return Type.getSwordType(stack.method_7909());
        }

        @Nullable
        public static Type getSwordType(class_1792 item) {
            if (item.equals(MythicTools.MIDAS_GOLD_SWORD)) {
                return REGULAR;
            }
            if (item.equals(MythicTools.GILDED_MIDAS_GOLD_SWORD)) {
                return GILDED;
            }
            if (item.equals(MythicTools.ROYAL_MIDAS_GOLD_SWORD)) {
                return ROYAL;
            }
            return null;
        }

        public static boolean isOf(class_1799 stack, Type type) {
            Type comparedType = Type.getSwordType(stack);
            if (comparedType != null) {
                return comparedType.equals((Object)type);
            }
            return false;
        }
    }
}

