/*
 * Decompiled with CFR 0.152.
 */
package com.mythicmetals.command;

import com.mythicmetals.block.BlockSet;
import com.mythicmetals.config.OreConfig;
import com.mythicmetals.item.tools.MythicTools;
import com.mythicmetals.item.tools.ToolSet;
import com.mythicmetals.misc.StringUtilsAtHome;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Stack;
import net.minecraft.class_1078;
import net.minecraft.class_1831;
import net.minecraft.class_2477;
import net.minecraft.class_7923;

public class WikiExporter {
    static final String ADMONITION_HEADER = "!!! info inline end \"\"\n    <center class=tooltip>\n";
    static final String ADMONIITION_TOP_IMAGE = "    <h3>**%s**</h3>\n    ![WRITE ALT TEXT HERE](%s)<br>\n";
    static final String ADMONITION_TOOL_IMAGE = "    <h3>**%s**</h3>\n    ![WRITE ALT TEXT HERE]%s<br>\n";
    static final String RECIPE_SCALING = "{ .sized-image style=\"--image-width: 40%;\" }";

    public static String computeToolset(ToolSet toolSet) {
        return WikiExporter.createToolTemplate(toolSet.getTitlecaseName(), WikiExporter.computeToolAdmonition(toolSet), WikiExporter.computeToolRecipes(toolSet));
    }

    public static String createOreTemplate(String oreName, BlockSet blockSet, OreConfig oreConfig) {
        return WikiExporter.createOreTemplate(oreName, WikiExporter.computeOreAdmonition(blockSet, oreConfig));
    }

    static String createOreTemplate(String name, String admonition) {
        return "\n---\ntitle: %s\nproject: mythicmetals\nsummary: A summary of %s, their history, and where to find them.\n---\n\n%s\n\n## Generation\n\n## Usages\n\n## Trivia\n\n## History\n\n".formatted(name, name, admonition);
    }

    static String createToolTemplate(String name, String admonition, String recipes) {
        return "\n---\ntitle: %s Tools\nproject: mythicmetals\nsummary: A summary of %s Tools, their abilities, their history, and how to craft them.\n---\n\n%s\n## Obtaining\n\n### Crafting\n\nTools can be crafted from [TODO - LINK TO MATERIAL.]\n\n%s\n## Usages\n\nTODO - Remove if irrelevant, for example if it does not craft into anything\n\n## Trivia\n\n## History\n\n".formatted(name, name, admonition, recipes);
    }

    static String computeToolAdmonition(ToolSet toolSet) {
        StringBuilder output = new StringBuilder();
        class_2477 translationStorage = class_1078.method_10517();
        ArrayDeque<Integer> damageDeque = new ArrayDeque<Integer>(Arrays.stream(MythicTools.DEFAULT_DAMAGE).boxed().toList());
        Stack<Float> atkSpd = new Stack<Float>();
        atkSpd.addAll(toolSet.getAttackSpeed());
        output.append(ADMONITION_HEADER);
        toolSet.get().forEach(tool -> {
            String id = class_7923.field_41178.method_10221(tool).method_12832();
            output.append(ADMONITION_TOOL_IMAGE.formatted(translationStorage.method_48307(tool.method_7876()), "(../../assets/mythicmetals/%s.png)".formatted(id) + RECIPE_SCALING));
            output.append("    +%s Attack Damage, %s Attack Speed<br>\n    %s Durability<br>\n".formatted(Float.valueOf(tool.method_8022().method_8028() + (float)((Integer)damageDeque.pop()).intValue() + 1.0f), BigDecimal.valueOf(((Float)atkSpd.pop()).floatValue()).setScale(1, RoundingMode.HALF_UP).toPlainString(), tool.method_7854().method_7936()));
        });
        return output.toString();
    }

    static String computeToolRecipes(ToolSet toolSet) {
        StringBuilder output = new StringBuilder();
        for (class_1831 tool : toolSet.get()) {
            String id = class_7923.field_41178.method_10221((Object)tool).method_12832();
            String name = StringUtilsAtHome.toTitleCase(id.replace('_', ' '));
            output.append("![Image of the recipe for %s](../../assets/mythicmetals/recipes/tools/%s.png)%s\n".formatted(name, id, RECIPE_SCALING));
        }
        return output.toString();
    }

    static String computeOreAdmonition(BlockSet blockSet, OreConfig oreConfig) {
        class_2477 translationStorage = class_1078.method_10517();
        StringBuilder output = new StringBuilder();
        output.append(ADMONITION_HEADER);
        output.append(ADMONIITION_TOP_IMAGE.formatted(translationStorage.method_48307(blockSet.getOre().method_9539()), "../../assets/mythicmetals/%s.png".formatted(blockSet.getName() + "_ore")));
        blockSet.getOreVariantsMap().forEach((variantName, block) -> {
            String variantOreName = translationStorage.method_48307(block.method_9539());
            output.append(ADMONIITION_TOP_IMAGE.formatted(variantOreName, "../../assets/mythicmetals/" + variantName + "_" + blockSet.getName() + "_ore.png"));
        });
        String oreStatsTemplate = "    ---\n    **Mining Level**: X (Y for variant)<br>\n    **Max Vein Size**: %s<br>\n    **Attempts Per Chunk**: %s<br>\n    **Spawn Range**: %s to %s<br>\n    **Discard Chance**: %s<br>\n".formatted(oreConfig.veinSize, oreConfig.perChunk, oreConfig.bottom + (oreConfig.offset ? "(Offset)" : ""), oreConfig.top + (oreConfig.trapezoid ? " (Triangle Range)" : ""), oreConfig.discardChance == 0.0f ? "Never discarded" : oreConfig.discardChance * 100.0f + "%");
        output.append(oreStatsTemplate);
        return output.toString();
    }
}

