/*
 * Decompiled with CFR 0.152.
 */
package com.mythicmetals.block;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.mythicmetals.MythicMetals;
import com.mythicmetals.block.BanglumOreBlock;
import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.block.StarriteOreBlock;
import com.mythicmetals.misc.RegistryHelper;
import io.wispforest.owo.util.Maldenhagen;
import io.wispforest.owo.util.TagInjector;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_2199;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2431;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5541;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_7923;

public class BlockSet {
    private final class_2431 ore;
    private final class_2248 storageBlock;
    private final class_2248 oreStorageBlock;
    private final class_2199 anvil;
    private final String name;
    private final boolean fireproof;
    private final Multimap<class_2248, class_2960> miningLevels;
    private final Multimap<class_2199, class_2960> anvilMap;
    private final Map<String, class_2431> oreVariants;
    private final boolean uncommon;

    private BlockSet(String name, class_2431 ore, class_2248 storageBlock, class_2248 oreStorageBlock, class_2199 anvil, Map<String, class_2431> oreVariants, boolean fireproof, Multimap<class_2248, class_2960> miningLevels, Multimap<class_2199, class_2960> anvilMap, boolean uncommon) {
        this.name = name;
        this.fireproof = fireproof;
        this.ore = ore;
        this.storageBlock = storageBlock;
        this.oreStorageBlock = oreStorageBlock;
        this.anvil = anvil;
        this.oreVariants = oreVariants;
        this.miningLevels = miningLevels;
        this.anvilMap = anvilMap;
        this.uncommon = uncommon;
    }

    private void register() {
        if (this.ore != null) {
            RegistryHelper.block(this.name + "_ore", (class_2248)this.ore, this.fireproof, this.uncommon);
        }
        this.oreVariants.forEach((s, block) -> RegistryHelper.block(s + "_" + this.name + "_ore", (class_2248)block, this.fireproof, this.uncommon));
        if (this.oreStorageBlock != null) {
            RegistryHelper.block("raw_" + this.name + "_block", this.oreStorageBlock, this.fireproof, this.uncommon);
        }
        if (this.storageBlock != null) {
            RegistryHelper.block(this.name + "_block", this.storageBlock, this.fireproof, this.uncommon);
        }
        if (this.anvil != null) {
            RegistryHelper.block(this.name + "_anvil", (class_2248)this.anvil, this.fireproof, this.uncommon);
        }
        if (MythicMetals.CONFIG.enableAnvils()) {
            this.anvilMap.forEach((anvilBlock, level) -> {
                TagInjector.inject((class_2378)class_7923.field_41175, (class_2960)RegistryHelper.id("anvils"), (Object[])new class_2248[]{anvilBlock});
                TagInjector.inject((class_2378)class_7923.field_41175, (class_2960)level, (Object[])new class_2248[]{anvilBlock});
                TagInjector.inject((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60654((String)"anvil"), (Object[])new class_2248[]{anvilBlock});
                TagInjector.inject((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60654((String)"anvil"), (Object[])new class_1792[]{anvilBlock.method_8389()});
            });
        }
        this.miningLevels.forEach((block, level) -> {
            TagInjector.inject((class_2378)class_7923.field_41175, (class_2960)level, (Object[])new class_2248[]{block});
            TagInjector.inject((class_2378)class_7923.field_41175, (class_2960)RegistryHelper.id("blocks"), (Object[])new class_2248[]{block});
        });
    }

    public class_2431 getOre() {
        return this.ore;
    }

    public class_2248 getStorageBlock() {
        return this.storageBlock;
    }

    public class_2248 getOreStorageBlock() {
        return this.oreStorageBlock;
    }

    public class_2431 getOreVariant(String variant) {
        return this.oreVariants.get(variant);
    }

    public class_2199 getAnvil() {
        return this.anvil;
    }

    public Set<class_2248> getOreVariants() {
        return ImmutableSet.copyOf(this.oreVariants.values());
    }

    public Map<String, class_2248> getOreVariantsMap() {
        return Map.copyOf(this.oreVariants);
    }

    public String getName() {
        return this.name;
    }

    public static class Builder {
        private static final List<BlockSet> toBeRegistered = new ArrayList<BlockSet>();
        private final String name;
        private final boolean fireproof;
        private final Map<String, class_2431> oreVariants = new LinkedHashMap<String, class_2431>();
        private class_2431 ore = null;
        private class_2248 storageBlock = null;
        private class_2248 oreStorageBlock = null;
        private class_2199 anvil = null;
        private class_2498 currentSounds = class_2498.field_11544;
        private float currentHardness = -1.0f;
        private float currentResistance = -1.0f;
        private final Multimap<class_2248, class_2960> miningLevels = HashMultimap.create();
        private final Multimap<class_2199, class_2960> anvilMap = HashMultimap.create();
        private final Consumer<class_4970.class_2251> settingsProcessor = settings -> {};
        private final class_2960 SHOVEL = class_2960.method_60654((String)"mineable/shovel");
        private final class_2960 PICKAXE = class_2960.method_60654((String)"mineable/pickaxe");
        private boolean uncommon = false;

        private Builder(String name, boolean fireproof) {
            this.name = name;
            this.fireproof = fireproof;
        }

        public static Builder begin(String name, boolean fireproof) {
            return new Builder(name, fireproof);
        }

        public static void register() {
            toBeRegistered.forEach(blockSet -> {
                MythicBlocks.BLOCKSET_MAP.put(blockSet.name, (BlockSet)blockSet);
                blockSet.register();
            });
            toBeRegistered.clear();
        }

        public static class_4970.class_2251 blockSettings(float hardness, float resistance, class_2498 sounds) {
            return class_4970.class_2251.method_9637().method_9629(hardness, resistance).method_9626(sounds).method_51369().method_29292();
        }

        public Builder createDefaultSet(float strength, class_2960 miningLevel, class_2960 higherMiningLevel) {
            return this.strength(strength).createOre(miningLevel).strength(strength + 1.0f).createOreStorageBlock(miningLevel).createStorageBlock(higherMiningLevel).createAnvil(miningLevel);
        }

        public Builder createBlockSet(float strength, class_2960 miningLevel, class_2960 storageMiningLevel) {
            return this.strength(strength).createOre(miningLevel).strength(strength + 1.0f).createStorageBlock(storageMiningLevel).createOreStorageBlock(storageMiningLevel);
        }

        public Builder createDefaultSet(float oreStrength, class_2960 oreMiningLevel, float storageStrength, class_2960 storageMiningLevel) {
            return this.strength(oreStrength).createOre(oreMiningLevel).strength(storageStrength).createStorageBlock(storageMiningLevel).createOreStorageBlock(storageMiningLevel);
        }

        public Builder createAnvilSet(float strength, class_2960 miningLevel) {
            return this.strength(strength).sounds(class_2498.field_11533).createStorageBlock(miningLevel).createAnvil(miningLevel);
        }

        public Builder createAnvilSet(float hardness, float resistance, class_2960 miningLevel) {
            return this.strength(hardness, resistance).createStorageBlock(this.currentSounds, miningLevel).createAnvil(miningLevel);
        }

        public Builder sounds(class_2498 sounds) {
            this.currentSounds = sounds;
            return this;
        }

        public Builder strength(float strength) {
            return this.strength(strength, strength + 1.0f);
        }

        public Builder strength(float hardness, float resistance) {
            this.currentHardness = hardness;
            this.currentResistance = resistance;
            return this;
        }

        public Builder createOre(class_2960 miningLevel) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.ore = new class_2431((class_6017)class_6016.field_29942, settings);
            this.miningLevels.put((Object)this.ore, (Object)miningLevel);
            this.miningLevels.put((Object)this.ore, (Object)this.PICKAXE);
            return this;
        }

        public Builder createOre(class_2960 miningLevel, class_6019 experience) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.ore = new class_2431((class_6017)experience, settings);
            this.miningLevels.put((Object)this.ore, (Object)miningLevel);
            this.miningLevels.put((Object)this.ore, (Object)this.PICKAXE);
            return this;
        }

        public Builder createLuminantOre(class_2960 miningLevel, class_6019 experience, int luminance) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds).method_9631(blockState -> luminance);
            this.settingsProcessor.accept(settings);
            this.ore = new class_2431((class_6017)class_6016.field_29942, settings);
            this.miningLevels.put((Object)this.ore, (Object)miningLevel);
            this.miningLevels.put((Object)this.ore, (Object)this.PICKAXE);
            Maldenhagen.injectCopium((class_2248)this.ore);
            return this;
        }

        public Builder createOreVariant(String name, class_2960 miningLevel) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.oreVariants.put(name, new class_2431((class_6017)class_6016.field_29942, settings));
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)miningLevel);
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)this.PICKAXE);
            return this;
        }

        public Builder createOreVariant(String name, class_2960 miningLevel, class_6019 experience) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.oreVariants.put(name, new class_2431((class_6017)experience, settings));
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)miningLevel);
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)this.PICKAXE);
            return this;
        }

        public Builder createOreVariant(String name, class_2960 miningLevel, class_6019 experience, int luminance) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds).method_9631(blockState -> luminance);
            this.settingsProcessor.accept(settings);
            this.oreVariants.put(name, new class_2431((class_6017)experience, settings));
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)miningLevel);
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)this.PICKAXE);
            Maldenhagen.injectCopium((class_2248)((class_2248)this.oreVariants.get(name)));
            return this;
        }

        public Builder createStarriteOre(class_2960 miningLevel, class_6019 experience) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.ore = new StarriteOreBlock(settings, experience);
            this.miningLevels.put((Object)this.ore, (Object)miningLevel);
            this.miningLevels.put((Object)this.ore, (Object)this.PICKAXE);
            return this;
        }

        public Builder createBanglumOre(class_2960 miningLevel) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.ore = new BanglumOreBlock(settings);
            this.miningLevels.put((Object)this.ore, (Object)miningLevel);
            this.miningLevels.put((Object)this.ore, (Object)this.PICKAXE);
            return this;
        }

        public Builder createStarriteOreVariant(String name, class_2960 miningLevel, class_6019 experience) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.oreVariants.put(name, new StarriteOreBlock(settings, experience));
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)miningLevel);
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)this.PICKAXE);
            return this;
        }

        public Builder createBanglumOreVariant(String name, class_2960 miningLevel) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.oreVariants.put(name, new BanglumOreBlock(settings));
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)miningLevel);
            this.miningLevels.put((Object)((class_2248)this.oreVariants.get(name)), (Object)this.PICKAXE);
            return this;
        }

        public Builder createAmethystStorageBlock(class_2960 miningLevel) {
            this.storageBlock = new class_5541(Builder.blockSettings(this.currentHardness, this.currentResistance, class_2498.field_27197));
            this.miningLevels.put((Object)this.storageBlock, (Object)miningLevel);
            this.miningLevels.put((Object)this.storageBlock, (Object)this.PICKAXE);
            return this;
        }

        public Builder createStorageBlock(class_2960 miningLevel) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.storageBlock = new class_2248(settings);
            this.miningLevels.put((Object)this.storageBlock, (Object)miningLevel);
            this.miningLevels.put((Object)this.storageBlock, (Object)this.PICKAXE);
            return this;
        }

        public Builder createStorageBlock(class_2498 sounds, class_2960 miningLevel) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, sounds);
            this.settingsProcessor.accept(settings);
            this.storageBlock = new class_2248(settings);
            this.miningLevels.put((Object)this.storageBlock, (Object)miningLevel);
            this.miningLevels.put((Object)this.storageBlock, (Object)this.PICKAXE);
            return this;
        }

        public Builder createOreStorageBlock(class_2960 miningLevel) {
            class_4970.class_2251 settings = Builder.blockSettings(this.currentHardness, this.currentResistance, this.currentSounds);
            this.settingsProcessor.accept(settings);
            this.oreStorageBlock = new class_2248(settings);
            this.miningLevels.put((Object)this.oreStorageBlock, (Object)miningLevel);
            this.miningLevels.put((Object)this.oreStorageBlock, (Object)this.PICKAXE);
            return this;
        }

        public Builder createAnvil(class_2960 miningLevel) {
            if (MythicMetals.CONFIG.enableAnvils()) {
                class_4970.class_2251 settings = Builder.blockSettings(5.0f, 15000.0f, class_2498.field_11531);
                this.settingsProcessor.accept(settings);
                this.anvil = new class_2199(settings);
                this.anvilMap.put((Object)this.anvil, (Object)miningLevel);
                this.anvilMap.put((Object)this.anvil, (Object)this.PICKAXE);
            }
            return this;
        }

        public <T extends class_2248> Builder createCustomStorageBlock(T block, class_2960 miningLevel) {
            this.storageBlock = block;
            this.miningLevels.put((Object)this.storageBlock, (Object)miningLevel);
            this.miningLevels.put((Object)this.storageBlock, (Object)this.PICKAXE);
            return this;
        }

        public Builder createCustomStorageBlock(class_2960 miningLevel, class_4970.class_2251 settings) {
            this.settingsProcessor.accept(settings);
            this.storageBlock = new class_2248(settings);
            this.miningLevels.put((Object)this.storageBlock, (Object)miningLevel);
            this.miningLevels.put((Object)this.storageBlock, (Object)this.PICKAXE);
            return this;
        }

        public Builder uncommon() {
            this.uncommon = true;
            return this;
        }

        public BlockSet finish() {
            BlockSet set = new BlockSet(this.name, this.ore, this.storageBlock, this.oreStorageBlock, this.anvil, this.oreVariants, this.fireproof, this.miningLevels, this.anvilMap, this.uncommon);
            toBeRegistered.add(set);
            return set;
        }
    }
}

