/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_4966;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;

public final class JigsawStructureFlatnessCheck {
    public static boolean checkFlatness(StructureData structureData, class_6122 startHeight, class_3195.class_7149 generationContext) {
        int flatnessCheckDistance = structureData.getFlatnessCheckDistance();
        int offsetStep = (int)Math.ceil((float)flatnessCheckDistance / 2.0f);
        int stepAmount = (int)Math.pow((double)(2 * flatnessCheckDistance) / (double)offsetStep + 1.0, 2.0);
        int allowedAirBlockSteps = stepAmount / 2;
        int allowedLiquidBlockSteps = stepAmount / 2;
        int flatnessCheckThreshold = structureData.getFlatnessCheckThreshold();
        boolean areAirBlocksAllowed = structureData.areAirBlocksAllowedInFlatnessCheck();
        boolean areLiquidBlocksAllowed = structureData.areLiquidBlocksAllowedInFlatnessCheck();
        if (flatnessCheckDistance == 0 || flatnessCheckThreshold == 0) {
            return true;
        }
        class_1923 chunkPos = generationContext.comp_568();
        int y = startHeight.method_35391((class_5819)generationContext.comp_566(), new class_5868(generationContext.comp_562(), generationContext.comp_569()));
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), y, chunkPos.method_8328());
        int baseX = blockPos.method_10263();
        int baseZ = blockPos.method_10260();
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        int airBlockSteps = 0;
        int fluidBlockSteps = 0;
        for (int xOffset = -flatnessCheckDistance; xOffset <= flatnessCheckDistance; xOffset += offsetStep) {
            for (int zOffset = -flatnessCheckDistance; zOffset <= flatnessCheckDistance; zOffset += offsetStep) {
                int x = xOffset + baseX;
                int z = zOffset + baseZ;
                int height = generationContext.comp_562().method_18028(x, z, class_2902.class_2903.field_13194, generationContext.comp_569(), generationContext.comp_564());
                minHeight = Math.min(minHeight, height);
                if ((maxHeight = Math.max(maxHeight, height)) - minHeight > flatnessCheckThreshold) {
                    return false;
                }
                if (areAirBlocksAllowed && areLiquidBlocksAllowed) continue;
                class_4966 blockView = generationContext.comp_562().method_26261(x, z, generationContext.comp_569(), generationContext.comp_564());
                class_2680 blockState = blockView.method_32892(height);
                if (!areAirBlocksAllowed && blockState.method_26215() && ++airBlockSteps >= allowedAirBlockSteps) {
                    return false;
                }
                if (areLiquidBlocksAllowed || blockState.method_26227().method_15769() || ++fluidBlockSteps < allowedLiquidBlockSteps) continue;
                return false;
            }
        }
        return true;
    }
}

